/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.CSCMatrix;
import java.io.Serializable;
import java.util.Random;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseMatrix$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.SparseMatrix$;
import org.apache.spark.mllib.linalg.Vector;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class Matrices$ {
    public static Matrices$ MODULE$;

    static {
        new Matrices$();
    }

    public Matrix dense(int numRows, int numCols, double[] values) {
        return new DenseMatrix(numRows, numCols, values);
    }

    public Matrix sparse(int numRows, int numCols, int[] colPtrs, int[] rowIndices, double[] values) {
        return new SparseMatrix(numRows, numCols, colPtrs, rowIndices, values);
    }

    public Matrix fromBreeze(breeze.linalg.Matrix<Object> breeze) {
        Matrix matrix;
        breeze.linalg.Matrix<Object> matrix2 = breeze;
        if (matrix2 instanceof breeze.linalg.DenseMatrix) {
            breeze.linalg.DenseMatrix denseMatrix = (breeze.linalg.DenseMatrix)matrix2;
            matrix = new DenseMatrix(denseMatrix.rows(), denseMatrix.cols(), denseMatrix.data$mcD$sp(), denseMatrix.isTranspose());
        } else if (matrix2 instanceof CSCMatrix) {
            CSCMatrix cSCMatrix;
            CSCMatrix cSCMatrix2 = (CSCMatrix)matrix2;
            if (cSCMatrix2.rowIndices().length > cSCMatrix2.activeSize()) {
                CSCMatrix csm = cSCMatrix2.copy$mcD$sp();
                csm.compact();
                cSCMatrix = csm;
            } else {
                cSCMatrix = cSCMatrix2;
            }
            CSCMatrix nsm = cSCMatrix;
            matrix = new SparseMatrix(nsm.rows(), nsm.cols(), nsm.colPtrs(), nsm.rowIndices(), nsm.data$mcD$sp());
        } else {
            throw new UnsupportedOperationException(new StringBuilder(37).append("Do not support conversion from type ").append(breeze.getClass().getName()).append(".").toString());
        }
        return matrix;
    }

    public Matrix zeros(int numRows, int numCols) {
        return DenseMatrix$.MODULE$.zeros(numRows, numCols);
    }

    public Matrix ones(int numRows, int numCols) {
        return DenseMatrix$.MODULE$.ones(numRows, numCols);
    }

    public Matrix eye(int n) {
        return DenseMatrix$.MODULE$.eye(n);
    }

    public Matrix speye(int n) {
        return SparseMatrix$.MODULE$.speye(n);
    }

    public Matrix rand(int numRows, int numCols, Random rng) {
        return DenseMatrix$.MODULE$.rand(numRows, numCols, rng);
    }

    public Matrix sprand(int numRows, int numCols, double density, Random rng) {
        return SparseMatrix$.MODULE$.sprand(numRows, numCols, density, rng);
    }

    public Matrix randn(int numRows, int numCols, Random rng) {
        return DenseMatrix$.MODULE$.randn(numRows, numCols, rng);
    }

    public Matrix sprandn(int numRows, int numCols, double density, Random rng) {
        return SparseMatrix$.MODULE$.sprandn(numRows, numCols, density, rng);
    }

    public Matrix diag(Vector vector) {
        return DenseMatrix$.MODULE$.diag(vector);
    }

    public Matrix horzcat(Matrix[] matrices) {
        Matrix matrix;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matrices)).isEmpty()) {
            return new DenseMatrix(0, 0, (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
        }
        if (matrices.length == 1) {
            return matrices[0];
        }
        int numRows = matrices[0].numRows();
        BooleanRef hasSparse = BooleanRef.create((boolean)false);
        IntRef numCols = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matrices)).foreach((Function1 & Serializable & scala.Serializable)mat -> {
            Matrices$.$anonfun$horzcat$1(numRows, hasSparse, numCols, mat);
            return BoxedUnit.UNIT;
        });
        if (!hasSparse.elem) {
            matrix = new DenseMatrix(numRows, numCols.elem, (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matrices)).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$3.toArray())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        } else {
            IntRef startCol = IntRef.create((int)0);
            Tuple3[] entries = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matrices)).flatMap((Function1 & Serializable & scala.Serializable)mat -> {
                ArrayBuffer arrayBuffer;
                int nCols = mat.numCols();
                Matrix matrix = mat;
                if (matrix instanceof SparseMatrix) {
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    Tuple3[] data = new Tuple3[sparseMatrix.values().length];
                    IntRef cnt = IntRef.create((int)0);
                    sparseMatrix.foreachActive((Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(i, j, v) -> {
                        Matrices$.$anonfun$horzcat$5(data, cnt, startCol, BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j), BoxesRunTime.unboxToDouble((Object)v));
                        return BoxedUnit.UNIT;
                    });
                    startCol$1.elem += nCols;
                    arrayBuffer = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data));
                } else if (matrix instanceof DenseMatrix) {
                    DenseMatrix denseMatrix = (DenseMatrix)matrix;
                    ArrayBuffer data = new ArrayBuffer();
                    denseMatrix.foreachActive((Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(i, j, v) -> {
                        Matrices$.$anonfun$horzcat$6(data, startCol, BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j), BoxesRunTime.unboxToDouble((Object)v));
                        return BoxedUnit.UNIT;
                    });
                    startCol$1.elem += nCols;
                    arrayBuffer = data;
                } else {
                    throw new MatchError((Object)matrix);
                }
                return arrayBuffer;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            matrix = SparseMatrix$.MODULE$.fromCOO(numRows, numCols.elem, (Iterable<Tuple3<Object, Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])entries));
        }
        return matrix;
    }

    public Matrix vertcat(Matrix[] matrices) {
        Matrix matrix;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matrices)).isEmpty()) {
            return new DenseMatrix(0, 0, (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
        }
        if (matrices.length == 1) {
            return matrices[0];
        }
        int numCols = matrices[0].numCols();
        BooleanRef hasSparse = BooleanRef.create((boolean)false);
        IntRef numRows = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matrices)).foreach((Function1 & Serializable & scala.Serializable)mat -> {
            Matrices$.$anonfun$vertcat$1(numCols, hasSparse, numRows, mat);
            return BoxedUnit.UNIT;
        });
        if (!hasSparse.elem) {
            double[] allValues = new double[numRows.elem * numCols];
            IntRef startRow = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matrices)).foreach((Function1 & Serializable & scala.Serializable)mat -> {
                Matrices$.$anonfun$vertcat$3(numRows, startRow, allValues, mat);
                return BoxedUnit.UNIT;
            });
            matrix = new DenseMatrix(numRows.elem, numCols, allValues);
        } else {
            IntRef startRow = IntRef.create((int)0);
            Tuple3[] entries = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matrices)).flatMap((Function1 & Serializable & scala.Serializable)mat -> {
                ArrayBuffer arrayBuffer;
                int nRows = mat.numRows();
                Matrix matrix = mat;
                if (matrix instanceof SparseMatrix) {
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    Tuple3[] data = new Tuple3[sparseMatrix.values().length];
                    IntRef cnt = IntRef.create((int)0);
                    sparseMatrix.foreachActive((Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(i, j, v) -> {
                        Matrices$.$anonfun$vertcat$6(data, cnt, startRow, BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j), BoxesRunTime.unboxToDouble((Object)v));
                        return BoxedUnit.UNIT;
                    });
                    startRow$2.elem += nRows;
                    arrayBuffer = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data));
                } else if (matrix instanceof DenseMatrix) {
                    DenseMatrix denseMatrix = (DenseMatrix)matrix;
                    ArrayBuffer data = new ArrayBuffer();
                    denseMatrix.foreachActive((Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(i, j, v) -> {
                        Matrices$.$anonfun$vertcat$7(data, startRow, BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j), BoxesRunTime.unboxToDouble((Object)v));
                        return BoxedUnit.UNIT;
                    });
                    startRow$2.elem += nRows;
                    arrayBuffer = data;
                } else {
                    throw new MatchError((Object)matrix);
                }
                return arrayBuffer;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            matrix = SparseMatrix$.MODULE$.fromCOO(numRows.elem, numCols, (Iterable<Tuple3<Object, Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])entries));
        }
        return matrix;
    }

    public Matrix fromML(org.apache.spark.ml.linalg.Matrix m) {
        Matrix matrix;
        org.apache.spark.ml.linalg.Matrix matrix2 = m;
        if (matrix2 instanceof org.apache.spark.ml.linalg.DenseMatrix) {
            org.apache.spark.ml.linalg.DenseMatrix denseMatrix = (org.apache.spark.ml.linalg.DenseMatrix)matrix2;
            matrix = DenseMatrix$.MODULE$.fromML(denseMatrix);
        } else if (matrix2 instanceof org.apache.spark.ml.linalg.SparseMatrix) {
            org.apache.spark.ml.linalg.SparseMatrix sparseMatrix = (org.apache.spark.ml.linalg.SparseMatrix)matrix2;
            matrix = SparseMatrix$.MODULE$.fromML(sparseMatrix);
        } else {
            throw new MatchError((Object)matrix2);
        }
        return matrix;
    }

    public static final /* synthetic */ void $anonfun$horzcat$1(int numRows$7, BooleanRef hasSparse$1, IntRef numCols$7, Matrix mat) {
        Predef$.MODULE$.require(numRows$7 == mat.numRows(), (Function0 & Serializable & scala.Serializable)() -> "The number of rows of the matrices in this sequence, don't match!");
        Matrix matrix = mat;
        if (matrix instanceof SparseMatrix) {
            hasSparse$1.elem = true;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (matrix instanceof DenseMatrix) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(78).append("Unsupported matrix format. Expected ").append("SparseMatrix or DenseMatrix. Instead got: ").append(mat.getClass()).toString());
        }
        numCols$7.elem += mat.numCols();
    }

    public static final /* synthetic */ void $anonfun$horzcat$5(Tuple3[] data$1, IntRef cnt$1, IntRef startCol$1, int i, int j, double v) {
        data$1[cnt$1.elem] = new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)(j + startCol$1.elem)), (Object)BoxesRunTime.boxToDouble((double)v));
        ++cnt$1.elem;
    }

    public static final /* synthetic */ void $anonfun$horzcat$6(ArrayBuffer data$2, IntRef startCol$1, int i, int j, double v) {
        block0: {
            if (v == 0.0) break block0;
            data$2.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)(j + startCol$1.elem)), (Object)BoxesRunTime.boxToDouble((double)v)));
        }
    }

    public static final /* synthetic */ void $anonfun$vertcat$1(int numCols$8, BooleanRef hasSparse$2, IntRef numRows$8, Matrix mat) {
        Predef$.MODULE$.require(numCols$8 == mat.numCols(), (Function0 & Serializable & scala.Serializable)() -> "The number of rows of the matrices in this sequence, don't match!");
        Matrix matrix = mat;
        if (matrix instanceof SparseMatrix) {
            hasSparse$2.elem = true;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (matrix instanceof DenseMatrix) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(78).append("Unsupported matrix format. Expected ").append("SparseMatrix or DenseMatrix. Instead got: ").append(mat.getClass()).toString());
        }
        numRows$8.elem += mat.numRows();
    }

    public static final /* synthetic */ void $anonfun$vertcat$4(IntRef numRows$8, IntRef startRow$1, double[] allValues$1, int i, int j, double v) {
        int indStart = j * numRows$8.elem + startRow$1.elem;
        allValues$1[indStart + i] = v;
    }

    public static final /* synthetic */ void $anonfun$vertcat$3(IntRef numRows$8, IntRef startRow$1, double[] allValues$1, Matrix mat) {
        boolean j2 = false;
        int nRows = mat.numRows();
        mat.foreachActive((Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(i, j, v) -> {
            Matrices$.$anonfun$vertcat$4(numRows$8, startRow$1, allValues$1, BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j), BoxesRunTime.unboxToDouble((Object)v));
            return BoxedUnit.UNIT;
        });
        startRow$1.elem += nRows;
    }

    public static final /* synthetic */ void $anonfun$vertcat$6(Tuple3[] data$3, IntRef cnt$2, IntRef startRow$2, int i, int j, double v) {
        data$3[cnt$2.elem] = new Tuple3((Object)BoxesRunTime.boxToInteger((int)(i + startRow$2.elem)), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)v));
        ++cnt$2.elem;
    }

    public static final /* synthetic */ void $anonfun$vertcat$7(ArrayBuffer data$4, IntRef startRow$2, int i, int j, double v) {
        block0: {
            if (v == 0.0) break block0;
            data$4.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)(i + startRow$2.elem)), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)v)));
        }
    }

    private Matrices$() {
        MODULE$ = this;
    }
}

