/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.Serializable;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SchemaUtils$ {
    public static SchemaUtils$ MODULE$;

    static {
        new SchemaUtils$();
    }

    public void checkColumnType(StructType schema, String colName, DataType dataType, String msg) {
        DataType actualDataType = schema.apply(colName).dataType();
        String message = msg != null && msg.trim().length() > 0 ? new StringBuilder(1).append(" ").append(msg).toString() : "";
        Predef$.MODULE$.require(actualDataType.equals((Object)dataType), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Column ").append(colName).append(" must be of type ").append(dataType.catalogString()).append(" but was actually ").append(actualDataType.catalogString()).append(".").append(message).toString());
    }

    public String checkColumnType$default$4() {
        return "";
    }

    public void checkColumnTypes(StructType schema, String colName, Seq<DataType> dataTypes, String msg) {
        DataType actualDataType = schema.apply(colName).dataType();
        String message = msg != null && msg.trim().length() > 0 ? new StringBuilder(1).append(" ").append(msg).toString() : "";
        Predef$.MODULE$.require(dataTypes.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)actualDataType.equals(x$1))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Column ").append(colName).append(" must be of type equal to one of the following types: ").append(((TraversableOnce)dataTypes.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.catalogString(), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).append(" but was actually of type ").append(actualDataType.catalogString()).append(".").append(message).toString());
    }

    public String checkColumnTypes$default$4() {
        return "";
    }

    public void checkNumericType(StructType schema, String colName, String msg) {
        DataType actualDataType = schema.apply(colName).dataType();
        String message = msg != null && msg.trim().length() > 0 ? new StringBuilder(1).append(" ").append(msg).toString() : "";
        Predef$.MODULE$.require(actualDataType instanceof NumericType, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Column ").append(colName).append(" must be of type ").append(NumericType$.MODULE$.simpleString()).append(" but was actually of type ").append(actualDataType.catalogString()).append(".").append(message).toString());
    }

    public String checkNumericType$default$3() {
        return "";
    }

    public StructType appendColumn(StructType schema, String colName, DataType dataType, boolean nullable) {
        if (colName.isEmpty()) {
            return schema;
        }
        return this.appendColumn(schema, new StructField(colName, dataType, nullable, StructField$.MODULE$.apply$default$4()));
    }

    public StructType appendColumn(StructType schema, StructField col) {
        Predef$.MODULE$.require(!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).contains((Object)col.name()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Column ").append(col.name()).append(" already exists.").toString());
        return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).$colon$plus((Object)col, ClassTag$.MODULE$.apply(StructField.class)));
    }

    public boolean appendColumn$default$4() {
        return false;
    }

    public void validateVectorCompatibleColumn(StructType schema, String colName) {
        .colon.colon typeCandidates = new .colon.colon((Object)new VectorUDT(), (List)new .colon.colon((Object)new ArrayType((DataType)DoubleType$.MODULE$, false), (List)new .colon.colon((Object)new ArrayType((DataType)FloatType$.MODULE$, false), (List)Nil$.MODULE$)));
        this.checkColumnTypes(schema, colName, (Seq<DataType>)typeCandidates, this.checkColumnTypes$default$4());
    }

    private SchemaUtils$() {
        MODULE$ = this;
    }
}

