/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.Serializable;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.UnresolvedAttribute$;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class MetadataUtils$ {
    public static MetadataUtils$ MODULE$;

    static {
        new MetadataUtils$();
    }

    public Option<Object> getNumClasses(StructField labelSchema) {
        None$ none$;
        Attribute attribute = Attribute$.MODULE$.fromStructField(labelSchema);
        if (attribute instanceof BinaryAttribute) {
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)2));
        } else if (attribute instanceof NominalAttribute) {
            NominalAttribute nominalAttribute = (NominalAttribute)attribute;
            none$ = nominalAttribute.getNumValues();
        } else {
            boolean bl = attribute instanceof NumericAttribute ? true : UnresolvedAttribute$.MODULE$.equals(attribute);
            if (bl) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)attribute);
            }
        }
        return none$;
    }

    public Map<Object, Object> getCategoricalFeatures(StructField featuresSchema) {
        AttributeGroup metadata = AttributeGroup$.MODULE$.fromStructField(featuresSchema);
        return metadata.attributes().isEmpty() ? HashMap$.MODULE$.empty() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadata.attributes().get())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterator iterator;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Attribute attr = (Attribute)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (attr == null) {
                    iterator = package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                } else {
                    Iterator iterator2;
                    Attribute attribute = attr;
                    boolean bl = attribute instanceof NumericAttribute ? true : UnresolvedAttribute$.MODULE$.equals(attribute);
                    if (bl) {
                        iterator2 = package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                    } else if (attribute instanceof BinaryAttribute) {
                        iterator2 = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)idx)), (Object)BoxesRunTime.boxToInteger((int)2))}));
                    } else if (attribute instanceof NominalAttribute) {
                        int numValues;
                        NominalAttribute nominalAttribute = (NominalAttribute)attribute;
                        Option<Object> option = nominalAttribute.getNumValues();
                        if (!(option instanceof Some)) {
                            if (None$.MODULE$.equals(option)) {
                                throw new IllegalArgumentException(new StringBuilder(97).append("Feature ").append(idx).append(" is marked as").append(" Nominal (categorical), but it does not have the number of values specified.").toString());
                            }
                            throw new MatchError(option);
                        }
                        Some some = (Some)option;
                        int n = numValues = BoxesRunTime.unboxToInt((Object)some.value());
                        Iterator iterator3 = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)idx)), (Object)BoxesRunTime.boxToInteger((int)n))}));
                        iterator2 = iterator3;
                    } else {
                        throw new MatchError((Object)attribute);
                    }
                    iterator = iterator2;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Iterator iterator4 = iterator;
            return iterator4;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public int[] getFeatureIndicesFromNames(StructField col, String[] names) {
        Predef$.MODULE$.require(col.dataType() instanceof VectorUDT, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("getFeatureIndicesFromNames expected column ").append(col).append(" to be Vector type, but it was type ").append(col.dataType()).append(" instead.").toString());
        AttributeGroup inputAttr = AttributeGroup$.MODULE$.fromStructField(col);
        return (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])names)).map((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToInteger((int)MetadataUtils$.$anonfun$getFeatureIndicesFromNames$2(inputAttr, col, name)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    public static final /* synthetic */ int $anonfun$getFeatureIndicesFromNames$2(AttributeGroup inputAttr$1, StructField col$1, String name) {
        Predef$.MODULE$.require(inputAttr$1.hasAttr(name), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("getFeatureIndicesFromNames found no feature with name ").append(name).append(" in column ").append(col$1).append(".").toString());
        return BoxesRunTime.unboxToInt((Object)inputAttr$1.getAttr(name).index().get());
    }

    private MetadataUtils$() {
        MODULE$ = this;
    }
}

