/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasValidationIndicatorCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel;
import org.apache.spark.ml.regression.GBTRegressor$;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.GBTRegressorParams;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.TreeRegressorParams;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.functions$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001\u0002\u0010 \u0001)B\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t%\u0014\u0005\tI\u0002\u0011\t\u0011)A\u0005\u001d\")a\r\u0001C\u0001O\")a\r\u0001C\u0001W\")Q\u000e\u0001C!]\")q\u000f\u0001C!q\")1\u0010\u0001C!y\"1q\u0010\u0001C!\u0003\u0003Aq!!\u0004\u0001\t\u0003\ny\u0001C\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!9\u00111\u0006\u0001\u0005B\u00055\u0002bBA\u001a\u0001\u0011\u0005\u0013Q\u0007\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\tI\u0005\u0001C!\u0003\u0017Bq!!\u0015\u0001\t\u0003\n\u0019\u0006C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002d!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0004bBA=\u0001\u0011E\u00131\u0010\u0005\b\u0003K\u0003A\u0011IAT\u00119\tY\f\u0001I\u0001\u0004\u0003\u0005I\u0011BA_\u0003[<q!a> \u0011\u0003\tIP\u0002\u0004\u001f?!\u0005\u00111 \u0005\u0007Mb!\tAa\u0004\t\u0013\tE\u0001D1A\u0005\u0006\tM\u0001\u0002\u0003B\u000f1\u0001\u0006iA!\u0006\t\u000f\t\u0005\u0002\u0004\"\u0011\u0003$!I!q\u0006\r\u0002\u0002\u0013%!\u0011\u0007\u0002\r\u000f\n#&+Z4sKN\u001cxN\u001d\u0006\u0003A\u0005\n!B]3he\u0016\u001c8/[8o\u0015\t\u00113%\u0001\u0002nY*\u0011A%J\u0001\u0006gB\f'o\u001b\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001Y#\b\u0011$\u0011\u000b1js&N\u001c\u000e\u0003\u0005J!AL\u0011\u0003\u0013A\u0013X\rZ5di>\u0014\bC\u0001\u00194\u001b\u0005\t$B\u0001\u001a\"\u0003\u0019a\u0017N\\1mO&\u0011A'\r\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005Y\u0002Q\"A\u0010\u0011\u0005YB\u0014BA\u001d \u0005I9%\t\u0016*fOJ,7o]5p]6{G-\u001a7\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u\n\u0013\u0001\u0002;sK\u0016L!a\u0010\u001f\u0003%\u001d\u0013EKU3he\u0016\u001c8o\u001c:QCJ\fWn\u001d\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\u0006\nA!\u001e;jY&\u0011QI\u0011\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:Xe&$\u0018M\u00197f!\t9%*D\u0001I\u0015\tI5%\u0001\u0005j]R,'O\\1m\u0013\tY\u0005JA\u0004M_\u001e<\u0017N\\4\u0002\u0007ULG-F\u0001O!\ty\u0005L\u0004\u0002Q-B\u0011\u0011\u000bV\u0007\u0002%*\u00111+K\u0001\u0007yI|w\u000e\u001e \u000b\u0003U\u000bQa]2bY\u0006L!a\u0016+\u0002\rA\u0013X\rZ3g\u0013\tI&L\u0001\u0004TiJLgn\u001a\u0006\u0003/RC3!\u0001/c!\ti\u0006-D\u0001_\u0015\ty6%\u0001\u0006b]:|G/\u0019;j_:L!!\u00190\u0003\u000bMKgnY3\"\u0003\r\fQ!\r\u00185]A\nA!^5eA!\u001a!\u0001\u00182\u0002\rqJg.\u001b;?)\t)\u0004\u000eC\u0003M\u0007\u0001\u0007a\nK\u0002i9\nD3a\u0001/c)\u0005)\u0004f\u0001\u0003]E\u0006Y1/\u001a;NCb$U\r\u001d;i)\ty\u0007/D\u0001\u0001\u0011\u0015\tX\u00011\u0001s\u0003\u00151\u0018\r\\;f!\t\u0019H/D\u0001U\u0013\t)HKA\u0002J]RD3!\u0002/c\u0003)\u0019X\r^'bq\nKgn\u001d\u000b\u0003_fDQ!\u001d\u0004A\u0002ID3A\u0002/c\u0003Y\u0019X\r^'j]&s7\u000f^1oG\u0016\u001c\b+\u001a:O_\u0012,GCA8~\u0011\u0015\tx\u00011\u0001sQ\r9ALY\u0001\u000fg\u0016$X*\u001b8J]\u001a|w)Y5o)\ry\u00171\u0001\u0005\u0007c\"\u0001\r!!\u0002\u0011\u0007M\f9!C\u0002\u0002\nQ\u0013a\u0001R8vE2,\u0007f\u0001\u0005]E\u0006\u00012/\u001a;NCblU-\\8ss&sWJ\u0011\u000b\u0004_\u0006E\u0001\"B9\n\u0001\u0004\u0011\bfA\u0005]E\u0006y1/\u001a;DC\u000eDWMT8eK&#7\u000fF\u0002p\u00033Aa!\u001d\u0006A\u0002\u0005m\u0001cA:\u0002\u001e%\u0019\u0011q\u0004+\u0003\u000f\t{w\u000e\\3b]\"\u001a!\u0002\u00182\u0002+M,Go\u00115fG.\u0004x.\u001b8u\u0013:$XM\u001d<bYR\u0019q.a\n\t\u000bE\\\u0001\u0019\u0001:)\u0007-a&-A\u0006tKRLU\u000e];sSRLHcA8\u00020!)\u0011\u000f\u0004a\u0001\u001d\"\u001aA\u0002\u00182\u0002%M,GoU;cg\u0006l\u0007\u000f\\5oOJ\u000bG/\u001a\u000b\u0004_\u0006]\u0002BB9\u000e\u0001\u0004\t)\u0001K\u0002\u000e9\n\fqa]3u'\u0016,G\rF\u0002p\u0003\u007fAa!\u001d\bA\u0002\u0005\u0005\u0003cA:\u0002D%\u0019\u0011Q\t+\u0003\t1{gn\u001a\u0015\u0004\u001dq\u0013\u0017AC:fi6\u000b\u00070\u0013;feR\u0019q.!\u0014\t\u000bE|\u0001\u0019\u0001:)\u0007=a&-A\u0006tKR\u001cF/\u001a9TSj,GcA8\u0002V!1\u0011\u000f\u0005a\u0001\u0003\u000bA3\u0001\u0005/c\u0003-\u0019X\r\u001e'pgN$\u0016\u0010]3\u0015\u0007=\fi\u0006C\u0003r#\u0001\u0007a\nK\u0002\u00129\n\f\u0001d]3u\r\u0016\fG/\u001e:f'V\u00147/\u001a;TiJ\fG/Z4z)\ry\u0017Q\r\u0005\u0006cJ\u0001\rA\u0014\u0015\u0005%q\u000bI'\t\u0002\u0002l\u0005)!GL\u001a/a\u0005I2/\u001a;WC2LG-\u0019;j_:Le\u000eZ5dCR|'oQ8m)\ry\u0017\u0011\u000f\u0005\u0006cN\u0001\rA\u0014\u0015\u0005'q\u000b)(\t\u0002\u0002x\u0005)!G\f\u001b/a\u0005)AO]1j]R\u0019q'! \t\u000f\u0005}D\u00031\u0001\u0002\u0002\u00069A-\u0019;bg\u0016$\b\u0007BAB\u0003'\u0003b!!\"\u0002\f\u0006=UBAAD\u0015\r\tIiI\u0001\u0004gFd\u0017\u0002BAG\u0003\u000f\u0013q\u0001R1uCN,G\u000f\u0005\u0003\u0002\u0012\u0006ME\u0002\u0001\u0003\r\u0003+\u000bi(!A\u0001\u0002\u000b\u0005\u0011q\u0013\u0002\u0004?\u0012\n\u0014\u0003BAM\u0003?\u00032a]AN\u0013\r\ti\n\u0016\u0002\b\u001d>$\b.\u001b8h!\r\u0019\u0018\u0011U\u0005\u0004\u0003G#&aA!os\u0006!1m\u001c9z)\r)\u0014\u0011\u0016\u0005\b\u0003W+\u0002\u0019AAW\u0003\u0015)\u0007\u0010\u001e:b!\u0011\ty+!.\u000e\u0005\u0005E&bAAZC\u0005)\u0001/\u0019:b[&!\u0011qWAY\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bfA\u000b]E\u0006a2/\u001e9fe\u0012:W\r^(mI\n{wn\u001d;j]\u001e\u001cFO]1uK\u001eLHCBA`\u0003#\fY\u000e\u0005\u0003\u0002B\u00065WBAAb\u0015\u0011\t)-a2\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0015\ri\u0014\u0011\u001a\u0006\u0004\u0003\u0017\u001c\u0013!B7mY&\u0014\u0017\u0002BAh\u0003\u0007\u0014\u0001CQ8pgRLgnZ*ue\u0006$XmZ=\t\u000f\u0005Mg\u00031\u0001\u0002V\u0006\u00192-\u0019;fO>\u0014\u0018nY1m\r\u0016\fG/\u001e:fgB)q*a6se&\u0019\u0011\u0011\u001c.\u0003\u00075\u000b\u0007\u000fC\u0004\u0002^Z\u0001\r!a8\u0002\u000f=dG-\u00117h_B!\u0011\u0011]At\u001d\u0011\t\t-a9\n\t\u0005\u0015\u00181Y\u0001\u0005\u00032<w.\u0003\u0003\u0002j\u0006-(\u0001B!mO>TA!!:\u0002D&!\u0011q^Ay\u0003Y9W\r^(mI\n{wn\u001d;j]\u001e\u001cFO]1uK\u001eL\u0018bAAzy\tIqI\u0011+QCJ\fWn\u001d\u0015\u0004\u0001q\u0013\u0017\u0001D$C)J+wM]3tg>\u0014\bC\u0001\u001c\u0019'\u001dA\u0012Q B\u0002\u0005\u0013\u00012a]A\u0000\u0013\r\u0011\t\u0001\u0016\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005\u0013)!N\u0005\u0004\u0005\u000f\u0011%!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7OU3bI\u0006\u0014G.\u001a\t\u0004g\n-\u0011b\u0001B\u0007)\na1+\u001a:jC2L'0\u00192mKR\u0011\u0011\u0011`\u0001\u0013gV\u0004\bo\u001c:uK\u0012dun]:UsB,7/\u0006\u0002\u0003\u0016A!1Oa\u0006O\u0013\r\u0011I\u0002\u0016\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\u00045q\u0013\u0017aE:vaB|'\u000f^3e\u0019>\u001c8\u000fV=qKN\u0004\u0003fA\u000e]E\u0006!An\\1e)\r)$Q\u0005\u0005\u0007\u0005Oa\u0002\u0019\u0001(\u0002\tA\fG\u000f\u001b\u0015\u00059q\u0013Y#\t\u0002\u0003.\u0005)!G\f\u0019/a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\u0019\u0004\u0005\u0003\u00036\t}RB\u0001B\u001c\u0015\u0011\u0011IDa\u000f\u0002\t1\fgn\u001a\u0006\u0003\u0005{\tAA[1wC&!!\u0011\tB\u001c\u0005\u0019y%M[3di\"\u001a\u0001\u0004\u00182)\u0007]a&\r")
public class GBTRegressor
extends Predictor<Vector, GBTRegressor, GBTRegressionModel>
implements GBTRegressorParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> lossType;
    private final Param<String> impurity;
    private final DoubleParam validationTol;
    private final DoubleParam stepSize;
    private final Param<String> validationIndicatorCol;
    private final IntParam maxIter;
    private final DoubleParam subsamplingRate;
    private final Param<String> featureSubsetStrategy;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;

    public static GBTRegressor load(String string) {
        return GBTRegressor$.MODULE$.load(string);
    }

    public static String[] supportedLossTypes() {
        return GBTRegressor$.MODULE$.supportedLossTypes();
    }

    public static MLReader<GBTRegressor> read() {
        return GBTRegressor$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getLossType() {
        return GBTRegressorParams.getLossType$(this);
    }

    @Override
    public Loss getOldLossType() {
        return GBTRegressorParams.getOldLossType$(this);
    }

    @Override
    public Loss convertToOldLossType(String loss) {
        return GBTRegressorParams.convertToOldLossType$(this, loss);
    }

    @Override
    public final String getImpurity() {
        return TreeRegressorParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeRegressorParams.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final double getValidationTol() {
        return GBTParams.getValidationTol$(this);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams.getOldBoostingStrategy$(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final String getValidationIndicatorCol() {
        return HasValidationIndicatorCol.getValidationIndicatorCol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTRegressorParams$_setter_$lossType_$eq(Param<String> x$1) {
        this.lossType = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeRegressorParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final DoubleParam validationTol() {
        return this.validationTol;
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$validationTol_$eq(DoubleParam x$1) {
        this.validationTol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final Param<String> validationIndicatorCol() {
        return this.validationIndicatorCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasValidationIndicatorCol$_setter_$validationIndicatorCol_$eq(Param<String> x$1) {
        this.validationIndicatorCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    private /* synthetic */ BoostingStrategy super$getOldBoostingStrategy(Map categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams.getOldBoostingStrategy$(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public GBTRegressor setMaxDepth(int value) {
        return (GBTRegressor)this.set(this.maxDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public GBTRegressor setMaxBins(int value) {
        return (GBTRegressor)this.set(this.maxBins(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public GBTRegressor setMinInstancesPerNode(int value) {
        return (GBTRegressor)this.set(this.minInstancesPerNode(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public GBTRegressor setMinInfoGain(double value) {
        return (GBTRegressor)this.set(this.minInfoGain(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public GBTRegressor setMaxMemoryInMB(int value) {
        return (GBTRegressor)this.set(this.maxMemoryInMB(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public GBTRegressor setCacheNodeIds(boolean value) {
        return (GBTRegressor)this.set(this.cacheNodeIds(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public GBTRegressor setCheckpointInterval(int value) {
        return (GBTRegressor)this.set(this.checkpointInterval(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public GBTRegressor setImpurity(String value) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "GBTRegressor.setImpurity should NOT be used");
        return this;
    }

    @Override
    public GBTRegressor setSubsamplingRate(double value) {
        return (GBTRegressor)this.set(this.subsamplingRate(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public GBTRegressor setSeed(long value) {
        return (GBTRegressor)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public GBTRegressor setMaxIter(int value) {
        return (GBTRegressor)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public GBTRegressor setStepSize(double value) {
        return (GBTRegressor)this.set(this.stepSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public GBTRegressor setLossType(String value) {
        return (GBTRegressor)this.set(this.lossType(), value);
    }

    @Override
    public GBTRegressor setFeatureSubsetStrategy(String value) {
        return (GBTRegressor)this.set(this.featureSubsetStrategy(), value);
    }

    public GBTRegressor setValidationIndicatorCol(String value) {
        return (GBTRegressor)this.set(this.validationIndicatorCol(), value);
    }

    @Override
    public GBTRegressionModel train(Dataset<?> dataset) {
        return (GBTRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            Tuple2<DecisionTreeRegressionModel[], double[]> tuple2;
            Tuple2 tuple22;
            Map<Object, Object> categoricalFeatures = MetadataUtils$.MODULE$.getCategoricalFeatures(dataset.schema().apply(this.$(this.featuresCol())));
            boolean withValidation = this.isDefined(this.validationIndicatorCol()) && new StringOps(Predef$.MODULE$.augmentString(this.$(this.validationIndicatorCol()))).nonEmpty();
            Tuple2 tuple23 = tuple22 = withValidation ? new Tuple2(this.extractLabeledPoints(dataset.filter(functions$.MODULE$.not(functions$.MODULE$.col(this.$(this.validationIndicatorCol()))))), this.extractLabeledPoints(dataset.filter(functions$.MODULE$.col(this.$(this.validationIndicatorCol()))))) : new Tuple2(this.extractLabeledPoints(dataset), null);
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            RDD trainDataset = (RDD)tuple22._1();
            RDD validationDataset = (RDD)tuple22._2();
            Tuple2 tuple24 = new Tuple2((Object)trainDataset, (Object)validationDataset);
            Tuple2 tuple25 = tuple24;
            RDD trainDataset2 = (RDD)tuple25._1();
            RDD validationDataset2 = (RDD)tuple25._2();
            int numFeatures = ((LabeledPoint)trainDataset2.first()).features().size();
            BoostingStrategy boostingStrategy = this.super$getOldBoostingStrategy(categoricalFeatures, Algo$.MODULE$.Regression());
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.predictionCol(), this.impurity(), this.lossType(), this.maxDepth(), this.maxBins(), this.maxIter(), this.maxMemoryInMB(), this.minInfoGain(), this.minInstancesPerNode(), this.seed(), this.stepSize(), this.subsamplingRate(), this.cacheNodeIds(), this.checkpointInterval(), this.featureSubsetStrategy()}));
            instr.logNumFeatures(numFeatures);
            Tuple2<DecisionTreeRegressionModel[], double[]> tuple26 = tuple2 = withValidation ? GradientBoostedTrees$.MODULE$.runWithValidation((RDD<LabeledPoint>)trainDataset2, (RDD<LabeledPoint>)validationDataset2, boostingStrategy, BoxesRunTime.unboxToLong((Object)this.$(this.seed())), this.$(this.featureSubsetStrategy())) : GradientBoostedTrees$.MODULE$.run((RDD<LabeledPoint>)trainDataset2, boostingStrategy, BoxesRunTime.unboxToLong((Object)this.$(this.seed())), this.$(this.featureSubsetStrategy()));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            DecisionTreeRegressionModel[] baseLearners = (DecisionTreeRegressionModel[])tuple2._1();
            double[] learnerWeights = (double[])tuple2._2();
            Tuple2 tuple27 = new Tuple2((Object)baseLearners, (Object)learnerWeights);
            Tuple2 tuple28 = tuple27;
            DecisionTreeRegressionModel[] baseLearners2 = (DecisionTreeRegressionModel[])tuple28._1();
            double[] learnerWeights2 = (double[])tuple28._2();
            return new GBTRegressionModel(this.uid(), baseLearners2, learnerWeights2, numFeatures);
        });
    }

    @Override
    public GBTRegressor copy(ParamMap extra) {
        return (GBTRegressor)this.defaultCopy(extra);
    }

    public GBTRegressor(String uid) {
        this.uid = uid;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasValidationIndicatorCol.$init$(this);
        GBTParams.$init$(this);
        TreeRegressorParams.$init$(this);
        GBTRegressorParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
    }

    public GBTRegressor() {
        this(Identifiable$.MODULE$.randomUID("gbtr"));
    }
}

