/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import com.github.fommil.netlib.BLAS;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasValidationIndicatorCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel$;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.GBTRegressorParams;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.TreeRegressorParams;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.package$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t%f\u0001\u0002\u0017.\u0001aB\u0001\"\u0018\u0001\u0003\u0006\u0004%\tE\u0018\u0005\tU\u0002\u0011\t\u0011)A\u0005?\"A1\u000e\u0001BC\u0002\u0013%A\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003n\u0011!\t\bA!b\u0001\n\u0013\u0011\b\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011B:\t\u0011a\u0004!Q1A\u0005BeD\u0001\" \u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\u0007}\u0002!\taL@\t\ry\u0004A\u0011AA\u0005\u0011\u0019\t\u0019\u0003\u0001C!Y\"A\u0011q\u0005\u0001C\u0002\u0013\u0005\u0011\u0010C\u0004\u00020\u0001\u0001\u000b\u0011\u0002>\t\r\u0005M\u0002\u0001\"\u0011s\u0011\u001d\t9\u0004\u0001C)\u0003sAq!!!\u0001\t\u0003\n\u0019\t\u0003\u0005\u0002\n\u0002\u0011\r\u0011\"\u0001z\u0011\u001d\tY\n\u0001Q\u0001\niDq!a(\u0001\t\u0003\n\t\u000bC\u0004\u00026\u0002!\t%a.\t\u0015\u0005m\u0006\u0001#b\u0001\n\u0003\ti\f\u0003\u0005\u0002B\u0002!\taLAb\u0011\u001d\t9\u000e\u0001C\u0001\u00033Dq!!=\u0001\t\u0003\n\u0019pB\u0004\u0002\u00006B\tA!\u0001\u0007\r1j\u0003\u0012\u0001B\u0002\u0011\u0019q(\u0004\"\u0001\u0003\u0012!9!1\u0003\u000e\u0005B\tU\u0001b\u0002B\u00105\u0011\u0005#\u0011\u0005\u0004\b\u0005SQ\u0002A\u0007B\u0016\u0011%\u0011iC\bB\u0001B\u0003%1\t\u0003\u0004\u007f=\u0011\u0005!q\u0006\u0005\b\u0005oqB\u0011\u000bB\u001d\r\u0019\u0011\u0019E\u0007\u0003\u0003F!1aP\tC\u0001\u0005\u000fB\u0011Ba\u0013#\u0005\u0004%IA!\u0014\t\u0011\tu#\u0005)A\u0005\u0005\u001fB\u0011Ba\u0018#\u0005\u0004%IA!\u0014\t\u0011\t\u0005$\u0005)A\u0005\u0005\u001fBqAa\b#\t\u0003\u0012\u0019\u0007\u0003\u0005\u0003hi!\ta\fB5\u0011)\u0011)IGI\u0001\n\u0003y#q\u0011\u0005\n\u00057S\u0012\u0011!C\u0005\u0005;\u0013!c\u0012\"U%\u0016<'/Z:tS>tWj\u001c3fY*\u0011afL\u0001\u000be\u0016<'/Z:tS>t'B\u0001\u00192\u0003\tiGN\u0003\u00023g\u0005)1\u000f]1sW*\u0011A'N\u0001\u0007CB\f7\r[3\u000b\u0003Y\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u001dF\u0017F;\u0006\u0003\u0002\u001e<{\rk\u0011aL\u0005\u0003y=\u0012q\u0002\u0015:fI&\u001cG/[8o\u001b>$W\r\u001c\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001>\na\u0001\\5oC2<\u0017B\u0001\"@\u0005\u00191Vm\u0019;peB\u0011A\tA\u0007\u0002[A\u0011a)S\u0007\u0002\u000f*\u0011\u0001jL\u0001\u0005iJ,W-\u0003\u0002K\u000f\n\u0011rI\u0011+SK\u001e\u0014Xm]:peB\u000b'/Y7t!\r1EJT\u0005\u0003\u001b\u001e\u0013\u0011\u0003\u0016:fK\u0016s7/Z7cY\u0016lu\u000eZ3m!\t!u*\u0003\u0002Q[\tYB)Z2jg&|g\u000e\u0016:fKJ+wM]3tg&|g.T8eK2\u0004\"AU+\u000e\u0003MS!\u0001V\u0018\u0002\tU$\u0018\u000e\\\u0005\u0003-N\u0013!\"\u0014'Xe&$\u0018M\u00197f!\tA6,D\u0001Z\u0015\u0005Q\u0016!B:dC2\f\u0017B\u0001/Z\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\r)\u0018\u000eZ\u000b\u0002?B\u0011\u0001m\u001a\b\u0003C\u0016\u0004\"AY-\u000e\u0003\rT!\u0001Z\u001c\u0002\rq\u0012xn\u001c;?\u0013\t1\u0017,\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u00014Z\u0003\u0011)\u0018\u000e\u001a\u0011\u0002\r}#(/Z3t+\u0005i\u0007c\u0001-o\u001d&\u0011q.\u0017\u0002\u0006\u0003J\u0014\u0018-_\u0001\b?R\u0014X-Z:!\u00031yFO]3f/\u0016Lw\r\u001b;t+\u0005\u0019\bc\u0001-oiB\u0011\u0001,^\u0005\u0003mf\u0013a\u0001R8vE2,\u0017!D0ue\u0016,w+Z5hQR\u001c\b%A\u0006ok64U-\u0019;ve\u0016\u001cX#\u0001>\u0011\u0005a[\u0018B\u0001?Z\u0005\rIe\u000e^\u0001\r]Vlg)Z1ukJ,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013\r\u000b\t!a\u0001\u0002\u0006\u0005\u001d\u0001\"B/\n\u0001\u0004y\u0006\"B6\n\u0001\u0004i\u0007\"B9\n\u0001\u0004\u0019\b\"\u0002=\n\u0001\u0004QHcB\"\u0002\f\u00055\u0011q\u0002\u0005\u0006;*\u0001\ra\u0018\u0005\u0006W*\u0001\r!\u001c\u0005\u0006c*\u0001\ra\u001d\u0015\u0006\u0015\u0005M\u0011q\u0004\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001e\u0005]!!B*j]\u000e,\u0017EAA\u0011\u0003\u0015\td\u0006\u000e\u00181\u0003\u0015!(/Z3tQ\u0015Y\u00111CA\u0010\u0003-9W\r\u001e(v[R\u0013X-Z:)\u000b1\t\u0019\"a\u000b\"\u0005\u00055\u0012!\u0002\u001a/a9\u0002\u0014\u0001D4fi:+X\u000e\u0016:fKN\u0004\u0003&B\u0007\u0002\u0014\u0005-\u0012a\u0003;sK\u0016<V-[4iiNDSADA\n\u0003?\tQ\u0002\u001e:b]N4wN]7J[BdG\u0003BA\u001e\u0003;\u0002B!!\u0010\u0002X9!\u0011qHA)\u001d\u0011\t\t%!\u0014\u000f\t\u0005\r\u00131\n\b\u0005\u0003\u000b\nIED\u0002c\u0003\u000fJ\u0011AN\u0005\u0003iUJ!AM\u001a\n\u0007\u0005=\u0013'A\u0002tc2LA!a\u0015\u0002V\u00059\u0001/Y2lC\u001e,'bAA(c%!\u0011\u0011LA.\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0003\u0002T\u0005U\u0003bBA0\u001f\u0001\u0007\u0011\u0011M\u0001\bI\u0006$\u0018m]3ua\u0011\t\u0019'a\u001c\u0011\r\u0005\u0015\u0014qMA6\u001b\t\t)&\u0003\u0003\u0002j\u0005U#a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003[\ny\u0007\u0004\u0001\u0005\u0019\u0005E\u0014QLA\u0001\u0002\u0003\u0015\t!a\u001d\u0003\u0007}##'\u0005\u0003\u0002v\u0005m\u0004c\u0001-\u0002x%\u0019\u0011\u0011P-\u0003\u000f9{G\u000f[5oOB\u0019\u0001,! \n\u0007\u0005}\u0014LA\u0002B]f\fq\u0001\u001d:fI&\u001cG\u000fF\u0002u\u0003\u000bCa!a\"\u0011\u0001\u0004i\u0014\u0001\u00034fCR,(/Z:\u0002\u00119,X\u000e\u0016:fKNDs!EAG\u0003'\u000b9\nE\u0002Y\u0003\u001fK1!!%Z\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003+\u000ba(V:fA\u001d,GOT;n)J,Wm\u001d\u0011j]N$X-\u00193/AQC\u0017n\u001d\u0011nKRDw\u000e\u001a\u0011xS2d\u0007EY3!e\u0016lwN^3eA%t\u0007e\r\u00181]Ar\u0013EAAM\u0003\u0015\u0011d\u0006\u000e\u00186\u0003%qW/\u001c+sK\u0016\u001c\b\u0005K\u0004\u0013\u0003\u001b\u000b\u0019*a&\u0002\t\r|\u0007/\u001f\u000b\u0004\u0007\u0006\r\u0006bBAS'\u0001\u0007\u0011qU\u0001\u0006Kb$(/\u0019\t\u0005\u0003S\u000by+\u0004\u0002\u0002,*\u0019\u0011QV\u0018\u0002\u000bA\f'/Y7\n\t\u0005E\u00161\u0016\u0002\t!\u0006\u0014\u0018-\\'ba\"*1#a\u0005\u0002 \u0005AAo\\*ue&tw\rF\u0001`Q\u0015!\u00121CA\u0010\u0003I1W-\u0019;ve\u0016LU\u000e]8si\u0006t7-Z:\u0016\u0003uBS!FA\n\u0003W\tQ\u0001^8PY\u0012,\"!!2\u0011\t\u0005\u001d\u00171[\u0007\u0003\u0003\u0013TA!a3\u0002N\u0006)Qn\u001c3fY*\u0019\u0001*a4\u000b\u0007\u0005E\u0017'A\u0003nY2L'-\u0003\u0003\u0002V\u0006%'!G$sC\u0012LWM\u001c;C_>\u001cH/\u001a3Ue\u0016,7/T8eK2\fQ#\u001a<bYV\fG/Z#bG\"LE/\u001a:bi&|g\u000eF\u0003t\u00037\f9\u000fC\u0004\u0002`]\u0001\r!!81\t\u0005}\u00171\u001d\t\u0007\u0003K\n9'!9\u0011\t\u00055\u00141\u001d\u0003\r\u0003K\fY.!A\u0001\u0002\u000b\u0005\u00111\u000f\u0002\u0004?\u0012\u001a\u0004BBAu/\u0001\u0007q,\u0001\u0003m_N\u001c\b&B\f\u0002\u0014\u00055\u0018EAAx\u0003\u0015\u0011d\u0006\u000e\u00181\u0003\u00159(/\u001b;f+\t\t)\u0010E\u0002S\u0003oL1!!?T\u0005!iEj\u0016:ji\u0016\u0014\b&\u0002\r\u0002\u0014\u0005-\u0002&\u0002\u0001\u0002\u0014\u0005}\u0011AE$C)J+wM]3tg&|g.T8eK2\u0004\"\u0001\u0012\u000e\u0014\ri\u0011)Aa\u0003X!\rA&qA\u0005\u0004\u0005\u0013I&AB!osJ+g\r\u0005\u0003S\u0005\u001b\u0019\u0015b\u0001B\b'\nQQ\n\u0014*fC\u0012\f'\r\\3\u0015\u0005\t\u0005\u0011\u0001\u0002:fC\u0012,\"Aa\u0006\u0011\tI\u0013IbQ\u0005\u0004\u00057\u0019&\u0001C'M%\u0016\fG-\u001a:)\u000bq\t\u0019\"a\u000b\u0002\t1|\u0017\r\u001a\u000b\u0004\u0007\n\r\u0002B\u0002B\u0013;\u0001\u0007q,\u0001\u0003qCRD\u0007&B\u000f\u0002\u0014\u0005-\"\u0001G$C)J+wM]3tg&|g.T8eK2<&/\u001b;feN\u0019a$!>\u0002\u0011%t7\u000f^1oG\u0016$BA!\r\u00036A\u0019!1\u0007\u0010\u000e\u0003iAaA!\f!\u0001\u0004\u0019\u0015\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\tm\"\u0011\t\t\u00041\nu\u0012b\u0001B 3\n!QK\\5u\u0011\u0019\u0011)#\ta\u0001?\nArI\u0011+SK\u001e\u0014Xm]:j_:lu\u000eZ3m%\u0016\fG-\u001a:\u0014\u0007\t\u00129\u0002\u0006\u0002\u0003JA\u0019!1\u0007\u0012\u0002\u0013\rd\u0017m]:OC6,WC\u0001B(!\u0011\u0011\tFa\u0017\u000e\u0005\tM#\u0002\u0002B+\u0005/\nA\u0001\\1oO*\u0011!\u0011L\u0001\u0005U\u00064\u0018-C\u0002i\u0005'\n!b\u00197bgNt\u0015-\\3!\u00035!(/Z3DY\u0006\u001c8OT1nK\u0006qAO]3f\u00072\f7o\u001d(b[\u0016\u0004CcA\"\u0003f!1!Q\u0005\u0015A\u0002}\u000bqA\u001a:p[>cG\rF\u0005D\u0005W\u0012yG!\u001f\u0003\u0004\"9!QN\u0015A\u0002\u0005\u0015\u0017\u0001C8mI6{G-\u001a7\t\u000f\tE\u0014\u00061\u0001\u0003t\u00051\u0001/\u0019:f]R\u00042\u0001\u0012B;\u0013\r\u00119(\f\u0002\r\u000f\n#&+Z4sKN\u001cxN\u001d\u0005\b\u0005wJ\u0003\u0019\u0001B?\u0003M\u0019\u0017\r^3h_JL7-\u00197GK\u0006$XO]3t!\u0015\u0001'q\u0010>{\u0013\r\u0011\t)\u001b\u0002\u0004\u001b\u0006\u0004\bb\u0002=*!\u0003\u0005\rA_\u0001\u0012MJ|Wn\u00147eI\u0011,g-Y;mi\u0012\"TC\u0001BEU\rQ(1R\u0016\u0003\u0005\u001b\u0003BAa$\u0003\u00186\u0011!\u0011\u0013\u0006\u0005\u0005'\u0013)*A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011D-\n\t\te%\u0011\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa(\u0011\t\tE#\u0011U\u0005\u0005\u0005G\u0013\u0019F\u0001\u0004PE*,7\r\u001e\u0015\u00065\u0005M\u00111\u0006\u0015\u00063\u0005M\u00111\u0006")
public class GBTRegressionModel
extends PredictionModel<Vector, GBTRegressionModel>
implements GBTRegressorParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeRegressionModel[] _trees;
    private final double[] _treeWeights;
    private final int numFeatures;
    private final int getNumTrees;
    private final int numTrees;
    private int totalNumNodes;
    private final Param<String> lossType;
    private final Param<String> impurity;
    private final DoubleParam validationTol;
    private final DoubleParam stepSize;
    private final Param<String> validationIndicatorCol;
    private final IntParam maxIter;
    private final DoubleParam subsamplingRate;
    private final Param<String> featureSubsetStrategy;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static GBTRegressionModel load(String string) {
        return GBTRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<GBTRegressionModel> read() {
        return GBTRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public String getLossType() {
        return GBTRegressorParams.getLossType$(this);
    }

    @Override
    public Loss getOldLossType() {
        return GBTRegressorParams.getOldLossType$(this);
    }

    @Override
    public Loss convertToOldLossType(String loss) {
        return GBTRegressorParams.convertToOldLossType$(this, loss);
    }

    @Override
    public TreeRegressorParams setImpurity(String value) {
        return TreeRegressorParams.setImpurity$(this, value);
    }

    @Override
    public final String getImpurity() {
        return TreeRegressorParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeRegressorParams.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final double getValidationTol() {
        return GBTParams.getValidationTol$(this);
    }

    @Override
    public GBTParams setMaxIter(int value) {
        return GBTParams.setMaxIter$(this, value);
    }

    @Override
    public GBTParams setStepSize(double value) {
        return GBTParams.setStepSize$(this, value);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams.getOldBoostingStrategy$(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final String getValidationIndicatorCol() {
        return HasValidationIndicatorCol.getValidationIndicatorCol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public TreeEnsembleParams setSubsamplingRate(double value) {
        return TreeEnsembleParams.setSubsamplingRate$(this, value);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public TreeEnsembleParams setFeatureSubsetStrategy(String value) {
        return TreeEnsembleParams.setFeatureSubsetStrategy$(this, value);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public DecisionTreeParams setMaxDepth(int value) {
        return DecisionTreeParams.setMaxDepth$(this, value);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public DecisionTreeParams setMaxBins(int value) {
        return DecisionTreeParams.setMaxBins$(this, value);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public DecisionTreeParams setMinInstancesPerNode(int value) {
        return DecisionTreeParams.setMinInstancesPerNode$(this, value);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public DecisionTreeParams setMinInfoGain(double value) {
        return DecisionTreeParams.setMinInfoGain$(this, value);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public DecisionTreeParams setSeed(long value) {
        return DecisionTreeParams.setSeed$(this, value);
    }

    @Override
    public DecisionTreeParams setMaxMemoryInMB(int value) {
        return DecisionTreeParams.setMaxMemoryInMB$(this, value);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public DecisionTreeParams setCacheNodeIds(boolean value) {
        return DecisionTreeParams.setCacheNodeIds$(this, value);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public DecisionTreeParams setCheckpointInterval(int value) {
        return DecisionTreeParams.setCheckpointInterval$(this, value);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        GBTRegressionModel gBTRegressionModel = this;
        synchronized (gBTRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTRegressorParams$_setter_$lossType_$eq(Param<String> x$1) {
        this.lossType = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeRegressorParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final DoubleParam validationTol() {
        return this.validationTol;
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$validationTol_$eq(DoubleParam x$1) {
        this.validationTol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final Param<String> validationIndicatorCol() {
        return this.validationIndicatorCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasValidationIndicatorCol$_setter_$validationIndicatorCol_$eq(Param<String> x$1) {
        this.validationIndicatorCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeRegressionModel[] _trees() {
        return this._trees;
    }

    private double[] _treeWeights() {
        return this._treeWeights;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public DecisionTreeRegressionModel[] trees() {
        return this._trees();
    }

    public int getNumTrees() {
        return this.getNumTrees;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(GBTRegressionModel.class));
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)GBTRegressionModel.$anonfun$transformImpl$1(bcastModel, features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Any());
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public double predict(Vector features) {
        double[] treePredictions = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)GBTRegressionModel.$anonfun$predict$1(features, x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return BLAS.getInstance().ddot(this.getNumTrees(), treePredictions, 1, this._treeWeights(), 1);
    }

    public int numTrees() {
        return this.numTrees;
    }

    @Override
    public GBTRegressionModel copy(ParamMap extra) {
        return (GBTRegressionModel)((Model)this.copyValues(new GBTRegressionModel(this.uid(), this._trees(), this._treeWeights(), this.numFeatures()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(37).append("GBTRegressionModel (uid=").append(this.uid()).append(") with ").append(this.getNumTrees()).append(" trees").toString();
    }

    private Vector featureImportances$lzycompute() {
        GBTRegressionModel gBTRegressionModel = this;
        synchronized (gBTRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    public GradientBoostedTreesModel toOld() {
        return new GradientBoostedTreesModel(Algo$.MODULE$.Regression(), (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toOld(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))), this._treeWeights());
    }

    public double[] evaluateEachIteration(Dataset<?> dataset, String loss) {
        RDD data = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double d;
            Object features;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                    Object label = ((SeqLike)some.get()).apply(0);
                    features = ((SeqLike)some.get()).apply(1);
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (features instanceof Vector) break block3;
                }
                throw new MatchError((Object)row);
            }
            Vector vector = (Vector)features;
            LabeledPoint labeledPoint = new LabeledPoint(d, vector);
            return labeledPoint;
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        return GradientBoostedTrees$.MODULE$.evaluateEachIteration((RDD<LabeledPoint>)data, this.trees(), this.treeWeights(), this.convertToOldLossType(loss), Algo$.MODULE$.Regression());
    }

    @Override
    public MLWriter write() {
        return new GBTRegressionModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$transformImpl$1(Broadcast bcastModel$1, Object features) {
        return ((GBTRegressionModel)bcastModel$1.value()).predict((Vector)features);
    }

    public static final /* synthetic */ double $anonfun$predict$1(Vector features$1, DecisionTreeRegressionModel x$3) {
        return x$3.rootNode().predictImpl(features$1).prediction();
    }

    public GBTRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures) {
        this.uid = uid;
        this._trees = _trees;
        this._treeWeights = _treeWeights;
        this.numFeatures = numFeatures;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasValidationIndicatorCol.$init$(this);
        GBTParams.$init$(this);
        TreeRegressorParams.$init$(this);
        GBTRegressorParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])_trees)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "GBTRegressionModel requires at least 1 tree.");
        Predef$.MODULE$.require(_trees.length == _treeWeights.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("GBTRegressionModel given trees, treeWeights of").append(" non-matching lengths (").append(this._trees().length).append(", ").append(this._treeWeights().length).append(", respectively).").toString());
        this.getNumTrees = this.trees().length;
        this.numTrees = this.trees().length;
    }

    public GBTRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights) {
        this(uid, _trees, _treeWeights, -1);
    }

    public static class GBTRegressionModelReader
    extends MLReader<GBTRegressionModel> {
        private final String className = GBTRegressionModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public GBTRegressionModel load(String path) {
            Tuple2[] tuple2Array;
            DefaultParamsReader.Metadata metadata;
            double[] treeWeights;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    Tuple2[] treesData = (Tuple2[])tuple3._2();
                    treeWeights = (double[])tuple3._3();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData == null) break block2;
                    tuple2Array = treesData;
                    if (treeWeights != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            double[] dArray = treeWeights;
            Tuple3 tuple3 = new Tuple3((Object)metadata, (Object)tuple2Array, (Object)dArray);
            Tuple3 tuple32 = tuple3;
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple32._1();
            Tuple2[] treesData = (Tuple2[])tuple32._2();
            double[] treeWeights2 = (double[])tuple32._3();
            int numFeatures = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numFeatures")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numTrees")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])treesData)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                Node root = (Node)tuple2._2();
                DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, numFeatures);
                treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                DecisionTreeRegressionModel decisionTreeRegressionModel = tree;
                return decisionTreeRegressionModel;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class)));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("GBTRegressionModel.load expected ").append(numTrees).append(" trees based on metadata but found ").append(trees.length).append(" trees.").toString());
            GBTRegressionModel model = new GBTRegressionModel(metadata3.uid(), trees, treeWeights2, numFeatures);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GBTRegressionModelWriter
    extends MLWriter {
        private final GBTRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public GBTRegressionModelWriter(GBTRegressionModel instance) {
            this.instance = instance;
        }
    }
}

