/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\r%b\u0001B\u001f?\u0001%C\u0001\"\u0017\u0001\u0003\u0006\u0004%\tE\u0017\u0005\tc\u0002\u0011\t\u0011)A\u00057\"A1\u000f\u0001BC\u0002\u0013\u0005A\u000f\u0003\u0005\u007f\u0001\t\u0005\t\u0015!\u0003v\u0011)\t\t\u0001\u0001BC\u0002\u0013\u0005\u00111\u0001\u0005\u000b\u0003\u001f\u0001!\u0011!Q\u0001\n\u0005\u0015\u0001BCA\n\u0001\t\u0015\r\u0011\"\u0001\u0002\u0004!Q\u0011q\u0003\u0001\u0003\u0002\u0003\u0006I!!\u0002\t\u0011\u0005m\u0001\u0001\"\u0001A\u0003;Aq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0003bBA-\u0001\u0011\u0005\u00111\f\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\tY\u0007\u0001C!\u0003[Bq!a.\u0001\t\u0003\nI\fC\u0004\u0002N\u0002!\t%a4\t\u000f\u0005\r\b\u0001\"\u0011\u0002f\u001e9\u0011\u0011  \t\u0002\u0005mhAB\u001f?\u0011\u0003\ti\u0010C\u0004\u0002\u001cU!\tA!\u0005\t\u000f\tMQ\u0003\"\u0011\u0003\u0016!9!qD\u000b\u0005B\t\u0005ba\u0002B\u0015+\u0001)\"1\u0006\u0005\n\u0005sI\"\u0011!Q\u0001\n9Cq!a\u0007\u001a\t\u0003\u0011YD\u0002\u0004\u0003De!%Q\t\u0005\tgr\u0011)\u001a!C\u0001i\"Aa\u0010\bB\tB\u0003%Q\u000f\u0003\u0006\u0002\u0002q\u0011)\u001a!C\u0001\u0003\u0007A!\"a\u0004\u001d\u0005#\u0005\u000b\u0011BA\u0003\u0011)\t\u0019\u0002\bBK\u0002\u0013\u0005\u00111\u0001\u0005\u000b\u0003/a\"\u0011#Q\u0001\n\u0005\u0015\u0001bBA\u000e9\u0011\u0005!Q\n\u0005\n\u0003\u001bd\u0012\u0011!C\u0001\u00053B\u0011B!\u0019\u001d#\u0003%\tAa\u0019\t\u0013\t]D$%A\u0005\u0002\te\u0004\"\u0003B?9E\u0005I\u0011\u0001B=\u0011%\u0011y\bHA\u0001\n\u0003\u0012\t\tC\u0005\u0003\u0012r\t\t\u0011\"\u0001\u0003\u0014\"I!1\u0014\u000f\u0002\u0002\u0013\u0005!Q\u0014\u0005\n\u0005Gc\u0012\u0011!C!\u0005KC\u0011Ba-\u001d\u0003\u0003%\tA!.\t\u0013\t}F$!A\u0005B\t\u0005\u0007\"\u0003Bb9\u0005\u0005I\u0011\tBc\u0011%\u00119\rHA\u0001\n\u0003\u0012ImB\u0005\u0003Nf\t\t\u0011#\u0003\u0003P\u001aI!1I\r\u0002\u0002#%!\u0011\u001b\u0005\b\u00037\tD\u0011\u0001Bp\u0011%\u0011\u0019-MA\u0001\n\u000b\u0012)\rC\u0005\u0003bF\n\t\u0011\"!\u0003d\"I!1^\u0019\u0002\u0002\u0013\u0005%Q\u001e\u0005\b\u0005\u007fLB\u0011KB\u0001\r\u0019\u0019Y!\u0006\u0003\u0004\u000e!9\u00111D\u001c\u0005\u0002\r=\u0001\"CB\no\t\u0007I\u0011\u0002BA\u0011!\u0019)b\u000eQ\u0001\n\t\r\u0005b\u0002B\u0010o\u0011\u00053q\u0003\u0005\n\u00077)\u0012\u0011!C\u0005\u0007;\u0011!$\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|g.T8eK2T!a\u0010!\u0002\u0015I,wM]3tg&|gN\u0003\u0002B\u0005\u0006\u0011Q\u000e\u001c\u0006\u0003\u0007\u0012\u000bQa\u001d9be.T!!\u0012$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0015aA8sO\u000e\u00011\u0003\u0002\u0001K!N\u00032a\u0013'O\u001b\u0005\u0001\u0015BA'A\u0005\u0015iu\u000eZ3m!\ty\u0005!D\u0001?!\ty\u0015+\u0003\u0002S}\tY\u0012I\u0012+TkJ4\u0018N^1m%\u0016<'/Z:tS>t\u0007+\u0019:b[N\u0004\"\u0001V,\u000e\u0003US!A\u0016!\u0002\tU$\u0018\u000e\\\u0005\u00031V\u0013!\"\u0014'Xe&$\u0018M\u00197f\u0003\r)\u0018\u000eZ\u000b\u00027B\u0011A,\u001a\b\u0003;\u000e\u0004\"AX1\u000e\u0003}S!\u0001\u0019%\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0011\u0017!B:dC2\f\u0017B\u00013b\u0003\u0019\u0001&/\u001a3fM&\u0011am\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011\f\u0007fA\u0001j_B\u0011!.\\\u0007\u0002W*\u0011ANQ\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00018l\u0005\u0015\u0019\u0016N\\2fC\u0005\u0001\u0018!B\u0019/m9\u0002\u0014\u0001B;jI\u0002B3AA5p\u00031\u0019w.\u001a4gS\u000eLWM\u001c;t+\u0005)\bC\u0001<z\u001b\u00059(B\u0001=A\u0003\u0019a\u0017N\\1mO&\u0011!p\u001e\u0002\u0007-\u0016\u001cGo\u001c:)\u0007\rIG0I\u0001~\u0003\u0015\u0011d\u0006\r\u00181\u00035\u0019w.\u001a4gS\u000eLWM\u001c;tA!\u001aA!\u001b?\u0002\u0013%tG/\u001a:dKB$XCAA\u0003!\u0011\t9!!\u0003\u000e\u0003\u0005L1!a\u0003b\u0005\u0019!u.\u001e2mK\"\u001aQ![8\u0002\u0015%tG/\u001a:dKB$\b\u0005K\u0002\u0007S>\fQa]2bY\u0016D3aB5p\u0003\u0019\u00198-\u00197fA!\u001a\u0001\"[8\u0002\rqJg.\u001b;?)%q\u0015qDA\u0012\u0003O\tY\u0003C\u0003Z\u0013\u0001\u00071\f\u000b\u0003\u0002 %|\u0007\"B:\n\u0001\u0004)\b\u0006BA\u0012SrDq!!\u0001\n\u0001\u0004\t)\u0001\u000b\u0003\u0002(%|\u0007bBA\n\u0013\u0001\u0007\u0011Q\u0001\u0015\u0005\u0003WIw.\u0001\btKR4U-\u0019;ve\u0016\u001c8i\u001c7\u0015\t\u0005M\u0012QG\u0007\u0002\u0001!1\u0011q\u0007\u0006A\u0002m\u000bQA^1mk\u0016D3AC5p\u0003A\u0019X\r\u001e)sK\u0012L7\r^5p]\u000e{G\u000e\u0006\u0003\u00024\u0005}\u0002BBA\u001c\u0017\u0001\u00071\fK\u0002\fS>\f\u0001d]3u#V\fg\u000e^5mKB\u0013xNY1cS2LG/[3t)\u0011\t\u0019$a\u0012\t\u000f\u0005]B\u00021\u0001\u0002JA1\u0011qAA&\u0003\u000bI1!!\u0014b\u0005\u0015\t%O]1zQ\ra\u0011n\\\u0001\u0010g\u0016$\u0018+^1oi&dWm]\"pYR!\u00111GA+\u0011\u0019\t9$\u0004a\u00017\"\u001aQ\"[8\u0002!A\u0014X\rZ5diF+\u0018M\u001c;jY\u0016\u001cHcA;\u0002^!1\u0011q\f\bA\u0002U\f\u0001BZ3biV\u0014Xm\u001d\u0015\u0004\u001d%d\u0018a\u00029sK\u0012L7\r\u001e\u000b\u0005\u0003\u000b\t9\u0007\u0003\u0004\u0002`=\u0001\r!\u001e\u0015\u0004\u001f%d\u0018!\u0003;sC:\u001chm\u001c:n)\u0011\ty'!%\u0011\t\u0005E\u00141\u0012\b\u0005\u0003g\n)I\u0004\u0003\u0002v\u0005\u0005e\u0002BA<\u0003\u007frA!!\u001f\u0002~9\u0019a,a\u001f\n\u0003\u001dK!!\u0012$\n\u0005\r#\u0015bAAB\u0005\u0006\u00191/\u001d7\n\t\u0005\u001d\u0015\u0011R\u0001\ba\u0006\u001c7.Y4f\u0015\r\t\u0019IQ\u0005\u0005\u0003\u001b\u000byIA\u0005ECR\fgI]1nK*!\u0011qQAE\u0011\u001d\t\u0019\n\u0005a\u0001\u0003+\u000bq\u0001Z1uCN,G\u000f\r\u0003\u0002\u0018\u0006\r\u0006CBAM\u00037\u000by*\u0004\u0002\u0002\n&!\u0011QTAE\u0005\u001d!\u0015\r^1tKR\u0004B!!)\u0002$2\u0001A\u0001DAS\u0003#\u000b\t\u0011!A\u0003\u0002\u0005\u001d&aA0%gE!\u0011\u0011VAX!\u0011\t9!a+\n\u0007\u00055\u0016MA\u0004O_RD\u0017N\\4\u0011\t\u0005\u001d\u0011\u0011W\u0005\u0004\u0003g\u000b'aA!os\"\u001a\u0001#\u001b?\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$B!a/\u0002HB!\u0011QXAb\u001b\t\tyL\u0003\u0003\u0002B\u0006%\u0015!\u0002;za\u0016\u001c\u0018\u0002BAc\u0003\u007f\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\tI-\u0005a\u0001\u0003w\u000baa]2iK6\f\u0007fA\tj_\u0006!1m\u001c9z)\rq\u0015\u0011\u001b\u0005\b\u0003'\u0014\u0002\u0019AAk\u0003\u0015)\u0007\u0010\u001e:b!\u0011\t9.!8\u000e\u0005\u0005e'bAAn\u0001\u0006)\u0001/\u0019:b[&!\u0011q\\Am\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bf\u0001\nj_\u0006)qO]5uKV\u0011\u0011q\u001d\t\u0004)\u0006%\u0018bAAv+\nAQ\nT,sSR,'\u000fK\u0002\u0014S>D3\u0001A5pQ\r\u0001\u00111\u001f\t\u0004U\u0006U\u0018bAA|W\naQ\t\u001f9fe&lWM\u001c;bY\u0006Q\u0012I\u0012+TkJ4\u0018N^1m%\u0016<'/Z:tS>tWj\u001c3fYB\u0011q*F\n\b+\u0005}(Q\u0001B\u0006!\u0011\t9A!\u0001\n\u0007\t\r\u0011M\u0001\u0004B]f\u0014VM\u001a\t\u0005)\n\u001da*C\u0002\u0003\nU\u0013!\"\u0014'SK\u0006$\u0017M\u00197f!\u0011\t9A!\u0004\n\u0007\t=\u0011M\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002|\u0006!!/Z1e+\t\u00119\u0002\u0005\u0003U\u00053q\u0015b\u0001B\u000e+\nAQ\n\u0014*fC\u0012,'\u000fK\u0002\u0018S>\fA\u0001\\8bIR\u0019aJa\t\t\r\t\u0015\u0002\u00041\u0001\\\u0003\u0011\u0001\u0018\r\u001e5)\u0007aIwN\u0001\u0011B\rR\u001bVO\u001d<jm\u0006d'+Z4sKN\u001c\u0018n\u001c8N_\u0012,Gn\u0016:ji\u0016\u00148#B\r\u0002h\n5\u0002\u0003\u0002B\u0018\u0005ki!A!\r\u000b\u0007\tM\")\u0001\u0005j]R,'O\\1m\u0013\u0011\u00119D!\r\u0003\u000f1{wmZ5oO\u0006A\u0011N\\:uC:\u001cW\r\u0006\u0003\u0003>\t\u0005\u0003c\u0001B 35\tQ\u0003\u0003\u0004\u0003:m\u0001\rA\u0014\u0002\u0005\t\u0006$\u0018mE\u0004\u001d\u0003\u007f\u00149Ea\u0003\u0011\t\u0005\u001d!\u0011J\u0005\u0004\u0005\u0017\n'a\u0002)s_\u0012,8\r\u001e\u000b\t\u0005\u001f\u0012\u0019F!\u0016\u0003XA\u0019!\u0011\u000b\u000f\u000e\u0003eAQa]\u0012A\u0002UDq!!\u0001$\u0001\u0004\t)\u0001C\u0004\u0002\u0014\r\u0002\r!!\u0002\u0015\u0011\t=#1\fB/\u0005?Bqa\u001d\u0013\u0011\u0002\u0003\u0007Q\u000fC\u0005\u0002\u0002\u0011\u0002\n\u00111\u0001\u0002\u0006!I\u00111\u0003\u0013\u0011\u0002\u0003\u0007\u0011QA\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011)GK\u0002v\u0005OZ#A!\u001b\u0011\t\t-$1O\u0007\u0003\u0005[RAAa\u001c\u0003r\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003Y\u0006LAA!\u001e\u0003n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0010\u0016\u0005\u0003\u000b\u00119'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011\u0019\t\u0005\u0003\u0003\u0006\n=UB\u0001BD\u0015\u0011\u0011IIa#\u0002\t1\fgn\u001a\u0006\u0003\u0005\u001b\u000bAA[1wC&\u0019aMa\"\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tU\u0005\u0003BA\u0004\u0005/K1A!'b\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tyKa(\t\u0013\t\u0005&&!AA\u0002\tU\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003(B1!\u0011\u0016BX\u0003_k!Aa+\u000b\u0007\t5\u0016-\u0001\u0006d_2dWm\u0019;j_:LAA!-\u0003,\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u00119L!0\u0011\t\u0005\u001d!\u0011X\u0005\u0004\u0005w\u000b'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005Cc\u0013\u0011!a\u0001\u0003_\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005+\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u0007\u000ba!Z9vC2\u001cH\u0003\u0002B\\\u0005\u0017D\u0011B!)0\u0003\u0003\u0005\r!a,\u0002\t\u0011\u000bG/\u0019\t\u0004\u0005#\n4#B\u0019\u0003T\n-\u0001c\u0003Bk\u00057,\u0018QAA\u0003\u0005\u001fj!Aa6\u000b\u0007\te\u0017-A\u0004sk:$\u0018.\\3\n\t\tu'q\u001b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDC\u0001Bh\u0003\u0015\t\u0007\u000f\u001d7z)!\u0011yE!:\u0003h\n%\b\"B:5\u0001\u0004)\bbBA\u0001i\u0001\u0007\u0011Q\u0001\u0005\b\u0003'!\u0004\u0019AA\u0003\u0003\u001d)h.\u00199qYf$BAa<\u0003|B1\u0011q\u0001By\u0005kL1Aa=b\u0005\u0019y\u0005\u000f^5p]BI\u0011q\u0001B|k\u0006\u0015\u0011QA\u0005\u0004\u0005s\f'A\u0002+va2,7\u0007C\u0005\u0003~V\n\t\u00111\u0001\u0003P\u0005\u0019\u0001\u0010\n\u0019\u0002\u0011M\fg/Z%na2$Baa\u0001\u0004\nA!\u0011qAB\u0003\u0013\r\u00199!\u0019\u0002\u0005+:LG\u000f\u0003\u0004\u0003&Y\u0002\ra\u0017\u0002!\u0003\u001a#6+\u001e:wSZ\fGNU3he\u0016\u001c8/[8o\u001b>$W\r\u001c*fC\u0012,'oE\u00028\u0005/!\"a!\u0005\u0011\u0007\t}r'A\u0005dY\u0006\u001c8OT1nK\u0006Q1\r\\1tg:\u000bW.\u001a\u0011\u0015\u00079\u001bI\u0002\u0003\u0004\u0003&m\u0002\raW\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004 A!!QQB\u0011\u0013\u0011\u0019\u0019Ca\"\u0003\r=\u0013'.Z2uQ\r)\u0012n\u001c\u0015\u0004)%|\u0007")
public class AFTSurvivalRegressionModel
extends Model<AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private final Param<String> censorCol;
    private final DoubleArrayParam quantileProbabilities;
    private final Param<String> quantilesCol;
    private final IntParam aggregationDepth;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final Param<String> predictionCol;
    private final Param<String> labelCol;
    private final Param<String> featuresCol;

    public static AFTSurvivalRegressionModel load(String string) {
        return AFTSurvivalRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<AFTSurvivalRegressionModel> read() {
        return AFTSurvivalRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams.getCensorCol$(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams.getQuantileProbabilities$(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams.getQuantilesCol$(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams.hasQuantilesCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams.validateAndTransformSchema$(this, schema, fitting);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param<String> x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param<String> x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    public AFTSurvivalRegressionModel setFeaturesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.featuresCol(), value);
    }

    public AFTSurvivalRegressionModel setPredictionCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.predictionCol(), value);
    }

    public AFTSurvivalRegressionModel setQuantileProbabilities(double[] value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantileProbabilities(), value);
    }

    public AFTSurvivalRegressionModel setQuantilesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantilesCol(), value);
    }

    public Vector predictQuantiles(Vector features) {
        double lambda = scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
        double k = 1.0 / this.scale();
        double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.$(this.quantileProbabilities()))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)q -> lambda * scala.math.package$.MODULE$.exp(scala.math.package$.MODULE$.log(-scala.math.package$.MODULE$.log(1.0 - q)) / k), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return Vectors$.MODULE$.dense(quantiles);
    }

    public double predict(Vector features) {
        return scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(null)));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictQuantilesUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictQuantiles((Vector)features), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(null)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(null)));
        return this.hasQuantilesCol() ? dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}))).withColumn(this.$(this.quantilesCol()), predictQuantilesUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}))) : dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema, false);
    }

    @Override
    public AFTSurvivalRegressionModel copy(ParamMap extra) {
        return (AFTSurvivalRegressionModel)((Model)this.copyValues(new AFTSurvivalRegressionModel(this.uid(), this.coefficients(), this.intercept(), this.scale()), extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new AFTSurvivalRegressionModelWriter(this);
    }

    public AFTSurvivalRegressionModel(String uid, Vector coefficients, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.scale = scale;
        HasFeaturesCol.$init$(this);
        HasLabelCol.$init$(this);
        HasPredictionCol.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasAggregationDepth.$init$(this);
        AFTSurvivalRegressionParams.$init$(this);
        MLWritable.$init$(this);
    }

    public static class AFTSurvivalRegressionModelReader
    extends MLReader<AFTSurvivalRegressionModel> {
        private final String className = AFTSurvivalRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public AFTSurvivalRegressionModel load(String path) {
            double d;
            Vector vector;
            Object scale;
            DefaultParamsReader.Metadata metadata;
            block3: {
                Row row;
                block2: {
                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                    String dataPath = new Path(path, "data").toString();
                    Dataset data = this.sparkSession().read().parquet(dataPath);
                    row = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("coefficients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "scale"})).head();
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                    Object coefficients = ((SeqLike)some.get()).apply(0);
                    Object intercept = ((SeqLike)some.get()).apply(1);
                    scale = ((SeqLike)some.get()).apply(2);
                    if (!(coefficients instanceof Vector)) break block2;
                    vector = (Vector)coefficients;
                    if (!(intercept instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                    if (scale instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d2 = BoxesRunTime.unboxToDouble((Object)scale);
            Tuple3 tuple3 = new Tuple3((Object)vector, (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2));
            Tuple3 tuple32 = tuple3;
            Vector coefficients = (Vector)tuple32._1();
            double intercept = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            double scale2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
            AFTSurvivalRegressionModel model = new AFTSurvivalRegressionModel(metadata.uid(), coefficients, intercept, scale2);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class AFTSurvivalRegressionModelWriter
    extends MLWriter {
        private volatile AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data$module;
        private final AFTSurvivalRegressionModel instance;

        private AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.coefficients(), this.instance.intercept(), this.instance.scale());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2(AFTSurvivalRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            AFTSurvivalRegressionModelWriter aFTSurvivalRegressionModelWriter = this;
            synchronized (aFTSurvivalRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$(this);
                }
            }
        }

        public AFTSurvivalRegressionModelWriter(AFTSurvivalRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        scala.Serializable {
            private final Vector coefficients;
            private final double intercept;
            private final double scale;
            public final /* synthetic */ AFTSurvivalRegressionModelWriter $outer;

            public Vector coefficients() {
                return this.coefficients;
            }

            public double intercept() {
                return this.intercept;
            }

            public double scale() {
                return this.scale;
            }

            public Data copy(Vector coefficients, double intercept, double scale) {
                return new Data(this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer(), coefficients, intercept, scale);
            }

            public Vector copy$default$1() {
                return this.coefficients();
            }

            public double copy$default$2() {
                return this.intercept();
            }

            public double copy$default$3() {
                return this.scale();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = this.coefficients();
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 2: {
                        object = BoxesRunTime.boxToDouble((double)this.scale());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.scale()));
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (this.intercept() != data.intercept()) return false;
                if (this.scale() != data.scale()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ AFTSurvivalRegressionModelWriter org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(AFTSurvivalRegressionModelWriter $outer, Vector coefficients, double intercept, double scale) {
                this.coefficients = coefficients;
                this.intercept = intercept;
                this.scale = scale;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

