/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\n\u0015\u0001}A\u0001\"\u000e\u0001\u0003\u0006\u0004%\tE\u000e\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005o!)q\n\u0001C\u0001!\")q\n\u0001C\u0001+\"9q\u000b\u0001b\u0001\n\u0003A\u0006B\u00020\u0001A\u0003%\u0011\fC\u0003a\u0001\u0011\u0005a\u0007C\u0003c\u0001\u0011\u00051\rC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003m\u0001\u0011\u0005Q\u000eC\u0003q\u0001\u0011\u0005\u0013\u000fC\u0004\u0002\u001c\u0001!\t%!\b\t\u000f\u0005\u001d\u0002\u0001\"\u0011\u0002*\u001d9\u0011\u0011\t\u000b\t\u0002\u0005\rcAB\n\u0015\u0011\u0003\t)\u0005\u0003\u0004P\u001f\u0011\u0005\u0011\u0011\f\u0005\b\u00037zA\u0011IA/\u0011%\tIgDA\u0001\n\u0013\tYGA\u0011Nk2$\u0018n\u00197bgN\u001cE.Y:tS\u001aL7-\u0019;j_:,e/\u00197vCR|'O\u0003\u0002\u0016-\u0005QQM^1mk\u0006$\u0018n\u001c8\u000b\u0005]A\u0012AA7m\u0015\tI\"$A\u0003ta\u0006\u00148N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7\u0001A\n\u0006\u0001\u0001\"Cf\f\t\u0003C\tj\u0011\u0001F\u0005\u0003GQ\u0011\u0011\"\u0012<bYV\fGo\u001c:\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013AB:iCJ,GM\u0003\u0002*-\u0005)\u0001/\u0019:b[&\u00111F\n\u0002\u0011\u0011\u0006\u001c\bK]3eS\u000e$\u0018n\u001c8D_2\u0004\"!J\u0017\n\u000592#a\u0003%bg2\u000b'-\u001a7D_2\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\f\u0002\tU$\u0018\u000e\\\u0005\u0003iE\u0012Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW-A\u0002vS\u0012,\u0012a\u000e\t\u0003q\u0005s!!O \u0011\u0005ijT\"A\u001e\u000b\u0005qr\u0012A\u0002\u001fs_>$hHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001U(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!>Q\r\tQi\u0013\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011b\t!\"\u00198o_R\fG/[8o\u0013\tQuIA\u0003TS:\u001cW-I\u0001M\u0003\u0015\td&\u000e\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\t)5*\u0001\u0004=S:LGO\u0010\u000b\u0003#J\u0003\"!\t\u0001\t\u000bU\u001a\u0001\u0019A\u001c)\u0007I+5\nK\u0002\u0004\u000b.#\u0012!\u0015\u0015\u0004\t\u0015[\u0015AC7fiJL7MT1nKV\t\u0011\fE\u0002[7^j\u0011\u0001K\u0005\u00039\"\u0012Q\u0001U1sC6D3!B#L\u0003-iW\r\u001e:jG:\u000bW.\u001a\u0011)\u0007\u0019)5*A\u0007hKRlU\r\u001e:jG:\u000bW.\u001a\u0015\u0004\u000f\u0015[\u0015!D:fi6+GO]5d\u001d\u0006lW\r\u0006\u0002eK6\t\u0001\u0001C\u0003g\u0011\u0001\u0007q'A\u0003wC2,X\rK\u0002\t\u000b.\u000b\u0001c]3u!J,G-[2uS>t7i\u001c7\u0015\u0005\u0011T\u0007\"\u00024\n\u0001\u00049\u0004fA\u0005F\u0017\u0006Y1/\u001a;MC\n,GnQ8m)\t!g\u000eC\u0003g\u0015\u0001\u0007q\u0007K\u0002\u000b\u000b.\u000b\u0001\"\u001a<bYV\fG/\u001a\u000b\u0003eZ\u0004\"a\u001d;\u000e\u0003uJ!!^\u001f\u0003\r\u0011{WO\u00197f\u0011\u001598\u00021\u0001y\u0003\u001d!\u0017\r^1tKR\u00044!_A\u0002!\rQXp`\u0007\u0002w*\u0011A\u0010G\u0001\u0004gFd\u0017B\u0001@|\u0005\u001d!\u0015\r^1tKR\u0004B!!\u0001\u0002\u00041\u0001AaCA\u0003m\u0006\u0005\t\u0011!B\u0001\u0003\u000f\u00111a\u0018\u00132#\u0011\tI!a\u0004\u0011\u0007M\fY!C\u0002\u0002\u000eu\u0012qAT8uQ&tw\rE\u0002t\u0003#I1!a\u0005>\u0005\r\te.\u001f\u0015\u0005\u0017\u0015\u000b9\"\t\u0002\u0002\u001a\u0005)!G\f\u0019/a\u0005q\u0011n\u001d'be\u001e,'OQ3ui\u0016\u0014XCAA\u0010!\r\u0019\u0018\u0011E\u0005\u0004\u0003Gi$a\u0002\"p_2,\u0017M\u001c\u0015\u0004\u0019\u0015[\u0015\u0001B2paf$2!UA\u0016\u0011\u001d\ti#\u0004a\u0001\u0003_\tQ!\u001a=ue\u0006\u00042AWA\u0019\u0013\r\t\u0019\u0004\u000b\u0002\t!\u0006\u0014\u0018-\\'ba\"\u001aQ\"R&)\u0007\u0001\tI\u0004E\u0002G\u0003wI1!!\u0010H\u00051)\u0005\u0010]3sS6,g\u000e^1mQ\r\u0001QiS\u0001\"\u001bVdG/[2mCN\u001c8\t\\1tg&4\u0017nY1uS>tWI^1mk\u0006$xN\u001d\t\u0003C=\u0019raDA$\u0003\u001b\n\u0019\u0006E\u0002t\u0003\u0013J1!a\u0013>\u0005\u0019\te.\u001f*fMB!\u0001'a\u0014R\u0013\r\t\t&\r\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:SK\u0006$\u0017M\u00197f!\r\u0019\u0018QK\u0005\u0004\u0003/j$\u0001D*fe&\fG.\u001b>bE2,GCAA\"\u0003\u0011aw.\u00193\u0015\u0007E\u000by\u0006\u0003\u0004\u0002bE\u0001\raN\u0001\u0005a\u0006$\b\u000e\u000b\u0003\u0012\u000b\u0006\u0015\u0014EAA4\u0003\u0015\tdF\u000e\u00181\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u00055\u0004\u0003BA8\u0003sj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\u0005Y\u0006twM\u0003\u0002\u0002x\u0005!!.\u0019<b\u0013\u0011\tY(!\u001d\u0003\r=\u0013'.Z2uQ\u0011yQ)!\u001a)\t9)\u0015Q\r")
public class MulticlassClassificationEvaluator
extends Evaluator
implements HasPredictionCol,
HasLabelCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> labelCol;
    private final Param<String> predictionCol;

    public static MulticlassClassificationEvaluator load(String string) {
        return MulticlassClassificationEvaluator$.MODULE$.load(string);
    }

    public static MLReader<MulticlassClassificationEvaluator> read() {
        return MulticlassClassificationEvaluator$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public MulticlassClassificationEvaluator setMetricName(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.metricName(), value);
    }

    public MulticlassClassificationEvaluator setPredictionCol(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.predictionCol(), value);
    }

    public MulticlassClassificationEvaluator setLabelCol(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(Dataset<?> dataset) {
        double d;
        StructType schema = dataset.schema();
        SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.predictionCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.labelCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        RDD predictionAndLabels = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$)})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double d;
            Object label;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                    Object prediction = ((SeqLike)some.get()).apply(0);
                    label = ((SeqLike)some.get()).apply(1);
                    if (!(prediction instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)prediction);
                    if (label instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d2 = BoxesRunTime.unboxToDouble((Object)label);
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
            return sp2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        MulticlassMetrics metrics = new MulticlassMetrics((RDD<Tuple2<Object, Object>>)predictionAndLabels);
        String string = this.$(this.metricName());
        if ("f1".equals(string)) {
            d = metrics.weightedFMeasure();
        } else if ("weightedPrecision".equals(string)) {
            d = metrics.weightedPrecision();
        } else if ("weightedRecall".equals(string)) {
            d = metrics.weightedRecall();
        } else if ("accuracy".equals(string)) {
            d = metrics.accuracy();
        } else {
            throw new MatchError((Object)string);
        }
        double metric = d;
        return metric;
    }

    @Override
    public boolean isLargerBetter() {
        return true;
    }

    @Override
    public MulticlassClassificationEvaluator copy(ParamMap extra) {
        return (MulticlassClassificationEvaluator)this.defaultCopy(extra);
    }

    public MulticlassClassificationEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol.$init$(this);
        HasLabelCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"f1", "weightedPrecision", "weightedRecall", "accuracy"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (f1|weightedPrecision|weightedRecall|accuracy)", allowedParams);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("f1")}));
    }

    public MulticlassClassificationEvaluator() {
        this(Identifiable$.MODULE$.randomUID("mcEval"));
    }
}

