/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.clustering.BisectingKMeans$;
import org.apache.spark.ml.clustering.BisectingKMeansModel;
import org.apache.spark.ml.clustering.BisectingKMeansParams;
import org.apache.spark.ml.clustering.BisectingKMeansSummary;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasDistanceMeasure;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001\u0002\u000b\u0016\u0001\u0001B\u0001B\r\u0001\u0003\u0006\u0004%\te\r\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005i!)A\n\u0001C\u0001\u001b\")!\u000b\u0001C!'\")A\n\u0001C\u0001;\")q\f\u0001C\u0001A\")Q\r\u0001C\u0001M\")\u0011\u000e\u0001C\u0001U\")\u0011\u000f\u0001C\u0001e\")Q\u000f\u0001C\u0001m\")A\u0010\u0001C\u0001{\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u0003\u0003\u0002A\u0011IA\"\u000f\u001d\tI&\u0006E\u0001\u000372a\u0001F\u000b\t\u0002\u0005u\u0003B\u0002'\u0011\t\u0003\t\t\bC\u0004\u0002tA!\t%!\u001e\t\u0013\u0005u\u0004#!A\u0005\n\u0005}$a\u0004\"jg\u0016\u001cG/\u001b8h\u00176+\u0017M\\:\u000b\u0005Y9\u0012AC2mkN$XM]5oO*\u0011\u0001$G\u0001\u0003[2T!AG\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011%\u000b\u0017\u0011\u0007\t\u001aS%D\u0001\u0018\u0013\t!sCA\u0005FgRLW.\u0019;peB\u0011aeJ\u0007\u0002+%\u0011\u0001&\u0006\u0002\u0015\u0005&\u001cXm\u0019;j]\u001e\\U*Z1og6{G-\u001a7\u0011\u0005\u0019R\u0013BA\u0016\u0016\u0005U\u0011\u0015n]3di&twmS'fC:\u001c\b+\u0019:b[N\u0004\"!\f\u0019\u000e\u00039R!aL\f\u0002\tU$\u0018\u000e\\\u0005\u0003c9\u0012Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW-A\u0002vS\u0012,\u0012\u0001\u000e\t\u0003kyr!A\u000e\u001f\u0011\u0005]RT\"\u0001\u001d\u000b\u0005ez\u0012A\u0002\u001fs_>$hHC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f;Q\r\t!\t\u0013\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bf\t!\"\u00198o_R\fG/[8o\u0013\t9EIA\u0003TS:\u001cW-I\u0001J\u0003\u0015\u0011d\u0006\r\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\t\u0011\u0005*\u0001\u0004=S:LGO\u0010\u000b\u0003\u001d>\u0003\"A\n\u0001\t\u000bI\u001a\u0001\u0019\u0001\u001b)\u0007=\u0013\u0005\nK\u0002\u0004\u0005\"\u000bAaY8qsR\u0011a\n\u0016\u0005\u0006+\u0012\u0001\rAV\u0001\u0006Kb$(/\u0019\t\u0003/jk\u0011\u0001\u0017\u0006\u00033^\tQ\u0001]1sC6L!a\u0017-\u0003\u0011A\u000b'/Y7NCBD3\u0001\u0002\"I)\u0005q\u0005fA\u0003C\u0011\u0006q1/\u001a;GK\u0006$XO]3t\u0007>dGCA1c\u001b\u0005\u0001\u0001\"B2\u0007\u0001\u0004!\u0014!\u0002<bYV,\u0007f\u0001\u0004C\u0011\u0006\u00012/\u001a;Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\u000b\u0003C\u001eDQaY\u0004A\u0002QB3a\u0002\"I\u0003\u0011\u0019X\r^&\u0015\u0005\u0005\\\u0007\"B2\t\u0001\u0004a\u0007CA7o\u001b\u0005Q\u0014BA8;\u0005\rIe\u000e\u001e\u0015\u0004\u0011\tC\u0015AC:fi6\u000b\u00070\u0013;feR\u0011\u0011m\u001d\u0005\u0006G&\u0001\r\u0001\u001c\u0015\u0004\u0013\tC\u0015aB:fiN+W\r\u001a\u000b\u0003C^DQa\u0019\u0006A\u0002a\u0004\"!\\=\n\u0005iT$\u0001\u0002'p]\u001eD3A\u0003\"I\u0003i\u0019X\r^'j]\u0012Kg/[:jE2,7\t\\;ti\u0016\u00148+\u001b>f)\t\tg\u0010C\u0003d\u0017\u0001\u0007q\u0010E\u0002n\u0003\u0003I1!a\u0001;\u0005\u0019!u.\u001e2mK\"\u001a1B\u0011%\u0002%M,G\u000fR5ti\u0006t7-Z'fCN,(/\u001a\u000b\u0004C\u0006-\u0001\"B2\r\u0001\u0004!\u0004\u0006\u0002\u0007C\u0003\u001f\t#!!\u0005\u0002\u000bIrCG\f\u0019\u0002\u0007\u0019LG\u000fF\u0002&\u0003/Aq!!\u0007\u000e\u0001\u0004\tY\"A\u0004eCR\f7/\u001a;1\t\u0005u\u0011Q\u0006\t\u0007\u0003?\t)#!\u000b\u000e\u0005\u0005\u0005\"bAA\u00123\u0005\u00191/\u001d7\n\t\u0005\u001d\u0012\u0011\u0005\u0002\b\t\u0006$\u0018m]3u!\u0011\tY#!\f\r\u0001\u0011a\u0011qFA\f\u0003\u0003\u0005\tQ!\u0001\u00022\t\u0019q\fJ\u001a\u0012\t\u0005M\u0012\u0011\b\t\u0004[\u0006U\u0012bAA\u001cu\t9aj\u001c;iS:<\u0007cA7\u0002<%\u0019\u0011Q\b\u001e\u0003\u0007\u0005s\u0017\u0010K\u0002\u000e\u0005\"\u000bq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0005\u0003\u000b\n\t\u0006\u0005\u0003\u0002H\u00055SBAA%\u0015\u0011\tY%!\t\u0002\u000bQL\b/Z:\n\t\u0005=\u0013\u0011\n\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA*\u001d\u0001\u0007\u0011QI\u0001\u0007g\u000eDW-\\1)\u00079\u0011\u0005\nK\u0002\u0001\u0005\"\u000bqBQ5tK\u000e$\u0018N\\4L\u001b\u0016\fgn\u001d\t\u0003MA\u0019r\u0001EA0\u0003K\nY\u0007E\u0002n\u0003CJ1!a\u0019;\u0005\u0019\te.\u001f*fMB!Q&a\u001aO\u0013\r\tIG\f\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:SK\u0006$\u0017M\u00197f!\ri\u0017QN\u0005\u0004\u0003_R$\u0001D*fe&\fG.\u001b>bE2,GCAA.\u0003\u0011aw.\u00193\u0015\u00079\u000b9\b\u0003\u0004\u0002zI\u0001\r\u0001N\u0001\u0005a\u0006$\b\u000eK\u0002\u0013\u0005\"\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bi)\u0004\u0002\u0002\u0006*!\u0011qQAE\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0015\u0001\u00026bm\u0006LA!a$\u0002\u0006\n1qJ\u00196fGRD3\u0001\u0005\"IQ\ry!\t\u0013")
public class BisectingKMeans
extends Estimator<BisectingKMeansModel>
implements BisectingKMeansParams,
DefaultParamsWritable {
    private final String uid;
    private final IntParam k;
    private final DoubleParam minDivisibleClusterSize;
    private final Param<String> distanceMeasure;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static BisectingKMeans load(String string) {
        return BisectingKMeans$.MODULE$.load(string);
    }

    public static MLReader<BisectingKMeans> read() {
        return BisectingKMeans$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return BisectingKMeansParams.getK$(this);
    }

    @Override
    public double getMinDivisibleClusterSize() {
        return BisectingKMeansParams.getMinDivisibleClusterSize$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return BisectingKMeansParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final String getDistanceMeasure() {
        return HasDistanceMeasure.getDistanceMeasure$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final DoubleParam minDivisibleClusterSize() {
        return this.minDivisibleClusterSize;
    }

    @Override
    public final void org$apache$spark$ml$clustering$BisectingKMeansParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$BisectingKMeansParams$_setter_$minDivisibleClusterSize_$eq(DoubleParam x$1) {
        this.minDivisibleClusterSize = x$1;
    }

    @Override
    public final Param<String> distanceMeasure() {
        return this.distanceMeasure;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasDistanceMeasure$_setter_$distanceMeasure_$eq(Param<String> x$1) {
        this.distanceMeasure = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public BisectingKMeans copy(ParamMap extra) {
        return (BisectingKMeans)this.defaultCopy(extra);
    }

    public BisectingKMeans setFeaturesCol(String value) {
        return (BisectingKMeans)this.set(this.featuresCol(), value);
    }

    public BisectingKMeans setPredictionCol(String value) {
        return (BisectingKMeans)this.set(this.predictionCol(), value);
    }

    public BisectingKMeans setK(int value) {
        return (BisectingKMeans)this.set(this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public BisectingKMeans setMaxIter(int value) {
        return (BisectingKMeans)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public BisectingKMeans setSeed(long value) {
        return (BisectingKMeans)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public BisectingKMeans setMinDivisibleClusterSize(double value) {
        return (BisectingKMeans)this.set(this.minDivisibleClusterSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public BisectingKMeans setDistanceMeasure(String value) {
        return (BisectingKMeans)this.set(this.distanceMeasure(), value);
    }

    @Override
    public BisectingKMeansModel fit(Dataset<?> dataset) {
        return (BisectingKMeansModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            this.transformSchema(dataset.schema(), true);
            RDD<org.apache.spark.mllib.linalg.Vector> rdd = DatasetUtils$.MODULE$.columnToOldVector(dataset, this.getFeaturesCol());
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.featuresCol(), this.predictionCol(), this.k(), this.maxIter(), this.seed(), this.minDivisibleClusterSize(), this.distanceMeasure()}));
            org.apache.spark.mllib.clustering.BisectingKMeans bkm = new org.apache.spark.mllib.clustering.BisectingKMeans().setK(BoxesRunTime.unboxToInt((Object)this.$(this.k()))).setMaxIterations(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter()))).setMinDivisibleClusterSize(BoxesRunTime.unboxToDouble((Object)this.$(this.minDivisibleClusterSize()))).setSeed(BoxesRunTime.unboxToLong((Object)this.$(this.seed()))).setDistanceMeasure(this.$(this.distanceMeasure()));
            org.apache.spark.mllib.clustering.BisectingKMeansModel parentModel = bkm.run(rdd, (Option<Instrumentation>)new Some(instr));
            BisectingKMeansModel model = this.copyValues(new BisectingKMeansModel(this.uid(), parentModel).setParent(this), this.copyValues$default$2());
            BisectingKMeansSummary summary = new BisectingKMeansSummary(model.transform(dataset), this.$(this.predictionCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())), BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())));
            instr.logNamedValue("clusterSizes", summary.clusterSizes());
            instr.logNumFeatures(((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).size());
            return model.setSummary((Option<BisectingKMeansSummary>)new Some((Object)summary));
        });
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public BisectingKMeans(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasDistanceMeasure.$init$(this);
        BisectingKMeansParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.k().$minus$greater(BoxesRunTime.boxToInteger((int)4)), this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)20)), this.minDivisibleClusterSize().$minus$greater(BoxesRunTime.boxToDouble((double)1.0))}));
    }

    public BisectingKMeans() {
        this(Identifiable$.MODULE$.randomUID("bisecting-kmeans"));
    }
}

