/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.RandomForestClassificationModel$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.RandomForestClassifierParams;
import org.apache.spark.ml.tree.RandomForestParams;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.package$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t5e\u0001B\u0015+\u0001UB\u0001\"\u0017\u0001\u0003\u0006\u0004%\tE\u0017\u0005\t_\u0002\u0011\t\u0011)A\u00057\"A\u0011\u000f\u0001BC\u0002\u0013%!\u000f\u0003\u0005w\u0001\t\u0005\t\u0015!\u0003t\u0011!9\bA!b\u0001\n\u0003B\b\u0002C@\u0001\u0005\u0003\u0005\u000b\u0011B=\t\u0013\u0005\r\u0001A!b\u0001\n\u0003B\b\"CA\u0004\u0001\t\u0005\t\u0015!\u0003z\u0011!\tY\u0001\u0001C\u0001Y\u00055\u0001\u0002CA\u0006\u0001\u0011\u0005A&!\b\t\r\u0005\u0005\u0002\u0001\"\u0011s\u0011)\ti\u0003\u0001EC\u0002\u0013%\u0011q\u0006\u0005\b\u0003s\u0001A\u0011IA\u0018\u0011\u001d\ti\u0004\u0001C)\u0003\u007fAq!a\"\u0001\t#\nI\tC\u0004\u0002\u0010\u0002!\t&!%\t\u000f\u0005]\u0005\u0001\"\u0011\u0002\u001a\"9\u0011Q\u0016\u0001\u0005B\u0005=\u0006BCAZ\u0001!\u0015\r\u0011\"\u0001\u00026\"A\u0011\u0011\u0018\u0001\u0005\u00021\nY\fC\u0004\u0002P\u0002!\t%!5\b\u000f\u0005\u0005(\u0006#\u0001\u0002d\u001a1\u0011F\u000bE\u0001\u0003KDq!a\u0003\u0018\t\u0003\t\u0019\u0010C\u0004\u0002v^!\t%a>\t\u000f\t\u0005q\u0003\"\u0011\u0003\u0004\u00199!1B\f\u0001/\t5\u0001\"\u0003B\b7\t\u0005\t\u0015!\u0003A\u0011\u001d\tYa\u0007C\u0001\u0005#AqA!\u0007\u001c\t#\u0012YB\u0002\u0004\u0003&]!!q\u0005\u0005\b\u0003\u0017yB\u0011\u0001B\u0015\u0011%\u0011ic\bb\u0001\n\u0013\u0011y\u0003\u0003\u0005\u0003@}\u0001\u000b\u0011\u0002B\u0019\u0011%\u0011\te\bb\u0001\n\u0013\u0011y\u0003\u0003\u0005\u0003D}\u0001\u000b\u0011\u0002B\u0019\u0011\u001d\u0011\ta\bC!\u0005\u000bB\u0001B!\u0013\u0018\t\u0003a#1\n\u0005\u000b\u0005S:\u0012\u0013!C\u0001Y\t-\u0004\"\u0003B@/\u0005\u0005I\u0011\u0002BA\u0005}\u0011\u0016M\u001c3p[\u001a{'/Z:u\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\u0006\u0003W1\nab\u00197bgNLg-[2bi&|gN\u0003\u0002.]\u0005\u0011Q\u000e\u001c\u0006\u0003_A\nQa\u001d9be.T!!\r\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0014aA8sO\u000e\u00011C\u0002\u00017\u0003\u001ek5\u000b\u0005\u00038qi\u0002U\"\u0001\u0016\n\u0005eR#\u0001\t)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[2bi&|g.T8eK2\u0004\"a\u000f \u000e\u0003qR!!\u0010\u0017\u0002\r1Lg.\u00197h\u0013\tyDH\u0001\u0004WK\u000e$xN\u001d\t\u0003o\u0001\u0001\"AQ#\u000e\u0003\rS!\u0001\u0012\u0017\u0002\tQ\u0014X-Z\u0005\u0003\r\u000e\u0013ADU1oI>lgi\u001c:fgR\u001cE.Y:tS\u001aLWM\u001d)be\u0006l7\u000fE\u0002C\u0011*K!!S\"\u0003#Q\u0013X-Z#og\u0016l'\r\\3N_\u0012,G\u000e\u0005\u00028\u0017&\u0011AJ\u000b\u0002 \t\u0016\u001c\u0017n]5p]R\u0013X-Z\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d\u0007C\u0001(R\u001b\u0005y%B\u0001)-\u0003\u0011)H/\u001b7\n\u0005I{%AC'M/JLG/\u00192mKB\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\na1+\u001a:jC2L'0\u00192mK\u0006\u0019Q/\u001b3\u0016\u0003m\u0003\"\u0001X2\u000f\u0005u\u000b\u0007C\u00010V\u001b\u0005y&B\u000115\u0003\u0019a$o\\8u}%\u0011!-V\u0001\u0007!J,G-\u001a4\n\u0005\u0011,'AB*ue&twM\u0003\u0002c+\"\u001a\u0011aZ7\u0011\u0005!\\W\"A5\u000b\u0005)t\u0013AC1o]>$\u0018\r^5p]&\u0011A.\u001b\u0002\u0006'&t7-Z\u0011\u0002]\u0006)\u0011GL\u001b/a\u0005!Q/\u001b3!Q\r\u0011q-\\\u0001\u0007?R\u0014X-Z:\u0016\u0003M\u00042\u0001\u0016;K\u0013\t)XKA\u0003BeJ\f\u00170A\u0004`iJ,Wm\u001d\u0011\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0002sB\u0011AK_\u0005\u0003wV\u00131!\u00138uQ\r)q-`\u0011\u0002}\u0006)\u0011G\f\u001c/a\u0005aa.^7GK\u0006$XO]3tA!\u001aaaZ?\u0002\u00159,Xn\u00117bgN,7\u000fK\u0002\bO6\f1B\\;n\u00072\f7o]3tA!\u001a\u0001bZ7\u0002\rqJg.\u001b;?)%\u0001\u0015qBA\n\u0003+\tI\u0002C\u0003Z\u0013\u0001\u00071\f\u000b\u0003\u0002\u0010\u001dl\u0007\"B9\n\u0001\u0004\u0019\b\"B<\n\u0001\u0004I\b\u0006BA\u000bOvDa!a\u0001\n\u0001\u0004I\b\u0006BA\rO6$r\u0001QA\u0010\u0003G\t)\u0003\u0003\u0004\u0002\")\u0001\ra]\u0001\u0006iJ,Wm\u001d\u0005\u0006o*\u0001\r!\u001f\u0005\u0007\u0003\u0007Q\u0001\u0019A=)\t-9\u0017\u0011F\u0011\u0003\u0003W\tQ!\r\u00185]A\nAb\u0018;sK\u0016<V-[4iiN,\"!!\r\u0011\tQ#\u00181\u0007\t\u0004)\u0006U\u0012bAA\u001c+\n1Ai\\;cY\u0016\f1\u0002\u001e:fK^+\u0017n\u001a5ug\"\"QbZA\u0015\u00035!(/\u00198tM>\u0014X.S7qYR!\u0011\u0011IA2!\u0011\t\u0019%!\u0018\u000f\t\u0005\u0015\u0013q\u000b\b\u0005\u0003\u000f\n\u0019F\u0004\u0003\u0002J\u0005Ec\u0002BA&\u0003\u001fr1AXA'\u0013\u0005\u0019\u0014BA\u00193\u0013\ty\u0003'C\u0002\u0002V9\n1a]9m\u0013\u0011\tI&a\u0017\u0002\u000fA\f7m[1hK*\u0019\u0011Q\u000b\u0018\n\t\u0005}\u0013\u0011\r\u0002\n\t\u0006$\u0018M\u0012:b[\u0016TA!!\u0017\u0002\\!9\u0011Q\r\bA\u0002\u0005\u001d\u0014a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003S\n)\b\u0005\u0004\u0002l\u00055\u0014\u0011O\u0007\u0003\u00037JA!a\u001c\u0002\\\t9A)\u0019;bg\u0016$\b\u0003BA:\u0003kb\u0001\u0001\u0002\u0007\u0002x\u0005\r\u0014\u0011!A\u0001\u0006\u0003\tIHA\u0002`II\nB!a\u001f\u0002\u0002B\u0019A+! \n\u0007\u0005}TKA\u0004O_RD\u0017N\\4\u0011\u0007Q\u000b\u0019)C\u0002\u0002\u0006V\u00131!\u00118z\u0003)\u0001(/\u001a3jGR\u0014\u0016m\u001e\u000b\u0004u\u0005-\u0005BBAG\u001f\u0001\u0007!(\u0001\u0005gK\u0006$XO]3t\u0003Y\u0011\u0018m\u001e\u001aqe>\u0014\u0017MY5mSRL\u0018J\u001c)mC\u000e,Gc\u0001\u001e\u0002\u0014\"1\u0011Q\u0013\tA\u0002i\nQB]1x!J,G-[2uS>t\u0017\u0001B2paf$2\u0001QAN\u0011\u001d\ti*\u0005a\u0001\u0003?\u000bQ!\u001a=ue\u0006\u0004B!!)\u0002(6\u0011\u00111\u0015\u0006\u0004\u0003Kc\u0013!\u00029be\u0006l\u0017\u0002BAU\u0003G\u0013\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0005#\u001d\fI#\u0001\u0005u_N#(/\u001b8h)\u0005Y\u0006\u0006\u0002\nh\u0003S\t!CZ3biV\u0014X-S7q_J$\u0018M\\2fgV\t!\bK\u0002\u0014O6\fQ\u0001^8PY\u0012,\"!!0\u0011\t\u0005}\u00161Z\u0007\u0003\u0003\u0003TA!a1\u0002F\u0006)Qn\u001c3fY*\u0019A)a2\u000b\u0007\u0005%g&A\u0003nY2L'-\u0003\u0003\u0002N\u0006\u0005'!\u0005*b]\u0012|WNR8sKN$Xj\u001c3fY\u0006)qO]5uKV\u0011\u00111\u001b\t\u0004\u001d\u0006U\u0017bAAl\u001f\nAQ\nT,sSR,'\u000f\u000b\u0003\u0016O\u0006m\u0017EAAo\u0003\u0015\u0011d\u0006\r\u00181Q\u0011\u0001q-!\u000b\u0002?I\u000bg\u000eZ8n\r>\u0014Xm\u001d;DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u00028/M1q#a:\u0002nN\u00032\u0001VAu\u0013\r\tY/\u0016\u0002\u0007\u0003:L(+\u001a4\u0011\t9\u000by\u000fQ\u0005\u0004\u0003c|%AC'M%\u0016\fG-\u00192mKR\u0011\u00111]\u0001\u0005e\u0016\fG-\u0006\u0002\u0002zB!a*a?A\u0013\r\tip\u0014\u0002\t\u001b2\u0013V-\u00193fe\"\"\u0011dZAn\u0003\u0011aw.\u00193\u0015\u0007\u0001\u0013)\u0001\u0003\u0004\u0003\bi\u0001\raW\u0001\u0005a\u0006$\b\u000e\u000b\u0003\u001bO\u0006m'!\n*b]\u0012|WNR8sKN$8\t\\1tg&4\u0017nY1uS>tWj\u001c3fY^\u0013\u0018\u000e^3s'\rY\u00121[\u0001\tS:\u001cH/\u00198dKR!!1\u0003B\f!\r\u0011)bG\u0007\u0002/!1!qB\u000fA\u0002\u0001\u000b\u0001b]1wK&k\u0007\u000f\u001c\u000b\u0005\u0005;\u0011\u0019\u0003E\u0002U\u0005?I1A!\tV\u0005\u0011)f.\u001b;\t\r\t\u001da\u00041\u0001\\\u0005\u0015\u0012\u0016M\u001c3p[\u001a{'/Z:u\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c*fC\u0012,'oE\u0002 \u0003s$\"Aa\u000b\u0011\u0007\tUq$A\u0005dY\u0006\u001c8OT1nKV\u0011!\u0011\u0007\t\u0005\u0005g\u0011i$\u0004\u0002\u00036)!!q\u0007B\u001d\u0003\u0011a\u0017M\\4\u000b\u0005\tm\u0012\u0001\u00026bm\u0006L1\u0001\u001aB\u001b\u0003)\u0019G.Y:t\u001d\u0006lW\rI\u0001\u000eiJ,Wm\u00117bgNt\u0015-\\3\u0002\u001dQ\u0014X-Z\"mCN\u001ch*Y7fAQ\u0019\u0001Ia\u0012\t\r\t\u001dQ\u00051\u0001\\\u0003\u001d1'o\\7PY\u0012$2\u0002\u0011B'\u0005#\u0012YF!\u001a\u0003h!9!q\n\u0014A\u0002\u0005u\u0016\u0001C8mI6{G-\u001a7\t\u000f\tMc\u00051\u0001\u0003V\u00051\u0001/\u0019:f]R\u00042a\u000eB,\u0013\r\u0011IF\u000b\u0002\u0017%\u0006tGm\\7G_J,7\u000f^\"mCN\u001c\u0018NZ5fe\"9!Q\f\u0014A\u0002\t}\u0013aE2bi\u0016<wN]5dC24U-\u0019;ve\u0016\u001c\b#\u0002/\u0003beL\u0018b\u0001B2K\n\u0019Q*\u00199\t\r\u0005\ra\u00051\u0001z\u0011\u001d9h\u0005%AA\u0002e\f\u0011C\u001a:p[>cG\r\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011iGK\u0002z\u0005_Z#A!\u001d\u0011\t\tM$1P\u0007\u0003\u0005kRAAa\u001e\u0003z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003UVKAA! \u0003v\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0007\u0003BAa\r\u0003\u0006&!!q\u0011B\u001b\u0005\u0019y%M[3di\"\"qcZAnQ\u00111r-a7")
public class RandomForestClassificationModel
extends ProbabilisticClassificationModel<Vector, RandomForestClassificationModel>
implements RandomForestClassifierParams,
TreeEnsembleModel<DecisionTreeClassificationModel>,
MLWritable {
    private double[] _treeWeights;
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeClassificationModel[] _trees;
    private final int numFeatures;
    private final int numClasses;
    private int totalNumNodes;
    private final Param<String> impurity;
    private final IntParam numTrees;
    private final DoubleParam subsamplingRate;
    private final Param<String> featureSubsetStrategy;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static RandomForestClassificationModel load(String string) {
        return RandomForestClassificationModel$.MODULE$.load(string);
    }

    public static MLReader<RandomForestClassificationModel> read() {
        return RandomForestClassificationModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public TreeClassifierParams setImpurity(String value) {
        return TreeClassifierParams.setImpurity$(this, value);
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams.getOldImpurity$(this);
    }

    @Override
    public RandomForestParams setNumTrees(int value) {
        return RandomForestParams.setNumTrees$(this, value);
    }

    @Override
    public final int getNumTrees() {
        return RandomForestParams.getNumTrees$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public TreeEnsembleParams setSubsamplingRate(double value) {
        return TreeEnsembleParams.setSubsamplingRate$(this, value);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public TreeEnsembleParams setFeatureSubsetStrategy(String value) {
        return TreeEnsembleParams.setFeatureSubsetStrategy$(this, value);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public DecisionTreeParams setMaxDepth(int value) {
        return DecisionTreeParams.setMaxDepth$(this, value);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public DecisionTreeParams setMaxBins(int value) {
        return DecisionTreeParams.setMaxBins$(this, value);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public DecisionTreeParams setMinInstancesPerNode(int value) {
        return DecisionTreeParams.setMinInstancesPerNode$(this, value);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public DecisionTreeParams setMinInfoGain(double value) {
        return DecisionTreeParams.setMinInfoGain$(this, value);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public DecisionTreeParams setSeed(long value) {
        return DecisionTreeParams.setSeed$(this, value);
    }

    @Override
    public DecisionTreeParams setMaxMemoryInMB(int value) {
        return DecisionTreeParams.setMaxMemoryInMB$(this, value);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public DecisionTreeParams setCacheNodeIds(boolean value) {
        return DecisionTreeParams.setCacheNodeIds$(this, value);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public DecisionTreeParams setCheckpointInterval(int value) {
        return DecisionTreeParams.setCheckpointInterval$(this, value);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final IntParam numTrees() {
        return this.numTrees;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$numTrees_$eq(IntParam x$1) {
        this.numTrees = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeClassificationModel[] _trees() {
        return this._trees;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public DecisionTreeClassificationModel[] trees() {
        return this._trees();
    }

    private double[] _treeWeights$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._treeWeights = (double[])Array$.MODULE$.fill(this._trees().length, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._treeWeights;
    }

    private double[] _treeWeights() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._treeWeights$lzycompute() : this._treeWeights;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(RandomForestClassificationModel.class));
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)RandomForestClassificationModel.$anonfun$transformImpl$1(bcastModel, features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Any());
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public Vector predictRaw(Vector features) {
        double[] votes = (double[])Array$.MODULE$.fill(this.numClasses(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).view().foreach((Function1 & Serializable & scala.Serializable)tree -> {
            RandomForestClassificationModel.$anonfun$predictRaw$2(this, features, votes, tree);
            return BoxedUnit.UNIT;
        });
        return Vectors$.MODULE$.dense(votes);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (!(vector instanceof DenseVector)) {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in RandomForestClassificationModel: raw2probabilityInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector = (DenseVector)vector;
        ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    @Override
    public RandomForestClassificationModel copy(ParamMap extra) {
        return (RandomForestClassificationModel)((Model)this.copyValues(new RandomForestClassificationModel(this.uid(), this._trees(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(50).append("RandomForestClassificationModel (uid=").append(this.uid()).append(") with ").append(this.getNumTrees()).append(" trees").toString();
    }

    private Vector featureImportances$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    public RandomForestModel toOld() {
        return new RandomForestModel(Algo$.MODULE$.Classification(), (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toOld(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))));
    }

    @Override
    public MLWriter write() {
        return new RandomForestClassificationModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$transformImpl$1(Broadcast bcastModel$1, Object features) {
        return ((ClassificationModel)bcastModel$1.value()).predict((Vector)features);
    }

    public static final /* synthetic */ void $anonfun$predictRaw$2(RandomForestClassificationModel $this, Vector features$1, double[] votes$1, DecisionTreeClassificationModel tree) {
        double[] classCounts = tree.rootNode().predictImpl(features$1).impurityStats().stats();
        double total = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(classCounts)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        if (total != 0.0) {
            for (int i = 0; i < $this.numClasses(); ++i) {
                int n = i;
                votes$1[n] = votes$1[n] + classCounts[i] / total;
            }
        }
    }

    public RandomForestClassificationModel(String uid, DecisionTreeClassificationModel[] _trees, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        RandomForestParams.$init$(this);
        TreeClassifierParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])_trees)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "RandomForestClassificationModel requires at least 1 tree.");
    }

    public RandomForestClassificationModel(DecisionTreeClassificationModel[] trees, int numFeatures, int numClasses) {
        this(Identifiable$.MODULE$.randomUID("rfc"), trees, numFeatures, numClasses);
    }

    public static class RandomForestClassificationModelReader
    extends MLReader<RandomForestClassificationModel> {
        private final String className = RandomForestClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeClassificationModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public RandomForestClassificationModel load(String path) {
            DefaultParamsReader.Metadata metadata;
            Tuple2[] treesData;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    treesData = (Tuple2[])tuple3._2();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            Tuple2[] tuple2Array = treesData;
            Tuple2 tuple2 = new Tuple2((Object)metadata, (Object)tuple2Array);
            Tuple2 tuple22 = tuple2;
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple22._1();
            Tuple2[] treesData2 = (Tuple2[])tuple22._2();
            int numFeatures = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numFeatures")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numClasses = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numClasses")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numTrees")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeClassificationModel[] trees = (DecisionTreeClassificationModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])treesData2)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                Node root = (Node)tuple2._2();
                DecisionTreeClassificationModel tree = new DecisionTreeClassificationModel(treeMetadata.uid(), root, numFeatures, numClasses);
                treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                DecisionTreeClassificationModel decisionTreeClassificationModel = tree;
                return decisionTreeClassificationModel;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeClassificationModel.class)));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("RandomForestClassificationModel.load expected ").append(numTrees).append(" trees based on metadata but found ").append(trees.length).append(" trees.").toString());
            RandomForestClassificationModel model = new RandomForestClassificationModel(metadata3.uid(), trees, numFeatures, numClasses);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class RandomForestClassificationModelWriter
    extends MLWriter {
        private final RandomForestClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numClasses"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numClasses())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public RandomForestClassificationModelWriter(RandomForestClassificationModel instance) {
            this.instance = instance;
        }
    }
}

