/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.ClassifierParams;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasThresholds;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005]c!B\b\u0011\u0003\u0003Y\u0002\"B\u001c\u0001\t\u0003A\u0004\"B\u001d\u0001\t\u0003Q\u0004\"\u0002%\u0001\t\u0003I\u0005\"B)\u0001\t\u0003\u0012\u0006\"\u00028\u0001\r#y\u0007\"\u0002=\u0001\t#I\b\"B>\u0001\t#b\b\"\u0002@\u0001\t#y\bbBA\u0003\u0001\u0011E\u0011qA\u0004\t\u00037\u0001\u0002\u0012\u0001\n\u0002\u001e\u00199q\u0002\u0005E\u0001%\u0005}\u0001BB\u001c\f\t\u0003\ti\u0003C\u0004\u00020-!\t!!\r\t\u0013\u0005\r3\"!A\u0005\n\u0005\u0015#\u0001\t)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[2bi&|g.T8eK2T!!\u0005\n\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u00111\u0003F\u0001\u0003[2T!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001+\ra2\u0005M\n\u0004\u0001u!\u0004\u0003\u0002\u0010 C=j\u0011\u0001E\u0005\u0003AA\u00111c\u00117bgNLg-[2bi&|g.T8eK2\u0004\"AI\u0012\r\u0001\u0011)A\u0005\u0001b\u0001K\taa)Z1ukJ,7\u000fV=qKF\u0011a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\b\u001d>$\b.\u001b8h!\t9S&\u0003\u0002/Q\t\u0019\u0011I\\=\u0011\u0005\t\u0002D!B\u0019\u0001\u0005\u0004\u0011$!A'\u0012\u0005\u0019\u001a\u0004\u0003\u0002\u0010\u0001C=\u0002\"AH\u001b\n\u0005Y\u0002\"!\b)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[3s!\u0006\u0014\u0018-\\:\u0002\rqJg.\u001b;?)\u0005\u0019\u0014!E:fiB\u0013xNY1cS2LG/_\"pYR\u0011qf\u000f\u0005\u0006y\t\u0001\r!P\u0001\u0006m\u0006dW/\u001a\t\u0003}\u0015s!aP\"\u0011\u0005\u0001CS\"A!\u000b\u0005\tS\u0012A\u0002\u001fs_>$h(\u0003\u0002EQ\u00051\u0001K]3eK\u001aL!AR$\u0003\rM#(/\u001b8h\u0015\t!\u0005&A\u0007tKR$\u0006N]3tQ>dGm\u001d\u000b\u0003_)CQ\u0001P\u0002A\u0002-\u00032a\n'O\u0013\ti\u0005FA\u0003BeJ\f\u0017\u0010\u0005\u0002(\u001f&\u0011\u0001\u000b\u000b\u0002\u0007\t>,(\r\\3\u0002\u0013Q\u0014\u0018M\\:g_JlGCA*e!\t!\u0016M\u0004\u0002V=:\u0011a\u000b\u0018\b\u0003/ns!\u0001\u0017.\u000f\u0005\u0001K\u0016\"A\r\n\u0005]A\u0012BA\u000b\u0017\u0013\tiF#A\u0002tc2L!a\u00181\u0002\u000fA\f7m[1hK*\u0011Q\fF\u0005\u0003E\u000e\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005}\u0003\u0007\"B3\u0005\u0001\u00041\u0017a\u00023bi\u0006\u001cX\r\u001e\u0019\u0003O2\u00042\u0001[5l\u001b\u0005\u0001\u0017B\u00016a\u0005\u001d!\u0015\r^1tKR\u0004\"A\t7\u0005\u00135$\u0017\u0011!A\u0001\u0006\u0003)#aA0%c\u00051\"/Y<3aJ|'-\u00192jY&$\u00180\u00138QY\u0006\u001cW\r\u0006\u0002qmB\u0011\u0011\u000f^\u0007\u0002e*\u00111OE\u0001\u0007Y&t\u0017\r\\4\n\u0005U\u0014(A\u0002,fGR|'\u000fC\u0003x\u000b\u0001\u0007\u0001/A\u0007sC^\u0004&/\u001a3jGRLwN\\\u0001\u0010e\u0006<(\u0007\u001d:pE\u0006\u0014\u0017\u000e\\5usR\u0011\u0001O\u001f\u0005\u0006o\u001a\u0001\r\u0001]\u0001\u000fe\u0006<(\u0007\u001d:fI&\u001cG/[8o)\tqU\u0010C\u0003x\u000f\u0001\u0007\u0001/\u0001\nqe\u0016$\u0017n\u0019;Qe>\u0014\u0017MY5mSRLHc\u00019\u0002\u0002!1\u00111\u0001\u0005A\u0002\u0005\n\u0001BZ3biV\u0014Xm]\u0001\u0017aJ|'-\u00192jY&$\u0018P\r9sK\u0012L7\r^5p]R\u0019a*!\u0003\t\r\u0005-\u0011\u00021\u0001q\u0003-\u0001(o\u001c2bE&d\u0017\u000e^=)\u0007\u0001\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002F\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\r\u0003'\u0011A\u0002R3wK2|\u0007/\u001a:Ba&\f\u0001\u0005\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017nY1uS>tWj\u001c3fYB\u0011adC\n\u0006\u0017\u0005\u0005\u0012q\u0005\t\u0004O\u0005\r\u0012bAA\u0013Q\t1\u0011I\\=SK\u001a\u00042aJA\u0015\u0013\r\tY\u0003\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003;\tqD\\8s[\u0006d\u0017N_3U_B\u0013xNY1cS2LG/[3t\u0013:\u0004F.Y2f)\u0011\t\u0019$!\u000f\u0011\u0007\u001d\n)$C\u0002\u00028!\u0012A!\u00168ji\"9\u00111H\u0007A\u0002\u0005u\u0012!\u0001<\u0011\u0007E\fy$C\u0002\u0002BI\u00141\u0002R3og\u00164Vm\u0019;pe\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\u0005\u0005\u0003\u0002J\u0005MSBAA&\u0015\u0011\ti%a\u0014\u0002\t1\fgn\u001a\u0006\u0003\u0003#\nAA[1wC&!\u0011QKA&\u0005\u0019y%M[3di\u0002")
public abstract class ProbabilisticClassificationModel<FeaturesType, M extends ProbabilisticClassificationModel<FeaturesType, M>>
extends ClassificationModel<FeaturesType, M>
implements ProbabilisticClassifierParams {
    private final DoubleArrayParam thresholds;
    private final Param<String> probabilityCol;

    public static void normalizeToProbabilitiesInPlace(DenseVector denseVector) {
        ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$ProbabilisticClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public double[] getThresholds() {
        return HasThresholds.getThresholds$(this);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public final DoubleArrayParam thresholds() {
        return this.thresholds;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThresholds$_setter_$thresholds_$eq(DoubleArrayParam x$1) {
        this.thresholds = x$1;
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    public M setProbabilityCol(String value) {
        return (M)((ProbabilisticClassificationModel)this.set(this.probabilityCol(), value));
    }

    public M setThresholds(double[] value) {
        Predef$.MODULE$.require(value.length == this.numClasses(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(115).append(this.getClass().getSimpleName()).append(".setThresholds() called with non-matching numClasses and thresholds.length.").append(" numClasses=").append(this.numClasses()).append(", but thresholds has length ").append(value.length).toString());
        return (M)((ProbabilisticClassificationModel)this.set(this.thresholds(), value));
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset outputData;
        block10: {
            this.transformSchema(dataset.schema(), true);
            if (this.isDefined(this.thresholds())) {
                Predef$.MODULE$.require(this.$(this.thresholds()).length == this.numClasses(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append(this.getClass().getSimpleName()).append(".transform() called with non-matching numClasses and thresholds.length.").append(" numClasses=").append(this.numClasses()).append(", but thresholds has length ").append(this.$(this.thresholds()).length).toString());
            }
            outputData = dataset;
            int numColsOutput = 0;
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1(ProbabilisticClassificationModel $outer) {
                    }
                }
                UserDefinedFunction predictRawUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictRaw(features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                outputData = outputData.withColumn(this.getRawPredictionCol(), predictRawUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.getFeaturesCol())})));
                ++numColsOutput;
            }
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
                Column column;
                if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    JavaUniverse $u2 = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)rawPrediction -> this.raw2probability((Vector)rawPrediction), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol()))}));
                } else {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    UserDefinedFunction probabilityUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictProbability(features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                    column = probabilityUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
                }
                Column probUDF = column;
                outputData = outputData.withColumn(this.$(this.probabilityCol()), probUDF);
                ++numColsOutput;
            }
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
                Column column;
                if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)rawPrediction -> BoxesRunTime.boxToDouble((double)this.raw2prediction(rawPrediction)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol()))}));
                } else if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)probability -> BoxesRunTime.boxToDouble((double)this.probability2prediction(probability)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.probabilityCol()))}));
                } else {
                    UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                    column = predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
                }
                Column predUDF = column;
                outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF);
                ++numColsOutput;
            }
            if (numColsOutput != false) break block10;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append(this.uid()).append(": ProbabilisticClassificationModel.transform() was called as NOOP").append(" since no output columns were set.").toString());
        }
        return outputData.toDF();
    }

    public abstract Vector raw2probabilityInPlace(Vector var1);

    public Vector raw2probability(Vector rawPrediction) {
        Vector probs = rawPrediction.copy();
        return this.raw2probabilityInPlace(probs);
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        return !this.isDefined(this.thresholds()) ? (double)rawPrediction.argmax() : this.probability2prediction(this.raw2probability(rawPrediction));
    }

    public Vector predictProbability(FeaturesType features) {
        Vector rawPreds = this.predictRaw(features);
        return this.raw2probabilityInPlace(rawPreds);
    }

    public double probability2prediction(Vector probability) {
        double d;
        if (!this.isDefined(this.thresholds())) {
            d = probability.argmax();
        } else {
            double[] thresholds = this.getThresholds();
            int argMax = 0;
            double max = Double.NEGATIVE_INFINITY;
            int probabilitySize = probability.size();
            for (int i = 0; i < probabilitySize; ++i) {
                double scaled = probability.apply(i) / thresholds[i];
                if (!(scaled > max)) continue;
                max = scaled;
                argMax = i;
            }
            d = argMax;
        }
        return d;
    }

    public ProbabilisticClassificationModel() {
        HasProbabilityCol.$init$(this);
        HasThresholds.$init$(this);
        ProbabilisticClassifierParams.$init$(this);
    }
}

