/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.CountMinSketchAgg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.sketch.CountMinSketch;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(col, eps, confidence, seed) - Returns a count-min sketch of a column with the given esp,\n      confidence and seed. The result is an array of bytes, which can be deserialized to a\n      `CountMinSketch` before usage. Count-min sketch is a probabilistic data structure used for\n      cardinality estimation using sub-linear space.\n  ")
@ScalaSignature(bytes="\u0006\u0001\tme\u0001B\u001b7\u0001\u0016C\u0001b\u0018\u0001\u0003\u0016\u0004%\t\u0001\u0019\u0005\tI\u0002\u0011\t\u0012)A\u0005C\"AQ\r\u0001BK\u0002\u0013\u0005\u0001\r\u0003\u0005g\u0001\tE\t\u0015!\u0003b\u0011!9\u0007A!f\u0001\n\u0003\u0001\u0007\u0002\u00035\u0001\u0005#\u0005\u000b\u0011B1\t\u0011%\u0004!Q3A\u0005\u0002\u0001D\u0001B\u001b\u0001\u0003\u0012\u0003\u0006I!\u0019\u0005\tW\u0002\u0011)\u001a!C!Y\"A\u0001\u000f\u0001B\tB\u0003%Q\u000e\u0003\u0005r\u0001\tU\r\u0011\"\u0011m\u0011!\u0011\bA!E!\u0002\u0013i\u0007\"B:\u0001\t\u0003!\b\"B:\u0001\t\u0003a\bBCA\u0002\u0001!\u0015\r\u0011\"\u0003\u0002\u0006!Q\u0011Q\u0002\u0001\t\u0006\u0004%I!!\u0002\t\u0013\u0005=\u0001\u0001#b\u0001\n\u0013a\u0007bBA\t\u0001\u0011\u0005\u00131\u0003\u0005\b\u0003C\u0001A\u0011IA\u0012\u0011\u001d\t)\u0003\u0001C!\u0003OAq!!\u000f\u0001\t\u0003\nY\u0004C\u0004\u0002B\u0001!\t%a\u0011\t\u000f\u00055\u0003\u0001\"\u0011\u0002P!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBA4\u0001\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003_\u0002A\u0011IA9\u0011\u001d\t9\b\u0001C!\u0003sBq!a(\u0001\t\u0003\n\t\u000bC\u0004\u0002*\u0002!\t%a+\t\u000f\u0005M\u0006\u0001\"\u0011\u00026\"9\u00111\u0019\u0001\u0005B\u0005\u0015\u0007bBAe\u0001\u0011\u0005\u00131\u001a\u0005\n\u0003;\u0004\u0011\u0011!C\u0001\u0003?D\u0011\"!<\u0001#\u0003%\t!a<\t\u0013\t\u0015\u0001!%A\u0005\u0002\u0005=\b\"\u0003B\u0004\u0001E\u0005I\u0011AAx\u0011%\u0011I\u0001AI\u0001\n\u0003\ty\u000fC\u0005\u0003\f\u0001\t\n\u0011\"\u0001\u0003\u000e!I!\u0011\u0003\u0001\u0012\u0002\u0013\u0005!Q\u0002\u0005\n\u0005'\u0001\u0011\u0011!C!\u0005+A\u0001B!\n\u0001\u0003\u0003%\t\u0001\u001c\u0005\n\u0005O\u0001\u0011\u0011!C\u0001\u0005SA\u0011Ba\f\u0001\u0003\u0003%\tE!\r\t\u0013\t}\u0002!!A\u0005\u0002\t\u0005\u0003\"\u0003B#\u0001\u0005\u0005I\u0011\tB$\u000f%\u0011IFNA\u0001\u0012\u0003\u0011YF\u0002\u00056m\u0005\u0005\t\u0012\u0001B/\u0011\u0019\u0019x\u0006\"\u0001\u0003l!I!QN\u0018\u0002\u0002\u0013\u0015#q\u000e\u0005\n\u0005cz\u0013\u0011!CA\u0005gB\u0011B!!0\u0003\u0003%\tIa!\t\u0013\tEu&!A\u0005\n\tM%!E\"pk:$X*\u001b8TW\u0016$8\r[!hO*\u0011q\u0007O\u0001\nC\u001e<'/Z4bi\u0016T!!\u000f\u001e\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003wq\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003{y\n1a]9m\u0015\ty\u0004)A\u0003ta\u0006\u00148N\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<7\u0001A\n\u0006\u0001\u0019\u0013f\u000b\u0018\t\u0004\u000f\"SU\"\u0001\u001c\n\u0005%3$\u0001\u0007+za\u0016$\u0017*\u001c9fe\u0006$\u0018N^3BO\u001e\u0014XmZ1uKB\u00111\nU\u0007\u0002\u0019*\u0011QJT\u0001\u0007g.,Go\u00195\u000b\u0005=s\u0014\u0001B;uS2L!!\u0015'\u0003\u001d\r{WO\u001c;NS:\u001c6.\u001a;dQB\u00111\u000bV\u0007\u0002q%\u0011Q\u000b\u000f\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA,[\u001b\u0005A&\"A-\u0002\u000bM\u001c\u0017\r\\1\n\u0005mC&a\u0002)s_\u0012,8\r\u001e\t\u0003/vK!A\u0018-\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003\u0005\u0004\"a\u00152\n\u0005\rD$AC#yaJ,7o]5p]\u000611\r[5mI\u0002\nQ\"\u001a9t\u000bb\u0004(/Z:tS>t\u0017AD3qg\u0016C\bO]3tg&|g\u000eI\u0001\u0015G>tg-\u001b3f]\u000e,W\t\u001f9sKN\u001c\u0018n\u001c8\u0002+\r|gNZ5eK:\u001cW-\u0012=qe\u0016\u001c8/[8oA\u0005q1/Z3e\u000bb\u0004(/Z:tS>t\u0017aD:fK\u0012,\u0005\u0010\u001d:fgNLwN\u001c\u0011\u0002-5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR,\u0012!\u001c\t\u0003/:L!a\u001c-\u0003\u0007%sG/A\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3uA\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fQ#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u0004=S:LGO\u0010\u000b\bkZ<\b0\u001f>|!\t9\u0005\u0001C\u0003`\u001b\u0001\u0007\u0011\rC\u0003f\u001b\u0001\u0007\u0011\rC\u0003h\u001b\u0001\u0007\u0011\rC\u0003j\u001b\u0001\u0007\u0011\rC\u0003l\u001b\u0001\u0007Q\u000eC\u0003r\u001b\u0001\u0007Q\u000e\u0006\u0004v{z|\u0018\u0011\u0001\u0005\u0006?:\u0001\r!\u0019\u0005\u0006K:\u0001\r!\u0019\u0005\u0006O:\u0001\r!\u0019\u0005\u0006S:\u0001\r!Y\u0001\u0004KB\u001cXCAA\u0004!\r9\u0016\u0011B\u0005\u0004\u0003\u0017A&A\u0002#pk\ndW-\u0001\u0006d_:4\u0017\u000eZ3oG\u0016\fAa]3fI\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011\u0011Q\u0003\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111\u0004\u001e\u0002\u0011\u0005t\u0017\r\\=tSNLA!a\b\u0002\u001a\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/A\fde\u0016\fG/Z!hOJ,w-\u0019;j_:\u0014UO\u001a4feR\t!*\u0001\u0004va\u0012\fG/\u001a\u000b\u0006\u0015\u0006%\u0012Q\u0006\u0005\u0007\u0003W!\u0002\u0019\u0001&\u0002\r\t,hMZ3s\u0011\u001d\ty\u0003\u0006a\u0001\u0003c\tQ!\u001b8qkR\u0004B!a\r\u000265\t!(C\u0002\u00028i\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006)Q.\u001a:hKR)!*!\u0010\u0002@!1\u00111F\u000bA\u0002)Ca!a\f\u0016\u0001\u0004Q\u0015\u0001B3wC2$B!!\u0012\u0002LA\u0019q+a\u0012\n\u0007\u0005%\u0003LA\u0002B]fDa!a\u000b\u0017\u0001\u0004Q\u0015!C:fe&\fG.\u001b>f)\u0011\t\t&!\u0018\u0011\u000b]\u000b\u0019&a\u0016\n\u0007\u0005U\u0003LA\u0003BeJ\f\u0017\u0010E\u0002X\u00033J1!a\u0017Y\u0005\u0011\u0011\u0015\u0010^3\t\r\u0005-r\u00031\u0001K\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007)\u000b\u0019\u0007C\u0004\u0002fa\u0001\r!!\u0015\u0002\u001bM$xN]1hK\u001a{'/\\1u\u0003u9\u0018\u000e\u001e5OK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$HcA;\u0002l!1\u0011QN\rA\u00025\f\u0011D\\3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006Yr/\u001b;i\u001d\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$2!^A:\u0011\u0019\t)H\u0007a\u0001[\u00069b.Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA>!\u0019\ti(!$\u0002\u0014:!\u0011qPAE\u001d\u0011\t\t)a\"\u000e\u0005\u0005\r%bAAC\t\u00061AH]8pizJ\u0011!W\u0005\u0004\u0003\u0017C\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\u000b\tJA\u0002TKFT1!a#Y!\u0011\t)*a'\u000e\u0005\u0005]%bAAMy\u0005)A/\u001f9fg&!\u0011QTAL\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f+\t\t\u0019\u000bE\u0002X\u0003KK1!a*Y\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003[\u0003B!!&\u00020&!\u0011\u0011WAL\u0005!!\u0015\r^1UsB,\u0017!\u00043fM\u0006,H\u000e\u001e*fgVdG/\u0006\u0002\u00028B)q+!/\u0002>&\u0019\u00111\u0018-\u0003\r=\u0003H/[8o!\r\u0019\u0016qX\u0005\u0004\u0003\u0003D$a\u0002'ji\u0016\u0014\u0018\r\\\u0001\tG\"LG\u000e\u001a:f]V\u0011\u0011q\u0019\t\u0006\u0003{\ni)Y\u0001\u000baJ,G\u000f^=OC6,WCAAg!\u0011\ty-a6\u000f\t\u0005E\u00171\u001b\t\u0004\u0003\u0003C\u0016bAAk1\u00061\u0001K]3eK\u001aLA!!7\u0002\\\n11\u000b\u001e:j]\u001eT1!!6Y\u0003\u0011\u0019w\u000e]=\u0015\u001bU\f\t/a9\u0002f\u0006\u001d\u0018\u0011^Av\u0011\u001dy\u0016\u0005%AA\u0002\u0005Dq!Z\u0011\u0011\u0002\u0003\u0007\u0011\rC\u0004hCA\u0005\t\u0019A1\t\u000f%\f\u0003\u0013!a\u0001C\"91.\tI\u0001\u0002\u0004i\u0007bB9\"!\u0003\u0005\r!\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tPK\u0002b\u0003g\\#!!>\u0011\t\u0005](\u0011A\u0007\u0003\u0003sTA!a?\u0002~\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u007fD\u0016AC1o]>$\u0018\r^5p]&!!1AA}\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t=!fA7\u0002t\u0006q1m\u001c9zI\u0011,g-Y;mi\u00122\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0018A!!\u0011\u0004B\u0012\u001b\t\u0011YB\u0003\u0003\u0003\u001e\t}\u0011\u0001\u00027b]\u001eT!A!\t\u0002\t)\fg/Y\u0005\u0005\u00033\u0014Y\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015#1\u0006\u0005\t\u0005[Q\u0013\u0011!a\u0001[\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\r\u0011\r\tU\"1HA#\u001b\t\u00119DC\u0002\u0003:a\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iDa\u000e\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003G\u0013\u0019\u0005C\u0005\u0003.1\n\t\u00111\u0001\u0002F\u00051Q-];bYN$B!a)\u0003J!I!QF\u0017\u0002\u0002\u0003\u0007\u0011Q\t\u0015\b\u0001\t5#1\u000bB+!\r\u0019&qJ\u0005\u0004\u0005#B$!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005/\n!\u0011\u0017\u0006!A\u0001\u0002sLR+O\u0007~C3m\u001c7-A\u0015\u00048\u000f\f\u0011d_:4\u0017\u000eZ3oG\u0016d\u0003e]3fI&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bA\r|WO\u001c;.[&t\u0007e]6fi\u000eD\u0007e\u001c4!C\u0002\u001aw\u000e\\;n]\u0002:\u0018\u000e\u001e5!i\",\u0007eZ5wK:\u0004Sm\u001d9-\u0015\u0001\u0002\u0003\u0005\t\u0011!G>tg-\u001b3f]\u000e,\u0007%\u00198eAM,W\r\u001a\u0018!)\",\u0007E]3tk2$\b%[:!C:\u0004\u0013M\u001d:bs\u0002zg\r\t2zi\u0016\u001cH\u0006I<iS\u000eD\u0007eY1oA\t,\u0007\u0005Z3tKJL\u0017\r\\5{K\u0012\u0004Co\u001c\u0011b\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u000e{WO\u001c;NS:\u001c6.\u001a;dQ\u0002\u0004#-\u001a4pe\u0016\u0004So]1hK:\u00023i\\;oi6j\u0017N\u001c\u0011tW\u0016$8\r\u001b\u0011jg\u0002\n\u0007\u0005\u001d:pE\u0006\u0014\u0017\u000e\\5ti&\u001c\u0007\u0005Z1uC\u0002\u001aHO];diV\u0014X\rI;tK\u0012\u0004cm\u001c:\u000bA\u0001\u0002\u0003\u0005\t\u0011dCJ$\u0017N\\1mSRL\b%Z:uS6\fG/[8oAU\u001c\u0018N\\4!gV\u0014W\u0006\\5oK\u0006\u0014\be\u001d9bG\u0016t#\u0002\t\u0011\u0002#\r{WO\u001c;NS:\u001c6.\u001a;dQ\u0006;w\r\u0005\u0002H_M!qFa\u0018]!-\u0011\tGa\u001abC\u0006\fW.\\;\u000e\u0005\t\r$b\u0001B31\u00069!/\u001e8uS6,\u0017\u0002\u0002B5\u0005G\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c87)\t\u0011Y&\u0001\u0005u_N#(/\u001b8h)\t\u00119\"A\u0003baBd\u0017\u0010F\u0007v\u0005k\u00129H!\u001f\u0003|\tu$q\u0010\u0005\u0006?J\u0002\r!\u0019\u0005\u0006KJ\u0002\r!\u0019\u0005\u0006OJ\u0002\r!\u0019\u0005\u0006SJ\u0002\r!\u0019\u0005\u0006WJ\u0002\r!\u001c\u0005\u0006cJ\u0002\r!\\\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)I!$\u0011\u000b]\u000bILa\"\u0011\u0013]\u0013I)Y1bC6l\u0017b\u0001BF1\n1A+\u001e9mKZB\u0001Ba$4\u0003\u0003\u0005\r!^\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!&\u0011\t\te!qS\u0005\u0005\u00053\u0013YB\u0001\u0004PE*,7\r\u001e")
public class CountMinSketchAgg
extends TypedImperativeAggregate<CountMinSketch>
implements ExpectsInputTypes,
Serializable {
    private double eps;
    private double confidence;
    private int seed;
    private final Expression child;
    private final Expression epsExpression;
    private final Expression confidenceExpression;
    private final Expression seedExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile byte bitmap$0;

    public static Option<Tuple6<Expression, Expression, Expression, Expression, Object, Object>> unapply(CountMinSketchAgg countMinSketchAgg) {
        return CountMinSketchAgg$.MODULE$.unapply(countMinSketchAgg);
    }

    public static Function1<Tuple6<Expression, Expression, Expression, Expression, Object, Object>, CountMinSketchAgg> tupled() {
        return CountMinSketchAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, CountMinSketchAgg>>>>>> curried() {
        return CountMinSketchAgg$.MODULE$.curried();
    }

    public Expression child() {
        return this.child;
    }

    public Expression epsExpression() {
        return this.epsExpression;
    }

    public Expression confidenceExpression() {
        return this.confidenceExpression;
    }

    public Expression seedExpression() {
        return this.seedExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private double eps$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.eps = BoxesRunTime.unboxToDouble((Object)this.epsExpression().eval(this.epsExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.eps;
    }

    private double eps() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.eps$lzycompute() : this.eps;
    }

    private double confidence$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.confidence = BoxesRunTime.unboxToDouble((Object)this.confidenceExpression().eval(this.confidenceExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.confidence;
    }

    private double confidence() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.confidence$lzycompute() : this.confidence;
    }

    private int seed$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.seed = BoxesRunTime.unboxToInt((Object)this.seedExpression().eval(this.seedExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.seed;
    }

    private int seed() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.seed$lzycompute() : this.seed;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.epsExpression().foldable() || !this.confidenceExpression().foldable() || !this.seedExpression().foldable() ? new TypeCheckResult.TypeCheckFailure("The eps, confidence or seed provided must be a literal or foldable") : (this.epsExpression().eval(this.epsExpression().eval$default$1()) == null || this.confidenceExpression().eval(this.confidenceExpression().eval$default$1()) == null || this.seedExpression().eval(this.seedExpression().eval$default$1()) == null ? new TypeCheckResult.TypeCheckFailure("The eps, confidence or seed provided should not be null") : (this.eps() <= 0.0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("Relative error must be positive (current value = ").append(this.eps()).append(")").toString()) : (this.confidence() <= 0.0 || this.confidence() >= 1.0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(61).append("Confidence must be within range (0.0, 1.0) (current value = ").append(this.confidence()).append(")").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$))));
    }

    @Override
    public CountMinSketch createAggregationBuffer() {
        return CountMinSketch.create((double)this.eps(), (double)this.confidence(), (int)this.seed());
    }

    @Override
    public CountMinSketch update(CountMinSketch buffer, InternalRow input) {
        block2: {
            Object value = this.child().eval(input);
            if (value == null) break block2;
            DataType dataType = this.child().dataType();
            if (StringType$.MODULE$.equals(dataType)) {
                buffer.addBinary(((UTF8String)value).getBytes());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                buffer.add(value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return buffer;
    }

    @Override
    public CountMinSketch merge(CountMinSketch buffer, CountMinSketch input) {
        buffer.mergeInPlace(input);
        return buffer;
    }

    @Override
    public Object eval(CountMinSketch buffer) {
        return this.serialize(buffer);
    }

    @Override
    public byte[] serialize(CountMinSketch buffer) {
        return buffer.toByteArray();
    }

    @Override
    public CountMinSketch deserialize(byte[] storageFormat) {
        return CountMinSketch.readFrom((byte[])storageFormat);
    }

    @Override
    public CountMinSketchAgg withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        int x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$5, x$1, x$6);
    }

    @Override
    public CountMinSketchAgg withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        int x$6 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$1);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegralType$.MODULE$, StringType$.MODULE$, BinaryType$.MODULE$})), DoubleType$.MODULE$, DoubleType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Option<Literal> defaultResult() {
        return Option$.MODULE$.apply((Object)Literal$.MODULE$.create(this.eval(this.createAggregationBuffer()), this.dataType()));
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child(), this.epsExpression(), this.confidenceExpression(), this.seedExpression()}));
    }

    @Override
    public String prettyName() {
        return "count_min_sketch";
    }

    public CountMinSketchAgg copy(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CountMinSketchAgg(child, epsExpression, confidenceExpression, seedExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.epsExpression();
    }

    public Expression copy$default$3() {
        return this.confidenceExpression();
    }

    public Expression copy$default$4() {
        return this.seedExpression();
    }

    public int copy$default$5() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$6() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CountMinSketchAgg";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.epsExpression();
                break;
            }
            case 2: {
                object = this.confidenceExpression();
                break;
            }
            case 3: {
                object = this.seedExpression();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CountMinSketchAgg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CountMinSketchAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        CountMinSketchAgg countMinSketchAgg = (CountMinSketchAgg)x$1;
        Expression expression = this.child();
        Expression expression2 = countMinSketchAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.epsExpression();
        Expression expression4 = countMinSketchAgg.epsExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.confidenceExpression();
        Expression expression6 = countMinSketchAgg.confidenceExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.seedExpression();
        Expression expression8 = countMinSketchAgg.seedExpression();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (this.mutableAggBufferOffset() != countMinSketchAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != countMinSketchAgg.inputAggBufferOffset()) return false;
        if (!countMinSketchAgg.canEqual(this)) return false;
        return true;
    }

    public CountMinSketchAgg(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.epsExpression = epsExpression;
        this.confidenceExpression = confidenceExpression;
        this.seedExpression = seedExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
    }

    public CountMinSketchAgg(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression) {
        this(child, epsExpression, confidenceExpression, seedExpression, 0, 0);
    }
}

