/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArraySort$;
import org.apache.spark.sql.catalyst.expressions.ArraySortLike;
import org.apache.spark.sql.catalyst.expressions.ArraySortLike$NullOrder$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array) - Sorts the input array in ascending order. The elements of the input array must\n      be orderable. Null elements will be placed at the end of the returned array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'));\n       [\"a\",\"b\",\"c\",\"d\",null]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u000e\u001d\u0001&B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005y!)\u0001\t\u0001C\u0001\u0003\")A\t\u0001C!\u000b\")A\n\u0001C!\u001b\")Q\f\u0001C!w!)a\f\u0001C!?\")1\u000f\u0001C!i\")1\u0010\u0001C!y\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\n\u0003o\u0001\u0011\u0011!C\u0001\u0003sA\u0011\"!\u0010\u0001#\u0003%\t!a\u0010\t\u0013\u0005U\u0003!!A\u0005B\u0005]\u0003\"CA4\u0001\u0005\u0005I\u0011AA5\u0011%\t\t\bAA\u0001\n\u0003\t\u0019\bC\u0005\u0002z\u0001\t\t\u0011\"\u0011\u0002|!I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00111\u0012\u0005\n\u0003+\u0003\u0011\u0011!C!\u0003/;\u0011\"!.\u001d\u0003\u0003E\t!a.\u0007\u0011ma\u0012\u0011!E\u0001\u0003sCa\u0001Q\u000b\u0005\u0002\u0005\u001d\u0007\"CAe+\u0005\u0005IQIAf\u0011%\ti-FA\u0001\n\u0003\u000by\rC\u0005\u0002TV\t\t\u0011\"!\u0002V\"I\u0011\u0011]\u000b\u0002\u0002\u0013%\u00111\u001d\u0002\n\u0003J\u0014\u0018-_*peRT!!\b\u0010\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003?\u0001\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003C\t\n1a]9m\u0015\t\u0019C%A\u0003ta\u0006\u00148N\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<7\u0001A\n\u0006\u0001)r\u0013g\u000e\t\u0003W1j\u0011\u0001H\u0005\u0003[q\u0011q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003W=J!\u0001\r\u000f\u0003\u001b\u0005\u0013(/Y=T_J$H*[6f!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\r\u001d\n\u0005e\u001a$\u0001D*fe&\fG.\u001b>bE2,\u0017!B2iS2$W#\u0001\u001f\u0011\u0005-j\u0014B\u0001 \u001d\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\t\u00115\t\u0005\u0002,\u0001!)!h\u0001a\u0001y\u0005AA-\u0019;b)f\u0004X-F\u0001G!\t9%*D\u0001I\u0015\tI\u0005%A\u0003usB,7/\u0003\u0002L\u0011\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u0014\t\u0004\u001f^SfB\u0001)V\u001d\t\tF+D\u0001S\u0015\t\u0019\u0006&\u0001\u0004=e>|GOP\u0005\u0002i%\u0011akM\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0016LA\u0002TKFT!AV\u001a\u0011\u0005\u001d[\u0016B\u0001/I\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-A\bbeJ\f\u00170\u0012=qe\u0016\u001c8/[8o\u0003%qW\u000f\u001c7Pe\u0012,'/F\u0001a!\t\t\u0007O\u0004\u0002c]:\u00111-\u001c\b\u0003I2t!!Z6\u000f\u0005\u0019TgBA4j\u001d\t\t\u0006.C\u0001(\u0013\t)c%\u0003\u0002$I%\u0011\u0011EI\u0005\u0003?\u0001J!!\b\u0010\n\u0005=d\u0012!D!se\u0006L8k\u001c:u\u0019&\\W-\u0003\u0002re\nIa*\u001e7m\u001fJ$WM\u001d\u0006\u0003_r\t1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012!\u001e\t\u0003mfl\u0011a\u001e\u0006\u0003qz\t\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003u^\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004{\u0006\u0005\u0001C\u0001\u001a\u007f\u0013\ty8GA\u0002B]fDa!a\u0001\n\u0001\u0004i\u0018!B1se\u0006L\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\tI!!\u0006\u0002 A!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010q\tqaY8eK\u001e,g.\u0003\u0003\u0002\u0014\u00055!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005]!\u00021\u0001\u0002\u001a\u0005\u00191\r\u001e=\u0011\t\u0005-\u00111D\u0005\u0005\u0003;\tiA\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005\u0005\"\u00021\u0001\u0002\n\u0005\u0011QM^\u0001\u000baJ,G\u000f^=OC6,WCAA\u0014!\u0011\tI#!\r\u000f\t\u0005-\u0012Q\u0006\t\u0003#NJ1!a\f4\u0003\u0019\u0001&/\u001a3fM&!\u00111GA\u001b\u0005\u0019\u0019FO]5oO*\u0019\u0011qF\u001a\u0002\t\r|\u0007/\u001f\u000b\u0004\u0005\u0006m\u0002b\u0002\u001e\r!\u0003\u0005\r\u0001P\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tEK\u0002=\u0003\u0007Z#!!\u0012\u0011\t\u0005\u001d\u0013\u0011K\u0007\u0003\u0003\u0013RA!a\u0013\u0002N\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001f\u001a\u0014AC1o]>$\u0018\r^5p]&!\u00111KA%\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005e\u0003\u0003BA.\u0003Kj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u0005Y\u0006twM\u0003\u0002\u0002d\u0005!!.\u0019<b\u0013\u0011\t\u0019$!\u0018\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005-\u0004c\u0001\u001a\u0002n%\u0019\u0011qN\u001a\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007u\f)\bC\u0005\u0002xA\t\t\u00111\u0001\u0002l\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!! \u0011\u000b\u0005}\u0014QQ?\u000e\u0005\u0005\u0005%bAABg\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0015\u0011\u0011\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u000e\u0006M\u0005c\u0001\u001a\u0002\u0010&\u0019\u0011\u0011S\u001a\u0003\u000f\t{w\u000e\\3b]\"A\u0011q\u000f\n\u0002\u0002\u0003\u0007Q0\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u001b\u000bI\n\u0003\u0005\u0002xM\t\t\u00111\u0001~Q=\u0001\u0011QTAR\u0003K\u000bI+a+\u00020\u0006E\u0006cA\u0016\u0002 &\u0019\u0011\u0011\u0015\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qU\u0001\u0002t)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015beJ\f\u00170\u000b\u0011.AM{'\u000f^:!i\",\u0007%\u001b8qkR\u0004\u0013M\u001d:bs\u0002Jg\u000eI1tG\u0016tG-\u001b8hA=\u0014H-\u001a:/AQCW\rI3mK6,g\u000e^:!_\u001a\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011beJ\f\u0017\u0010I7vgRT\u0001\u0005\t\u0011!A\u0001\u0012W\rI8sI\u0016\u0014\u0018M\u00197f]\u0001rU\u000f\u001c7!K2,W.\u001a8ug\u0002:\u0018\u000e\u001c7!E\u0016\u0004\u0003\u000f\\1dK\u0012\u0004\u0013\r\u001e\u0011uQ\u0016\u0004SM\u001c3!_\u001a\u0004C\u000f[3!e\u0016$XO\u001d8fI\u0002\n'O]1z])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ti+A4\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)O\t<C\u0006I\u0014eO1\u0002c.\u001e7mY\u0001:3m\n\u0017!O\u0005<\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7\n\n'\u0005\f\u0012cE1\u00123M\t\u0017#I\nbc.\u001e7m;*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u00024\u0006)!G\f\u001b/a\u0005I\u0011I\u001d:bsN{'\u000f\u001e\t\u0003WU\u0019B!FA^oA1\u0011QXAby\tk!!a0\u000b\u0007\u0005\u00057'A\u0004sk:$\u0018.\\3\n\t\u0005\u0015\u0017q\u0018\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCAA\\\u0003!!xn\u0015;sS:<GCAA-\u0003\u0015\t\u0007\u000f\u001d7z)\r\u0011\u0015\u0011\u001b\u0005\u0006ua\u0001\r\u0001P\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9.!8\u0011\tI\nI\u000eP\u0005\u0004\u00037\u001c$AB(qi&|g\u000e\u0003\u0005\u0002`f\t\t\u00111\u0001C\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002fB!\u00111LAt\u0013\u0011\tI/!\u0018\u0003\r=\u0013'.Z2u\u0001")
public class ArraySort
extends UnaryExpression
implements ArraySortLike,
scala.Serializable {
    private final Expression child;
    private transient Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
    private transient Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
    private transient DataType elementType;
    private volatile transient byte bitmap$trans$0;

    public static Option<Expression> unapply(ArraySort arraySort) {
        return ArraySort$.MODULE$.unapply(arraySort);
    }

    public static <A> Function1<Expression, A> andThen(Function1<ArraySort, A> function1) {
        return ArraySort$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, ArraySort> compose(Function1<A, Expression> function1) {
        return ArraySort$.MODULE$.compose(function1);
    }

    @Override
    public boolean containsNull() {
        return ArraySortLike.containsNull$(this);
    }

    @Override
    public Object sortEval(Object array, boolean ascending) {
        return ArraySortLike.sortEval$(this, array, ascending);
    }

    @Override
    public String sortCodegen(CodegenContext ctx, ExprCode ev, String base, String order) {
        return ArraySortLike.sortCodegen$(this, ctx, ev, base, order);
    }

    private Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt = ArraySortLike.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
    }

    @Override
    public Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
    }

    private Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt = ArraySortLike.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
    }

    @Override
    public Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
    }

    private DataType elementType$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = ArraySortLike.elementType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType$[]{ArrayType$.MODULE$}));
    }

    @Override
    public Expression arrayExpression() {
        return this.child();
    }

    @Override
    public int nullOrder() {
        return ArraySortLike$NullOrder$.MODULE$.Greatest();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        void var1_8;
        boolean bl = false;
        ArrayType arrayType = null;
        DataType dataType = this.child().dataType();
        if (dataType instanceof ArrayType) {
            bl = true;
            arrayType = (ArrayType)dataType;
            DataType dt = arrayType.elementType();
            if (RowOrdering$.MODULE$.isOrderable(dt)) {
                TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
                return var1_8;
            }
        }
        if (bl) {
            DataType dt = arrayType.elementType();
            String dtSimple = dt.catalogString();
            TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(63).append(this.prettyName()).append(" does not support sorting array of type ").append(dtSimple).append(" which is not orderable").toString());
            return var1_8;
        }
        TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(27).append(this.prettyName()).append(" only supports array input.").toString());
        return var1_8;
    }

    @Override
    public Object nullSafeEval(Object array) {
        return this.sortEval(array, true);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> this.sortCodegen(ctx, ev, (String)c, "true"));
    }

    @Override
    public String prettyName() {
        return "array_sort";
    }

    public ArraySort copy(Expression child) {
        return new ArraySort(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ArraySort";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraySort;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraySort)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraySort arraySort = (ArraySort)x$1;
        Expression expression = this.child();
        Expression expression2 = arraySort.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!arraySort.canEqual(this)) return false;
        return true;
    }

    public ArraySort(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        ArraySortLike.$init$(this);
    }
}

