/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import java.util.Arrays;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vector$class;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@SQLUserDefinedType(udt=VectorUDT.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0001\u0003\u00015\u0011Ab\u00159beN,g+Z2u_JT!a\u0001\u0003\u0002\r1Lg.\u00197h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0007-\u0016\u001cGo\u001c:\t\u0011e\u0001!Q1A\u0005Bi\tAa]5{KV\t1\u0004\u0005\u0002\u00109%\u0011Q\u0004\u0005\u0002\u0004\u0013:$\bf\u0001\r KA\u0011\u0001eI\u0007\u0002C)\u0011!EB\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\u0013\"\u0005\u0015\u0019\u0016N\\2fC\u00051\u0013!B\u0019/a9\u0002\u0004\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000bML'0\u001a\u0011)\u0007\u001dzR\u0005\u0003\u0005,\u0001\t\u0015\r\u0011\"\u0001-\u0003\u001dIg\u000eZ5dKN,\u0012!\f\t\u0004\u001f9Z\u0012BA\u0018\u0011\u0005\u0015\t%O]1zQ\rQs$\n\u0005\te\u0001\u0011\t\u0011)A\u0005[\u0005A\u0011N\u001c3jG\u0016\u001c\b\u0005K\u00022?\u0015B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tAN\u0001\u0007m\u0006dW/Z:\u0016\u0003]\u00022a\u0004\u00189!\ty\u0011(\u0003\u0002;!\t1Ai\\;cY\u0016D3\u0001N\u0010&\u0011!i\u0004A!A!\u0002\u00139\u0014a\u0002<bYV,7\u000f\t\u0015\u0004y})\u0003\"\u0002!\u0001\t\u0003\t\u0015A\u0002\u001fj]&$h\b\u0006\u0003C\u0007\u0016;\u0005CA\u000b\u0001\u0011\u0015Ir\b1\u0001\u001cQ\r\u0019u$\n\u0005\u0006W}\u0002\r!\f\u0015\u0004\u000b~)\u0003\"B\u001b@\u0001\u00049\u0004fA$ K!\u001aqhH\u0013\t\u000b-\u0003A\u0011\t'\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u0014\t\u0003\u001dFs!aD(\n\u0005A\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002S'\n11\u000b\u001e:j]\u001eT!\u0001\u0015\t\t\u000bU\u0003A\u0011\t\u001c\u0002\u000fQ|\u0017I\u001d:bs\"\u001aAkH\u0013\t\u000ba\u0003A\u0011I-\u0002\t\r|\u0007/_\u000b\u0002\u0005\"\u001aqkH.\"\u0003q\u000bQ!\r\u00182]ABaA\u0018\u0001\u0005B\u0019y\u0016\u0001C1t\u0005J,WM_3\u0016\u0003\u0001\u00042!Y39\u001b\u0005\u0011'BA\u0002d\u0015\u0005!\u0017A\u00022sK\u0016TX-\u0003\u0002\u0018E\")q\r\u0001C!Q\u0006)\u0011\r\u001d9msR\u0011\u0001(\u001b\u0005\u0006U\u001a\u0004\raG\u0001\u0002S\")A\u000e\u0001C![\u0006iam\u001c:fC\u000eD\u0017i\u0019;jm\u0016$\"A\\9\u0011\u0005=y\u0017B\u00019\u0011\u0005\u0011)f.\u001b;\t\u000bI\\\u0007\u0019A:\u0002\u0003\u0019\u0004Ra\u0004;\u001cq9L!!\u001e\t\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004fA6 o\u0006\n\u00010A\u00032]Yr\u0003\u0007C\u0003{\u0001\u0011\u000530\u0001\u0004fcV\fGn\u001d\u000b\u0003y~\u0004\"aD?\n\u0005y\u0004\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0003I\b\u0019AA\u0002\u0003\u0015yG\u000f[3s!\ry\u0011QA\u0005\u0004\u0003\u000f\u0001\"aA!os\"9\u00111\u0002\u0001\u0005B\u00055\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003mAa!!\u0005\u0001\t\u0003R\u0012A\u00038v[\u0006\u001bG/\u001b<fg\"*\u0011qB\u0010\u0002\u0016\u0005\u0012\u0011qC\u0001\u0006c9\"d\u0006\r\u0005\u0007\u00037\u0001A\u0011\t\u000e\u0002\u00179,XNT8ou\u0016\u0014xn\u001d\u0015\u0006\u00033y\u0012Q\u0003\u0005\t\u0003C\u0001A\u0011\t\u0002\u0002$\u0005\u0001Bo\\*qCJ\u001cXmV5uQNK'0\u001a\u000b\u0004\u0005\u0006\u0015\u0002bBA\u0014\u0003?\u0001\raG\u0001\u0004]:T\bBBA\u0016\u0001\u0011\u0005#$\u0001\u0004be\u001el\u0017\r\u001f\u0015\u0006\u0003Sy\u0012qF\u0011\u0003\u0003c\tQ!\r\u00186]AB\u0001\"!\u000e\u0001\t\u00031\u0011qG\u0001\u0006g2L7-\u001a\u000b\u0004\u0005\u0006e\u0002bBA\u001e\u0003g\u0001\r!L\u0001\u0010g\u0016dWm\u0019;fI&sG-[2fg\"9\u0011q\b\u0001\u0005B\u0005\u0005\u0013A\u0002;p\u0015N|g.F\u0001NQ\u0011\tidH<\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J\u0005!\u0011m]'M+\t\tY\u0005\u0005\u0003\u0002N\u0005USBAA(\u0015\r\u0019\u0011\u0011\u000b\u0006\u0004\u0003'2\u0011AA7m\u0013\r\t\u0011q\n\u0015\u0006\u0003\u000bz\u0012\u0011L\u0011\u0003\u00037\nQA\r\u00181]ABs\u0001AA0\u0003_\n\t\b\u0005\u0003\u0002b\u0005-TBAA2\u0015\u0011\t)'a\u001a\u0002\u000bQL\b/Z:\u000b\u0007\u0005%d!A\u0002tc2LA!!\u001c\u0002d\t\u00112+\u0015'Vg\u0016\u0014H)\u001a4j]\u0016$G+\u001f9f\u0003\r)H\r^\u0012\u0003\u0003g\u00022!FA;\u0013\r\t9H\u0001\u0002\n-\u0016\u001cGo\u001c:V\tRC3\u0001A\u0010&\u000f\u001d\tiH\u0001E\u0001\u0003\u007f\nAb\u00159beN,g+Z2u_J\u00042!FAA\r\u0019\t!\u0001#\u0001\u0002\u0004N)\u0011\u0011\u0011\b\u0002\u0006B\u0019q\"a\"\n\u0007\u0005%\u0005C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004A\u0003\u0003#\t!!$\u0015\u0005\u0005}\u0004\u0002CAI\u0003\u0003#\t!a%\u0002\u000fUt\u0017\r\u001d9msR!\u0011QSAQ!\u0015y\u0011qSAN\u0013\r\tI\n\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r=\tijG\u00178\u0013\r\ty\n\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u000f\u0005\r\u0016q\u0012a\u0001\u0005\u0006\u00111O\u001e\u0015\u0006\u0003\u001f{\u0012qU\u0011\u0003\u0003S\u000bQ!\r\u00184]AB\u0001\"!,\u0002\u0002\u0012\u0005\u0011qV\u0001\u0007MJ|W.\u0014'\u0015\u0007\t\u000b\t\f\u0003\u0005\u00024\u0006-\u0006\u0019AA&\u0003\u00051\b&BAV?\u0005e\u0003BCA]\u0003\u0003\u000b\t\u0011\"\u0003\u0002<\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\f\u0005\u0003\u0002@\u0006%WBAAa\u0015\u0011\t\u0019-!2\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000f\fAA[1wC&!\u00111ZAa\u0005\u0019y%M[3di\"*\u0011\u0011Q\u0010\u0002(\"*\u00111P\u0010\u0002(\u0002")
public class SparseVector
implements Vector {
    private final int size;
    private final int[] indices;
    private final double[] values;

    public static SparseVector fromML(org.apache.spark.ml.linalg.SparseVector sparseVector) {
        return SparseVector$.MODULE$.fromML(sparseVector);
    }

    public static Option<Tuple3<Object, int[], double[]>> unapply(SparseVector sparseVector) {
        return SparseVector$.MODULE$.unapply(sparseVector);
    }

    @Override
    public SparseVector toSparse() {
        return Vector$class.toSparse(this);
    }

    @Override
    public DenseVector toDense() {
        return Vector$class.toDense(this);
    }

    @Override
    public Vector compressed() {
        return Vector$class.compressed(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ",", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.size()), Predef$.MODULE$.intArrayOps(this.indices()).mkString("[", ",", "]"), Predef$.MODULE$.doubleArrayOps(this.values()).mkString("[", ",", "]")}));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArray() {
        void var1_1;
        double[] data = new double[this.size()];
        int nnz = this.indices().length;
        for (int i = 0; i < nnz; ++i) {
            data[this.indices()[i]] = this.values()[i];
        }
        return var1_1;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this.size(), (int[])this.indices().clone(), (double[])this.values().clone());
    }

    @Override
    public breeze.linalg.Vector<Object> asBreeze() {
        return new SparseVector.mcD.sp(this.indices(), this.values(), this.size(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    @Override
    public double apply(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", " out of bounds [0, ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)this.size())})));
        }
        int j = Arrays.binarySearch(this.indices(), i);
        return j < 0 ? 0.0 : this.values()[j];
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        int localValuesSize = this.values().length;
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        for (int i = 0; i < localValuesSize; ++i) {
            f.apply$mcVID$sp(localIndices[i], localValues[i]);
        }
    }

    @Override
    public boolean equals(Object other) {
        return Vector$class.equals(this, other);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int k = 0; k < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++k) {
            double v = this.values()[k];
            if (v == 0.0) continue;
            int i = this.indices()[k];
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(v);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = IntRef.create((int)0);
        Predef$.MODULE$.doubleArrayOps(this.values()).foreach((Function1)new Serializable(this, nnz){
            public static final long serialVersionUID = 0L;
            private final IntRef nnz$3;

            public final void apply(double v) {
                this.apply$mcVD$sp(v);
            }

            public void apply$mcVD$sp(double v) {
                if (v != 0.0) {
                    ++this.nnz$3.elem;
                }
            }
            {
                this.nnz$3 = nnz$3;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparseWithSize(int nnz) {
        SparseVector sparseVector;
        if (nnz == this.numActives()) {
            sparseVector = this;
        } else {
            int[] ii = new int[nnz];
            double[] vv = new double[nnz];
            IntRef k = IntRef.create((int)0);
            this.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, ii, vv, k){
                public static final long serialVersionUID = 0L;
                private final int[] ii$2;
                private final double[] vv$2;
                private final IntRef k$2;

                public final void apply(int i, double v) {
                    this.apply$mcVID$sp(i, v);
                }

                public void apply$mcVID$sp(int i, double v) {
                    if (v != 0.0) {
                        this.ii$2[this.k$2.elem] = i;
                        this.vv$2[this.k$2.elem] = v;
                        ++this.k$2.elem;
                    }
                }
                {
                    this.ii$2 = ii$2;
                    this.vv$2 = vv$2;
                    this.k$2 = k$2;
                }
            });
            sparseVector = new SparseVector(this.size(), ii, vv);
        }
        return sparseVector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int argmax() {
        int n;
        if (this.size() == 0) {
            n = -1;
        } else if (this.numActives() == 0) {
            n = 0;
        } else {
            void var1_1;
            int maxIdx = this.indices()[0];
            double maxValue = this.values()[0];
            int maxJ = 0;
            int na = this.numActives();
            for (int j = 1; j < na; ++j) {
                double v = this.values()[j];
                if (!(v > maxValue)) continue;
                maxValue = v;
                maxIdx = this.indices()[j];
                maxJ = j;
            }
            if (maxValue <= 0.0 && na < this.size()) {
                if (maxValue == 0.0) {
                    if (maxJ < maxIdx) {
                        int k;
                        for (k = 0; k < maxJ && this.indices()[k] == k; ++k) {
                        }
                        maxIdx = k;
                    }
                } else {
                    int k;
                    for (k = 0; k < na && this.indices()[k] == k; ++k) {
                    }
                    maxIdx = k;
                }
            }
            n = var1_1;
        }
        return n;
    }

    public SparseVector slice(int[] selectedIndices) {
        IntRef currentIdx = IntRef.create((int)0);
        Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(selectedIndices).flatMap((Function1)new Serializable(this, currentIdx){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseVector $outer;
            private final IntRef currentIdx$1;

            /*
             * WARNING - void declaration
             */
            public final Iterator<Tuple2<Object, Object>> apply(int origIdx) {
                void var3_3;
                int iIdx = Arrays.binarySearch(this.$outer.indices(), origIdx);
                Iterator i_v = iIdx >= 0 ? package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(this.currentIdx$1.elem, this.$outer.values()[iIdx])})) : package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                ++this.currentIdx$1.elem;
                return var3_3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentIdx$1 = currentIdx$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
        if (tuple2 != null) {
            Tuple2 tuple22;
            int[] sliceInds = (int[])tuple2._1();
            double[] sliceVals = (double[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)sliceInds, (Object)sliceVals);
            int[] sliceInds2 = (int[])tuple23._1();
            double[] sliceVals2 = (double[])tuple23._2();
            return new SparseVector(selectedIndices.length, (int[])Predef$.MODULE$.intArrayOps(sliceInds2).toArray(ClassTag$.MODULE$.Int()), (double[])Predef$.MODULE$.doubleArrayOps(sliceVals2).toArray(ClassTag$.MODULE$.Double()));
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public String toJson() {
        JsonAST.JObject jValue;
        JsonAST.JObject x$8 = jValue = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)BoxesRunTime.boxToInteger((int)0)), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)BoxesRunTime.boxToInteger((int)this.size())), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"indices"), (Object)Predef$.MODULE$.intArrayOps(this.indices()).toSeq()), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JArray apply(Traversable<Object> s) {
                return JsonDSL$.MODULE$.seq2jvalue(s, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(int x) {
                        return JsonDSL$.MODULE$.int2jvalue(x);
                    }
                });
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)Predef$.MODULE$.doubleArrayOps(this.values()).toSeq()), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JArray apply(Traversable<Object> s) {
                return JsonDSL$.MODULE$.seq2jvalue(s, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(double x) {
                        return JsonDSL$.MODULE$.double2jvalue(x);
                    }
                });
            }
        }));
        Formats x$9 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$8);
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$8, x$9));
    }

    public org.apache.spark.ml.linalg.SparseVector asML() {
        return new org.apache.spark.ml.linalg.SparseVector(this.size(), this.indices(), this.values());
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this.size = size;
        this.indices = indices;
        this.values = values;
        Vector$class.$init$(this);
        Predef$.MODULE$.require(size >= 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The size of the requested sparse vector must be no less than 0.";
            }
        });
        Predef$.MODULE$.require(indices.length == values.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseVector $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Sparse vectors require that the dimension of the").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" indices match the dimension of the values. You provided ", " indices and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.indices().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " values."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.values().length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(indices.length <= size, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseVector $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You provided ", " indices and values, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.indices().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which exceeds the specified vector size ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.size())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

