/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.IsotonicRegressionWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.regression.IsotonicRegression;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReadable$class;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class IsotonicRegressionWrapper$
implements MLReadable<IsotonicRegressionWrapper> {
    public static final IsotonicRegressionWrapper$ MODULE$;

    static {
        new IsotonicRegressionWrapper$();
    }

    public IsotonicRegressionWrapper fit(Dataset<Row> data, String formula, boolean isotonic, int featureIndex, String weightCol) {
        RFormula rFormula = new RFormula().setFormula(formula).setFeaturesCol("features");
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        StructType schema = ((RFormulaModel)rFormulaModel).transform(data).schema();
        Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(((RFormulaModel)rFormulaModel).getFeaturesCol())).attributes().get();
        String[] features = (String[])Predef$.MODULE$.refArrayOps((Object[])featureAttrs).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Attribute x$1) {
                return (String)x$1.name().get();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])features).size() == 1);
        IsotonicRegression isotonicRegression = new IsotonicRegression().setIsotonic(isotonic).setFeatureIndex(featureIndex).setFeaturesCol(rFormula.getFeaturesCol());
        Object object = weightCol == null ? BoxedUnit.UNIT : isotonicRegression.setWeightCol(weightCol);
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, isotonicRegression})).fit((Dataset)data);
        return new IsotonicRegressionWrapper((PipelineModel)pipeline, features);
    }

    @Override
    public MLReader<IsotonicRegressionWrapper> read() {
        return new IsotonicRegressionWrapper.IsotonicRegressionWrapperReader();
    }

    @Override
    public IsotonicRegressionWrapper load(String path) {
        return (IsotonicRegressionWrapper)MLReadable$class.load(this, path);
    }

    private IsotonicRegressionWrapper$() {
        MODULE$ = this;
        MLReadable$class.$init$(this);
    }
}

