/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class ColumnVectorUtils {
    public static void populate(WritableColumnVector col, InternalRow row, int fieldIdx) {
        int capacity = col.capacity;
        DataType t = col.dataType();
        if (row.isNullAt(fieldIdx)) {
            col.putNulls(0, capacity);
        } else if (t == DataTypes.BooleanType) {
            col.putBooleans(0, capacity, row.getBoolean(fieldIdx));
        } else if (t == DataTypes.BinaryType) {
            col.putByteArray(0, row.getBinary(fieldIdx));
        } else if (t == DataTypes.ByteType) {
            col.putBytes(0, capacity, row.getByte(fieldIdx));
        } else if (t == DataTypes.ShortType) {
            col.putShorts(0, capacity, row.getShort(fieldIdx));
        } else if (t == DataTypes.IntegerType) {
            col.putInts(0, capacity, row.getInt(fieldIdx));
        } else if (t == DataTypes.LongType) {
            col.putLongs(0, capacity, row.getLong(fieldIdx));
        } else if (t == DataTypes.FloatType) {
            col.putFloats(0, capacity, row.getFloat(fieldIdx));
        } else if (t == DataTypes.DoubleType) {
            col.putDoubles(0, capacity, row.getDouble(fieldIdx));
        } else if (t == DataTypes.StringType) {
            UTF8String v = row.getUTF8String(fieldIdx);
            byte[] bytes = v.getBytes();
            for (int i = 0; i < capacity; ++i) {
                col.putByteArray(i, bytes);
            }
        } else if (t instanceof DecimalType) {
            DecimalType dt = (DecimalType)t;
            Decimal d = row.getDecimal(fieldIdx, dt.precision(), dt.scale());
            if (dt.precision() <= Decimal.MAX_INT_DIGITS()) {
                col.putInts(0, capacity, (int)d.toUnscaledLong());
            } else if (dt.precision() <= Decimal.MAX_LONG_DIGITS()) {
                col.putLongs(0, capacity, d.toUnscaledLong());
            } else {
                BigInteger integer = d.toJavaBigDecimal().unscaledValue();
                byte[] bytes = integer.toByteArray();
                for (int i = 0; i < capacity; ++i) {
                    col.putByteArray(i, bytes, 0, bytes.length);
                }
            }
        } else if (t instanceof CalendarIntervalType) {
            CalendarInterval c = (CalendarInterval)row.get(fieldIdx, t);
            col.getChild(0).putInts(0, capacity, c.months);
            col.getChild(1).putLongs(0, capacity, c.microseconds);
        } else if (t instanceof DateType) {
            col.putInts(0, capacity, row.getInt(fieldIdx));
        } else if (t instanceof TimestampType) {
            col.putLongs(0, capacity, row.getLong(fieldIdx));
        } else {
            throw new RuntimeException(String.format("DataType %s is not supported in column vectorized reader.", t.sql()));
        }
    }

    public static int[] toJavaIntArray(ColumnarArray array2) {
        for (int i = 0; i < array2.numElements(); ++i) {
            if (!array2.isNullAt(i)) continue;
            throw new RuntimeException("Cannot handle NULL values.");
        }
        return array2.toIntArray();
    }

    public static Map<Integer, Integer> toJavaIntMap(ColumnarMap map2) {
        int[] keys2 = ColumnVectorUtils.toJavaIntArray(map2.keyArray());
        int[] values2 = ColumnVectorUtils.toJavaIntArray(map2.valueArray());
        assert (keys2.length == values2.length);
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (int i = 0; i < keys2.length; ++i) {
            result.put(keys2[i], values2[i]);
        }
        return result;
    }

    private static void appendValue(WritableColumnVector dst, DataType t, Object o) {
        if (o == null) {
            if (t instanceof CalendarIntervalType) {
                dst.appendStruct(true);
            } else {
                dst.appendNull();
            }
        } else if (t == DataTypes.BooleanType) {
            dst.appendBoolean((Boolean)o);
        } else if (t == DataTypes.ByteType) {
            dst.appendByte((Byte)o);
        } else if (t == DataTypes.ShortType) {
            dst.appendShort((Short)o);
        } else if (t == DataTypes.IntegerType) {
            dst.appendInt((Integer)o);
        } else if (t == DataTypes.LongType) {
            dst.appendLong((Long)o);
        } else if (t == DataTypes.FloatType) {
            dst.appendFloat(((Float)o).floatValue());
        } else if (t == DataTypes.DoubleType) {
            dst.appendDouble((Double)o);
        } else if (t == DataTypes.StringType) {
            byte[] b = ((String)o).getBytes(StandardCharsets.UTF_8);
            dst.appendByteArray(b, 0, b.length);
        } else if (t instanceof DecimalType) {
            DecimalType dt = (DecimalType)t;
            Decimal d = Decimal.apply((BigDecimal)((BigDecimal)o), (int)dt.precision(), (int)dt.scale());
            if (dt.precision() <= Decimal.MAX_INT_DIGITS()) {
                dst.appendInt((int)d.toUnscaledLong());
            } else if (dt.precision() <= Decimal.MAX_LONG_DIGITS()) {
                dst.appendLong(d.toUnscaledLong());
            } else {
                BigInteger integer = d.toJavaBigDecimal().unscaledValue();
                byte[] bytes = integer.toByteArray();
                dst.appendByteArray(bytes, 0, bytes.length);
            }
        } else if (t instanceof CalendarIntervalType) {
            CalendarInterval c = (CalendarInterval)o;
            dst.appendStruct(false);
            dst.getChild(0).appendInt(c.months);
            dst.getChild(1).appendLong(c.microseconds);
        } else if (t instanceof DateType) {
            dst.appendInt(DateTimeUtils.fromJavaDate((Date)((Date)o)));
        } else {
            throw new UnsupportedOperationException("Type " + t);
        }
    }

    private static void appendValue(WritableColumnVector dst, DataType t, Row src, int fieldIdx) {
        if (t instanceof ArrayType) {
            ArrayType at = (ArrayType)t;
            if (src.isNullAt(fieldIdx)) {
                dst.appendNull();
            } else {
                List values2 = src.getList(fieldIdx);
                dst.appendArray(values2.size());
                for (Object o : values2) {
                    ColumnVectorUtils.appendValue(dst.arrayData(), at.elementType(), o);
                }
            }
        } else if (t instanceof StructType) {
            StructType st = (StructType)t;
            if (src.isNullAt(fieldIdx)) {
                dst.appendStruct(true);
            } else {
                dst.appendStruct(false);
                Row c = src.getStruct(fieldIdx);
                for (int i = 0; i < st.fields().length; ++i) {
                    ColumnVectorUtils.appendValue(dst.getChild(i), st.fields()[i].dataType(), c, i);
                }
            }
        } else {
            ColumnVectorUtils.appendValue(dst, t, src.get(fieldIdx));
        }
    }

    public static ColumnarBatch toBatch(StructType schema2, MemoryMode memMode, Iterator<Row> row) {
        int capacity = 4096;
        WritableColumnVector[] columnVectors = memMode == MemoryMode.OFF_HEAP ? OffHeapColumnVector.allocateColumns(capacity, schema2) : OnHeapColumnVector.allocateColumns(capacity, schema2);
        int n = 0;
        while (row.hasNext()) {
            Row r2 = row.next();
            for (int i = 0; i < schema2.fields().length; ++i) {
                ColumnVectorUtils.appendValue(columnVectors[i], schema2.fields()[i].dataType(), r2, i);
            }
            ++n;
        }
        ColumnarBatch batch = new ColumnarBatch(columnVectors);
        batch.setNumRows(n);
        return batch;
    }
}

