/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart.run;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.maven.slingstart.run.ControlListener;
import org.apache.sling.maven.slingstart.run.PortHelper;

public class ProcessDescription {
    private final String id;
    private final File directory;
    private final ControlListener listener;
    private volatile Process process;

    public ProcessDescription(String id, File directory) throws MojoExecutionException {
        this.id = id;
        this.directory = directory;
        this.listener = new ControlListener(PortHelper.getNextAvailablePort());
    }

    public String getId() {
        return this.id;
    }

    public File getDirectory() {
        return this.directory;
    }

    public ControlListener getControlListener() {
        return this.listener;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public void installShutdownHook() {
        final ProcessDescription cfg = this;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (cfg.getProcess() != null) {
                    System.out.println("Terminating launchpad " + cfg.getId());
                    cfg.getProcess().destroy();
                    cfg.setProcess(null);
                }
            }
        });
    }

    public String toString() {
        return "RunningProcessDescription [id=" + this.id + ", directory=" + this.directory + ", process=" + this.process + "]";
    }
}

