/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;
import org.apache.sling.feature.maven.mojos.reports.ContentsReporter;
import org.apache.sling.feature.maven.mojos.reports.DuplicatesReporter;
import org.apache.sling.feature.maven.mojos.reports.ExportPackagesReporter;
import org.apache.sling.feature.maven.mojos.reports.ImportPackagesReporter;
import org.apache.sling.feature.maven.mojos.reports.ReportContext;
import org.apache.sling.feature.maven.mojos.reports.Reporter;
import org.apache.sling.feature.maven.mojos.reports.ScriptsImportPackagesReporter;
import org.apache.sling.feature.maven.mojos.selection.IncludeExcludeMatcher;
import org.apache.sling.feature.scanner.Scanner;

@Mojo(requiresProject=false, name="info", threadSafe=true)
public class InfoMojo
extends AbstractIncludingFeatureMojo {
    @Parameter
    private FeatureSelectionConfig infoFeatures;
    @Parameter(property="infoFeatureFiles")
    private String infoFeatureFiles;
    @Parameter(property="reports", defaultValue="exported-packages")
    private String reports;
    @Parameter(property="outputFormat", defaultValue="file")
    private String outputFormat;
    @Parameter(property="outputDirectory")
    private File outputDirectory;
    @Parameter(property="includes")
    private String artifactIncludesList;
    @Parameter(property="excludes")
    private String artifactExcludesList;
    @Deprecated
    @Parameter(property="featureFile")
    private File featureFile;
    @Deprecated
    @Parameter(property="outputExportedPackages")
    private String outputExportedPackages;
    @Parameter(readonly=true, defaultValue="${project.build.directory}/feature-reports")
    private File buildDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean isStandalone = "standalone-pom".equals(this.project.getArtifactId());
        if (this.outputExportedPackages != null) {
            this.getLog().warn((CharSequence)"Deprecated configuration 'outputExportedPackages' is used. Please use 'reports' instead.");
        }
        if (this.featureFile != null) {
            this.getLog().warn((CharSequence)"Deprecated configuration 'featureFile' is used. Change to 'infoFeatureFiles'");
            this.infoFeatureFiles = this.infoFeatureFiles == null ? this.featureFile.getAbsolutePath() : this.infoFeatureFiles.concat(",").concat(this.featureFile.getAbsolutePath());
        }
        if (isStandalone && this.infoFeatureFiles == null) {
            throw new MojoExecutionException("Required configuration for standalone execution is missing. Please specify 'infoFeatureFiles'.");
        }
        OutputFormat format = OutputFormat.FILE;
        try {
            format = OutputFormat.valueOf(this.outputFormat.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new MojoExecutionException("Invalid value for 'outputFormat', allowed values are file, log or singlefile, configured : ".concat(this.outputFormat));
        }
        List<Reporter> reporters = this.getReporters(this.reports);
        if (reporters.isEmpty()) {
            this.getLog().warn((CharSequence)"No reporters specified.");
            return;
        }
        final List<Feature> selection = this.selectFeatures(this.infoFeatureFiles);
        final ArtifactProvider am = this.setupArtifactProvider();
        final Scanner scanner = this.setupScanner(am);
        final IncludeExcludeMatcher matcher = this.artifactIncludesList != null && !this.artifactIncludesList.isEmpty() ? new IncludeExcludeMatcher(Stream.of(this.artifactIncludesList.split(",")).map(v -> v.trim()).collect(Collectors.toList()), this.artifactExcludesList == null ? null : Stream.of(this.artifactExcludesList.split(",")).map(v -> v.trim()).collect(Collectors.toList()), null, false) : null;
        final LinkedHashMap reportsFromSingleReporter = new LinkedHashMap();
        ReportContext ctx = new ReportContext(){

            @Override
            public Scanner getScanner() {
                return scanner;
            }

            @Override
            public ArtifactProvider getArtifactProvider() {
                return am;
            }

            @Override
            public List<Feature> getFeatures() {
                return selection;
            }

            @Override
            public void addReport(String key, List<String> output) {
                reportsFromSingleReporter.put(key, output);
            }

            @Override
            public boolean matches(ArtifactId id) {
                return matcher == null || matcher.matches(id) != null;
            }
        };
        HashMap allReports = new HashMap();
        for (Reporter reporter : reporters) {
            this.getLog().info((CharSequence)"Generating report ".concat(reporter.getName().concat("...")));
            reporter.generateReport(ctx);
            allReports.put(reporter.getName(), new HashMap(reportsFromSingleReporter));
            reportsFromSingleReporter.clear();
        }
        File directory = this.outputDirectory != null ? this.outputDirectory : (isStandalone ? Paths.get(".", new String[0]).toAbsolutePath().getParent().toFile() : this.buildDirectory);
        switch (format.ordinal()) {
            case 0: {
                directory.mkdirs();
                allReports.values().forEach(map -> map.forEach((key, value) -> {
                    try {
                        File out = new File(directory, (String)key);
                        this.getLog().info((CharSequence)("Writing " + out + "..."));
                        Files.write(out.toPath(), (Iterable<? extends CharSequence>)value, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to write file: " + e.getMessage(), e);
                    }
                }));
                break;
            }
            case 2: {
                directory.mkdirs();
                allReports.entrySet().forEach(entry -> {
                    ArrayList result = new ArrayList();
                    for (List value : ((Map)entry.getValue()).values()) {
                        result.addAll(value);
                    }
                    Collections.sort(result);
                    try {
                        File out = new File(directory, "report-" + (String)entry.getKey() + ".txt");
                        this.getLog().info((CharSequence)("Writing " + out + "..."));
                        Files.write(out.toPath(), result, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to write file: " + e.getMessage(), e);
                    }
                });
                break;
            }
            case 1: {
                allReports.values().forEach(map -> map.forEach((key, value) -> {
                    this.getLog().info((CharSequence)"");
                    this.getLog().info((CharSequence)"Report ".concat((String)key));
                    this.getLog().info((CharSequence)"================================================================");
                    value.stream().forEach(l -> this.getLog().info((CharSequence)l));
                    this.getLog().info((CharSequence)"");
                }));
            }
        }
    }

    private List<Reporter> getReporters(String reports) throws MojoExecutionException {
        if (reports == null) {
            throw new MojoExecutionException("No reports configured.");
        }
        ArrayList<Reporter> available = new ArrayList<Reporter>();
        available.add(new ExportPackagesReporter());
        available.add(new DuplicatesReporter());
        available.add(new ContentsReporter());
        available.add(new ImportPackagesReporter());
        available.add(new ScriptsImportPackagesReporter());
        ArrayList<Reporter> result = new ArrayList<Reporter>();
        block0: for (String r : reports.split(",")) {
            for (Reporter current : available) {
                if (!current.getName().equals(r.trim())) continue;
                result.add(current);
                continue block0;
            }
        }
        return result;
    }

    private List<Feature> selectFeatures(String infoFeatureFiles) throws MojoExecutionException {
        ArrayList<Feature> result = new ArrayList<Feature>();
        if (infoFeatureFiles != null) {
            for (String file : infoFeatureFiles.split(",")) {
                File f = new File(file.trim());
                result.add(this.readFeature(f));
            }
        } else {
            this.checkPreconditions();
            Map<String, Feature> features = this.infoFeatures == null ? this.selectAllFeatureFiles() : this.getSelectedFeatures(this.infoFeatures);
            for (Feature f : features.values()) {
                result.add(f);
            }
        }
        return result;
    }

    private ArtifactProvider setupArtifactProvider() {
        ArtifactProvider am = new ArtifactProvider(){

            public URL provide(ArtifactId id) {
                InfoMojo.this.getLog().info((CharSequence)("Searching " + id.toMvnId()));
                try {
                    return ProjectHelper.getOrResolveArtifact(InfoMojo.this.project, InfoMojo.this.mavenSession, InfoMojo.this.artifactHandlerManager, InfoMojo.this.repoSystem, id).getFile().toURI().toURL();
                }
                catch (MalformedURLException e) {
                    InfoMojo.this.getLog().debug((CharSequence)("Malformed url " + e.getMessage()), (Throwable)e);
                    return null;
                }
            }
        };
        return am;
    }

    private Scanner setupScanner(ArtifactProvider am) throws MojoExecutionException {
        try {
            return new Scanner(am);
        }
        catch (IOException e) {
            throw new MojoExecutionException("A fatal error occurred while setting up the Scanner, see error cause:", (Exception)e);
        }
    }

    private Feature readFeature(File file) throws MojoExecutionException {
        Feature feature;
        FileReader reader = new FileReader(file);
        try {
            Feature f;
            feature = f = FeatureJSONReader.read((Reader)reader, (String)file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Unable to read feature file " + ioe.getMessage(), (Exception)ioe);
            }
        }
        ((Reader)reader).close();
        return feature;
    }

    public static enum OutputFormat {
        FILE,
        LOG,
        SINGLEFILE;

    }
}

