/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.diff.DiffRequest;
import org.apache.sling.feature.diff.FeatureDiff;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.maven.mojos.AbstractIncludingFeatureMojo;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;

@Mojo(name="features-diff", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public final class FeaturesDiffMojo
extends AbstractIncludingFeatureMojo {
    @Parameter
    private FeatureSelectionConfig selection;
    @Parameter(defaultValue="${project.build.directory}/features-diff", readonly=true)
    private File mainOutputDir;
    @Parameter(defaultValue="(,${project.version})")
    protected String comparisonVersion;
    @Component
    protected ArtifactResolver resolver;
    @Component
    protected ArtifactFactory factory;
    @Component
    private ArtifactMetadataSource metadataSource;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Retrieving Feature files...");
        Collection<Feature> features = this.getSelectedFeatures(this.selection).values();
        if (features.isEmpty()) {
            this.getLog().debug((CharSequence)"There are no assciated Feature files to current project, plugin execution will be interrupted");
            return;
        }
        if (!this.mainOutputDir.exists()) {
            this.mainOutputDir.mkdirs();
        }
        this.getLog().debug((CharSequence)"Starting Feature(s) analysis...");
        for (Feature feature : features) {
            this.onFeature(feature);
        }
    }

    private void onFeature(Feature current) throws MojoExecutionException, MojoFailureException {
        Feature previous = this.getPreviousFeature(current);
        if (previous == null) {
            this.getLog().info((CharSequence)("There is no previous verion available of " + current + " model"));
            return;
        }
        this.getLog().info((CharSequence)("Comparing current " + current + " to previous " + previous));
        Feature featureDiff = FeatureDiff.compareFeatures((DiffRequest)new DiffRequest().setPrevious(previous).setCurrent(current));
        File outputDiffFile = new File(this.mainOutputDir, featureDiff.getId().getClassifier().concat(".json"));
        this.getLog().info((CharSequence)("Rendering differences to file " + outputDiffFile));
        try (FileWriter writer = new FileWriter(outputDiffFile);){
            FeatureJSONWriter.write((Writer)writer, (Feature)featureDiff);
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred while serializing Feature diff to " + outputDiffFile, (Exception)e);
        }
        this.projectHelper.attachArtifact(this.project, "slingosgifeature", featureDiff.getId().getClassifier(), outputDiffFile);
    }

    private Feature getPreviousFeature(Feature current) throws MojoExecutionException, MojoFailureException {
        Feature feature;
        Artifact previousArtifact;
        VersionRange range;
        try {
            range = VersionRange.createFromVersionSpec((String)this.comparisonVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoFailureException("Invalid comparison version: " + e.getMessage());
        }
        try {
            previousArtifact = this.factory.createDependencyArtifact(current.getId().getGroupId(), current.getId().getArtifactId(), range, current.getId().getType(), current.getId().getClassifier(), "compile");
            if (!previousArtifact.getVersionRange().isSelectedVersionKnown(previousArtifact)) {
                this.getLog().debug((CharSequence)("Searching for versions in range: " + previousArtifact.getVersionRange()));
                List availableVersions = this.metadataSource.retrieveAvailableVersions(previousArtifact, this.mavenSession.getLocalRepository(), this.project.getRemoteArtifactRepositories());
                this.filterSnapshots(availableVersions);
                ArtifactVersion version = range.matchVersion(availableVersions);
                if (version != null) {
                    previousArtifact.selectVersion(version.toString());
                }
            }
        }
        catch (OverConstrainedVersionException ocve) {
            throw new MojoFailureException("Invalid comparison version: " + ocve.getMessage());
        }
        catch (ArtifactMetadataRetrievalException amre) {
            throw new MojoExecutionException("Error determining previous version: " + amre.getMessage(), (Exception)((Object)amre));
        }
        if (previousArtifact.getVersion() == null) {
            this.getLog().info((CharSequence)("Unable to find a previous version of the " + current + " Feature in the repository"));
            return null;
        }
        try {
            this.resolver.resolve(previousArtifact, this.project.getRemoteArtifactRepositories(), this.mavenSession.getLocalRepository());
        }
        catch (ArtifactResolutionException are) {
            this.getLog().warn((CharSequence)("Artifact " + previousArtifact + " cannot be resolved : " + are.getMessage()), (Throwable)are);
        }
        catch (ArtifactNotFoundException anfe) {
            this.getLog().warn((CharSequence)("Artifact " + previousArtifact + " does not exist on local/remote repositories"), (Throwable)anfe);
        }
        File featureFile = previousArtifact.getFile();
        if (featureFile == null || !featureFile.exists()) {
            return null;
        }
        FileReader reader = new FileReader(featureFile);
        try {
            feature = FeatureJSONReader.read((Reader)reader, (String)featureFile.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException("An error occurred while reading the " + featureFile + " Feature file:", (Exception)e);
            }
        }
        reader.close();
        return feature;
    }

    private void filterSnapshots(List<ArtifactVersion> versions) {
        Iterator<ArtifactVersion> versionIterator = versions.iterator();
        while (versionIterator.hasNext()) {
            ArtifactVersion version = versionIterator.next();
            if (version.getQualifier() == null || !version.getQualifier().endsWith("SNAPSHOT")) continue;
            versionIterator.remove();
        }
    }
}

