/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.apis;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.utils.manifest.Clause;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.maven.mojos.apis.ApisConfiguration;
import org.apache.sling.feature.maven.mojos.apis.ApisUtil;

public class ApisJarContext {
    private final ApisConfiguration config;
    private final Map<ArtifactId, String> javadocClasspath = new HashMap<ArtifactId, String>();
    private final Set<String> packagesWithoutJavaClasses = new HashSet<String>();
    private final Set<String> packagesWithoutSources = new HashSet<String>();
    private final File deflatedBinDir;
    private final File deflatedSourcesDir;
    private final File checkedOutSourcesDir;
    private File javadocDir;
    private final List<ArtifactInfo> infos = new ArrayList<ArtifactInfo>();
    private final Feature feature;
    private final Map<ArtifactId, Model> modelCache = new HashMap<ArtifactId, Model>();

    public ApisJarContext(File mainDir, Feature feature) throws MojoExecutionException {
        this.config = new ApisConfiguration(feature);
        this.feature = feature;
        this.deflatedBinDir = new File(mainDir, "deflated-bin");
        this.deflatedSourcesDir = new File(mainDir, "deflated-sources");
        this.checkedOutSourcesDir = new File(mainDir, "checkouts");
    }

    public ApisConfiguration getConfig() {
        return this.config;
    }

    public ArtifactId getFeatureId() {
        return this.feature.getId();
    }

    public Feature getFeature() {
        return this.feature;
    }

    public File getDeflatedBinDir() {
        return this.deflatedBinDir;
    }

    public File getDeflatedSourcesDir() {
        return this.deflatedSourcesDir;
    }

    public File getCheckedOutSourcesDir() {
        return this.checkedOutSourcesDir;
    }

    public void addJavadocClasspath(ArtifactId artifactId, String classpath) {
        this.javadocClasspath.put(artifactId, classpath);
    }

    public Map<ArtifactId, String> getJavadocClasspath() {
        return this.javadocClasspath;
    }

    public File getJavadocDir() {
        return this.javadocDir;
    }

    public void setJavadocDir(File javadocDir) {
        this.javadocDir = javadocDir;
    }

    public Set<String> getPackagesWithoutJavaClasses() {
        return this.packagesWithoutJavaClasses;
    }

    public Set<String> getPackagesWithoutSources() {
        return this.packagesWithoutSources;
    }

    public ArtifactInfo addArtifactInfo(Artifact artifact) {
        ArtifactInfo info = new ArtifactInfo(artifact);
        this.infos.add(info);
        return info;
    }

    public ArtifactInfo getArtifactInfo(ArtifactId artifactId) {
        for (ArtifactInfo i : this.infos) {
            if (!i.getArtifact().getId().equals((Object)artifactId)) continue;
            return i;
        }
        return null;
    }

    public List<ArtifactInfo> getArtifactInfos() {
        return this.infos;
    }

    public Map<ArtifactId, Model> getModelCache() {
        return this.modelCache;
    }

    public Collection<ArtifactInfo> getArtifactInfos(String regionName, boolean omitDependencyArtifacts) {
        TreeMap<ArtifactId, ArtifactInfo> result = new TreeMap<ArtifactId, ArtifactInfo>();
        for (ArtifactInfo info : this.infos) {
            Set<Clause> pcks = info.getUsedExportedPackages(regionName);
            if (pcks == null || pcks.isEmpty() || omitDependencyArtifacts && info.isUseAsDependencyPerRegion(regionName)) continue;
            result.put(info.getId(), info);
        }
        return result.values();
    }

    private boolean findDependencyArtifact(Log log, ArtifactId id) throws MojoExecutionException {
        boolean result = true;
        if (!this.getConfig().getDependencyRepositories().isEmpty()) {
            result = false;
            log.debug((CharSequence)"Trying to resolve ".concat(id.toMvnId()).concat(" from ").concat(this.getConfig().getDependencyRepositories().toString()));
            for (String server : this.getConfig().getDependencyRepositories()) {
                try {
                    URL url = new URL(server.concat(id.toMvnPath()));
                    try {
                        url.openConnection().getInputStream().close();
                        log.debug((CharSequence)"Found ".concat(id.toMvnId()).concat(" at ").concat(url.toString()));
                        result = true;
                        break;
                    }
                    catch (IOException e) {
                        log.debug((CharSequence)"Missed ".concat(id.toMvnId()).concat(" at ").concat(url.toString()).concat(" : ").concat(e.toString()));
                    }
                }
                catch (MalformedURLException mue) {
                    throw new MojoExecutionException("Unable to find dependency on ".concat(server), (Exception)mue);
                }
            }
        }
        return result;
    }

    public boolean findDependencyArtifact(Log log, ArtifactInfo info) throws MojoExecutionException {
        boolean result = true;
        for (ArtifactId id : info.getDependencyArtifacts()) {
            if (this.findDependencyArtifact(log, id)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static final class ArtifactInfo {
        private Artifact artifact;
        private File binDirectory;
        private File sourceDirectory;
        private Set<String> usedExportedPackages;
        private final Map<String, Set<Clause>> usedExportedPackagesRegion = new HashMap<String, Set<Clause>>();
        private final Map<String, String> useAsDependencyPerRegion = new HashMap<String, String>();
        private final Set<File> includedResources = new HashSet<File>();
        private final Set<String> nodeTypes = new HashSet<String>();
        private List<License> licenses;
        private final Set<String> sources = new HashSet<String>();

        public ArtifactInfo(Artifact artifact) {
            this.artifact = artifact;
        }

        public ArtifactId getId() {
            return this.artifact.getId();
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public File getBinDirectory() {
            return this.binDirectory;
        }

        public void setBinDirectory(File binDirectory) {
            this.binDirectory = binDirectory;
        }

        public File getSourceDirectory() {
            return this.sourceDirectory;
        }

        public void setSourceDirectory(File sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
        }

        public Set<String> getUsedExportedPackages() {
            return this.usedExportedPackages;
        }

        public void setUsedExportedPackages(Set<String> usedExportedPackages) {
            this.usedExportedPackages = usedExportedPackages;
        }

        public String[] getUsedExportedPackageIncludes() {
            HashSet<String> includes = new HashSet<String>();
            for (String pck : this.usedExportedPackages) {
                includes.add(pck.replace('.', '/').concat("/*"));
            }
            return includes.toArray(new String[includes.size()]);
        }

        public Set<Clause> getUsedExportedPackages(String regionName) {
            return this.usedExportedPackagesRegion.get(regionName);
        }

        public void setUsedExportedPackages(String regionName, Set<Clause> usedExportedPackages, String useAsDependency) {
            this.usedExportedPackagesRegion.put(regionName, usedExportedPackages);
            if (useAsDependency != null) {
                this.useAsDependencyPerRegion.put(regionName, useAsDependency);
            }
        }

        public String[] getUsedExportedPackageIncludes(String regionName) {
            Set<Clause> clauses = this.getUsedExportedPackages(regionName);
            HashSet<String> includes = new HashSet<String>();
            for (Clause clause : clauses) {
                includes.add(clause.getName().replace('.', '/').concat("/*"));
            }
            return includes.toArray(new String[includes.size()]);
        }

        public boolean isUseAsDependencyPerRegion(String regionName) {
            return this.useAsDependencyPerRegion.get(regionName) == null;
        }

        public String getNotUseAsDependencyPerRegionReason(String regionName) {
            return this.useAsDependencyPerRegion.get(regionName);
        }

        public Set<File> getIncludedResources() {
            return this.includedResources;
        }

        public Set<String> getNodeTypes() {
            return this.nodeTypes;
        }

        public List<License> getLicenses() {
            return this.licenses;
        }

        public void setLicenses(List<License> licenses) {
            this.licenses = licenses;
        }

        public List<ArtifactId> getDependencyArtifacts() throws MojoExecutionException {
            ArrayList<ArtifactId> dependencies = new ArrayList<ArtifactId>();
            List<ArtifactId> apiIds = ApisUtil.getApiIds(this.artifact);
            if (apiIds != null) {
                for (ArtifactId id : apiIds) {
                    dependencies.add(id);
                }
            } else {
                List<ArtifactId> sourceIds = ApisUtil.getSourceIds(this.artifact);
                if (sourceIds != null) {
                    for (ArtifactId id : sourceIds) {
                        dependencies.add(id.changeClassifier(null));
                    }
                } else {
                    dependencies.add(this.getId());
                }
            }
            return dependencies;
        }

        public void addSourceInfo(ArtifactId id) {
            if (id != null) {
                this.sources.add(id.toMvnId());
            }
        }

        public void addSourceInfo(String connection) {
            if (connection != null) {
                this.sources.add(connection);
            }
        }

        public Set<String> getSources() {
            return this.sources;
        }

        public int hashCode() {
            return Objects.hash(this.artifact);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ArtifactInfo)) {
                return false;
            }
            ArtifactInfo other = (ArtifactInfo)obj;
            return Objects.equals(this.artifact, other.artifact);
        }
    }
}

