/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.maven.bundlesupport.AbstractBundleInstallMojo;
import org.apache.sling.maven.bundlesupport.deploy.BundleDeploymentMethod;
import org.apache.sling.maven.bundlesupport.deploy.DeployContext;
import org.apache.sling.maven.bundlesupport.fsresource.SlingInitialContentMounter;

@Mojo(name="uninstall")
public class BundleUninstallMojo
extends AbstractBundleInstallMojo {
    @Deprecated
    @Parameter(property="sling.file", defaultValue="${project.build.directory}/${project.build.finalName}.jar")
    private File bundleFileName;
    @Parameter(property="sling.bundle.name")
    private String bundleName;

    @Override
    protected File getBundleFileName() {
        return this.bundleFileName;
    }

    @Override
    public void execute() throws MojoExecutionException {
        String bundleName;
        if (this.bundleName == null) {
            File bundleFile = this.getBundleFileName();
            String bundleSymbolicName = this.getBundleSymbolicName(bundleFile);
            if (bundleSymbolicName == null) {
                this.getLog().info((CharSequence)(bundleFile + " is not an OSGi Bundle, not uploading"));
                return;
            }
            bundleName = this.getDeploymentMethod() != BundleDeploymentMethod.WebConsole ? bundleFile.getName() : bundleSymbolicName;
        } else {
            bundleName = this.bundleName;
        }
        URI targetURL = this.getTargetURL();
        BundleDeploymentMethod deployMethod = this.getDeploymentMethod();
        try (CloseableHttpClient httpClient = this.getHttpClient();){
            if (this.mountByFS) {
                this.configure(httpClient, targetURL, null);
            }
            this.getLog().info((CharSequence)("Uninstalling Bundle " + bundleName + " from " + targetURL + " via " + (Object)((Object)deployMethod) + "..."));
            deployMethod.execute().undeploy(targetURL, bundleName, new DeployContext().log(this.getLog()).httpClient(httpClient).failOnError(this.failOnError).mimeType(this.mimeType));
            this.getLog().info((CharSequence)"Bundle uninstalled successfully!");
        }
        catch (IOException e) {
            String msg = "Uninstall from " + targetURL + " failed, cause: " + e.getMessage();
            if (this.failOnError) {
                throw new MojoExecutionException(msg, (Exception)e);
            }
            this.getLog().error((CharSequence)msg, (Throwable)e);
        }
    }

    @Override
    protected void configure(CloseableHttpClient httpClient, URI targetURL, File file) throws MojoExecutionException {
        new SlingInitialContentMounter(this.getLog(), httpClient, this.getRequestConfigBuilder(), this.project).unmount(targetURL);
    }
}

