/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.bundlesupport.AbstractBundleRequestMojo;
import org.apache.sling.maven.bundlesupport.deploy.BundleDeploymentMethod;
import org.apache.sling.maven.bundlesupport.deploy.DeployContext;
import org.apache.sling.maven.bundlesupport.fsresource.SlingInitialContentMounter;

abstract class AbstractBundleInstallMojo
extends AbstractBundleRequestMojo {
    @Deprecated
    @Parameter(property="sling.usePut", defaultValue="false")
    protected boolean usePut;
    @Parameter(property="sling.deploy.method")
    protected BundleDeploymentMethod deploymentMethod;
    @Parameter(property="sling.mimeType", defaultValue="application/java-archive")
    protected String mimeType;
    @Parameter(property="sling.bundle.startlevel", defaultValue="20")
    private String bundleStartLevel;
    @Parameter(property="sling.bundle.start", defaultValue="true")
    private boolean bundleStart;
    @Parameter(property="sling.refreshPackages", defaultValue="true")
    private boolean refreshPackages;
    @Parameter(property="sling.mountByFS", defaultValue="false")
    boolean mountByFS;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;

    protected abstract File getBundleFileName() throws MojoExecutionException;

    public void execute() throws MojoExecutionException {
        File bundleFile = this.getBundleFileName();
        if (!bundleFile.exists()) {
            throw new MojoExecutionException("The given bundle file " + bundleFile + " does not exist!");
        }
        String bundleName = this.getBundleSymbolicName(bundleFile);
        if (bundleName == null) {
            throw new MojoExecutionException("The given file " + bundleFile + " is no OSGi bundle");
        }
        URI targetURL = this.getTargetURL();
        BundleDeploymentMethod deploymentMethod = this.getDeploymentMethod();
        this.getLog().info((CharSequence)("Installing Bundle " + bundleName + "(" + bundleFile + ") to " + targetURL + " via " + (Object)((Object)deploymentMethod) + "..."));
        try (CloseableHttpClient httpClient = this.getHttpClient();){
            deploymentMethod.execute().deploy(targetURL, bundleFile, bundleName, new DeployContext().log(this.getLog()).httpClient(httpClient).failOnError(this.failOnError).bundleStartLevel(this.bundleStartLevel).bundleStart(this.bundleStart).mimeType(this.mimeType).refreshPackages(this.refreshPackages));
            this.getLog().info((CharSequence)"Bundle installed successfully");
            if (this.mountByFS) {
                this.configure(httpClient, this.getConsoleTargetURL(), bundleFile);
            }
        }
        catch (IOException e) {
            String msg = "Installation failed, cause: " + e.getMessage();
            if (this.failOnError) {
                throw new MojoExecutionException(msg, (Exception)e);
            }
            this.getLog().error((CharSequence)msg, (Throwable)e);
        }
    }

    protected void configure(CloseableHttpClient httpClient, URI consoleTargetURL, File file) throws MojoExecutionException {
        new SlingInitialContentMounter(this.getLog(), httpClient, this.getRequestConfigBuilder(), this.project).mount(consoleTargetURL, file);
    }

    protected BundleDeploymentMethod getDeploymentMethod() throws MojoExecutionException {
        if (this.deploymentMethod == null) {
            if (this.usePut) {
                this.getLog().warn((CharSequence)"Using deprecated configuration parameter 'usePut=true', please instead use the new parameter 'deploymentMethod=WebDAV'!");
                return BundleDeploymentMethod.WebDAV;
            }
            return BundleDeploymentMethod.WebConsole;
        }
        return this.deploymentMethod;
    }
}

