/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport.deploy.method;

import java.io.File;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.maven.bundlesupport.deploy.DeployContext;
import org.apache.sling.maven.bundlesupport.deploy.DeployMethod;

public class SlingPostDeployMethod
implements DeployMethod {
    @Override
    public void deploy(String targetURL, File file, String bundleSymbolicName, DeployContext context) throws MojoExecutionException {
        if (targetURL.endsWith("/")) {
            targetURL = targetURL.substring(0, targetURL.length() - 1);
        }
        PostMethod filePost = new PostMethod(targetURL);
        try {
            Part[] parts = new Part[]{new FilePart("*", (PartSource)new FilePartSource(file.getName(), file), context.getMimeType(), null), new StringPart("*@TypeHint", "nt:file")};
            filePost.setRequestHeader("Accept", "application/json");
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            int status = context.getHttpClient().executeMethod((HttpMethod)filePost);
            if (status == 200 || status == 201) {
                context.getLog().info((CharSequence)"Bundle installed");
            } else {
                String msg = "Installation failed, cause: " + HttpStatus.getStatusText((int)status);
                if (context.isFailOnError()) {
                    throw new MojoExecutionException(msg);
                }
                context.getLog().error((CharSequence)msg);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Installation on " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            filePost.releaseConnection();
        }
    }

    @Override
    public void undeploy(String targetURL, File file, String bundleSymbolicName, DeployContext context) throws MojoExecutionException {
        PostMethod post = new PostMethod(this.getURLWithFilename(targetURL, file.getName()));
        try {
            Part[] parts = new Part[]{new StringPart(":operation", "delete")};
            post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
            post.setRequestHeader("Accept", "application/json");
            int status = context.getHttpClient().executeMethod((HttpMethod)post);
            if (status == 200) {
                context.getLog().info((CharSequence)"Bundle uninstalled");
            } else {
                context.getLog().error((CharSequence)("Uninstall failed, cause: " + HttpStatus.getStatusText((int)status)));
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Uninstall from " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            post.releaseConnection();
        }
    }

    private String getURLWithFilename(String targetURL, String fileName) {
        return targetURL + (targetURL.endsWith("/") ? "" : "/") + fileName;
    }
}

