/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.maven.bundlesupport.AbstractBundleInstallMojo;
import org.apache.sling.maven.bundlesupport.deploy.BundleDeploymentMethod;
import org.apache.sling.maven.bundlesupport.deploy.DeployContext;
import org.apache.sling.maven.bundlesupport.fsresource.SlingInitialContentMounter;

@Mojo(name="uninstall")
public class BundleUninstallMojo
extends AbstractBundleInstallMojo {
    @Parameter(property="sling.file", defaultValue="${project.build.directory}/${project.build.finalName}.jar")
    private String bundleFileName;

    @Override
    protected String getBundleFileName() {
        return this.bundleFileName;
    }

    @Override
    public void execute() throws MojoExecutionException {
        File bundleFile = new File(this.bundleFileName);
        String bundleName = this.getBundleSymbolicName(bundleFile);
        if (bundleName == null) {
            this.getLog().info((CharSequence)(bundleFile + " is not an OSGi Bundle, not uploading"));
            return;
        }
        String targetURL = this.getTargetURL();
        BundleDeploymentMethod deployMethod = this.getDeploymentMethod();
        this.getLog().info((CharSequence)("Unistalling Bundle " + bundleName + " from " + targetURL + " via " + (Object)((Object)deployMethod)));
        this.configure(targetURL, bundleFile);
        deployMethod.execute().undeploy(targetURL, bundleFile, bundleName, new DeployContext().log(this.getLog()).httpClient(this.getHttpClient()).failOnError(this.failOnError).mimeType(this.mimeType));
    }

    @Override
    protected void configure(String targetURL, File file) throws MojoExecutionException {
        new SlingInitialContentMounter(this.getLog(), this.getHttpClient(), this.project).unmount(targetURL, file);
    }
}

