/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.sling.xss.impl.style.CssValidator;
import org.apache.sling.xss.impl.xml.AntiSamyPolicy;
import org.apache.sling.xss.impl.xml.Attribute;
import org.apache.sling.xss.impl.xml.Tag;
import org.jetbrains.annotations.Nullable;
import org.owasp.html.AttributePolicy;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

public class AntiSamyPolicyAdapter {
    private static final String ALLOW_DYNAMIC_ATTRIBUTES = "allowDynamicAttributes";
    private static final String REMOVE_TAG_ON_INVALID_ACTION = "removeTag";
    private final List<String> onInvalidRemoveTagList = new ArrayList<String>();
    private final Map<String, AttributePolicy> dynamicAttributesPolicyMap = new HashMap<String, AttributePolicy>();
    private PolicyFactory policyFactory;
    private CssValidator cssValidator;

    public AntiSamyPolicyAdapter(AntiSamyPolicy policy) {
        this.removeAttributeGuards();
        HtmlPolicyBuilder policyBuilder = new HtmlPolicyBuilder();
        this.cssValidator = new CssValidator(policy.getCssPolicy());
        Map<String, Attribute> globalAttributes = policy.getGlobalAttributes();
        for (Attribute attribute : globalAttributes.values()) {
            if (attribute.getOnInvalid().equals(REMOVE_TAG_ON_INVALID_ACTION)) {
                this.onInvalidRemoveTagList.add(attribute.getName());
            }
            if ("style".equals(attribute.getName())) {
                policyBuilder.allowAttributes(attribute.getName()).matching(this.cssValidator.newCssAttributePolicy()).globally();
                continue;
            }
            List<String> list = attribute.getLiterals();
            for (String allowedValue : list) {
                policyBuilder.allowAttributes(attribute.getName()).matching(true, allowedValue).globally();
            }
            List<Pattern> list2 = attribute.getPatternList();
            if (!list2.isEmpty()) {
                policyBuilder.allowAttributes(attribute.getName()).matching(AntiSamyPolicyAdapter.matchesToPatterns(list2)).globally();
                continue;
            }
            policyBuilder.allowAttributes(attribute.getName()).globally();
        }
        List<String> allowedEmptyTags = policy.getAllowedEmptyTags();
        for (String string : allowedEmptyTags) {
            policyBuilder.allowWithoutAttributes(string);
        }
        Map<String, Tag> map = policy.getTagRules();
        block16: for (Map.Entry<String, Tag> entry : map.entrySet()) {
            String tagAction;
            switch (tagAction = entry.getValue().getAction()) {
                case "truncate": {
                    policyBuilder.allowElements(entry.getValue().getName());
                    continue block16;
                }
                case "filter": {
                    continue block16;
                }
                case "remove": {
                    policyBuilder.disallowElements(entry.getValue().getName());
                    continue block16;
                }
                case "validate": 
                case "": {
                    policyBuilder.allowElements(entry.getValue().getName());
                    boolean styleSeen = false;
                    Map<String, Attribute> allowedAttributes = entry.getValue().getAttributeMap();
                    for (Attribute attribute : allowedAttributes.values()) {
                        if (attribute.getOnInvalid().equals(REMOVE_TAG_ON_INVALID_ACTION)) {
                            this.onInvalidRemoveTagList.add(attribute.getName());
                        }
                        styleSeen = "style".equals(attribute.getName());
                        List<String> literalList = attribute.getLiterals();
                        List<Pattern> patternList = attribute.getPatternList();
                        if (!literalList.isEmpty() && !patternList.isEmpty()) {
                            policyBuilder.allowAttributes(attribute.getName()).matching(AntiSamyPolicyAdapter.matchesPatternsOrLiterals(patternList, true, literalList)).onElements(entry.getValue().getName());
                            continue;
                        }
                        if (!literalList.isEmpty()) {
                            policyBuilder.allowAttributes(attribute.getName()).matching(true, literalList.toArray(new String[0])).onElements(entry.getValue().getName());
                            policyBuilder.allowAttributes(attribute.getName()).onElements(entry.getValue().getName());
                            continue;
                        }
                        if (patternList.isEmpty()) continue;
                        policyBuilder.allowAttributes(attribute.getName()).matching(AntiSamyPolicyAdapter.matchesToPatterns(patternList)).onElements(entry.getValue().getName());
                    }
                    if (styleSeen) continue block16;
                    policyBuilder.allowAttributes("style").matching(this.cssValidator.newCssAttributePolicy()).onElements(entry.getValue().getName());
                    continue block16;
                }
            }
            throw new IllegalArgumentException("No tag action found.");
        }
        policyBuilder.disallowAttributes("style").onElements(this.cssValidator.getDisallowedTagNames().toArray(new String[0]));
        HashMap<String, Attribute> hashMap = new HashMap<String, Attribute>();
        if (policy.getDirectives().get(ALLOW_DYNAMIC_ATTRIBUTES).equals("true")) {
            hashMap.putAll(policy.getDynamicAttributes());
            for (Attribute attribute : hashMap.values()) {
                if (attribute.getOnInvalid().equals(REMOVE_TAG_ON_INVALID_ACTION)) {
                    this.onInvalidRemoveTagList.add(attribute.getName());
                }
                List<Pattern> regexsFromAttribute = attribute.getPatternList();
                for (Pattern regex : regexsFromAttribute) {
                    this.dynamicAttributesPolicyMap.put(attribute.getName(), this.newDynamicAttributePolicy(regex));
                }
                List<String> allowedValuesFromAttribute = attribute.getLiterals();
                if (allowedValuesFromAttribute.isEmpty()) continue;
                this.dynamicAttributesPolicyMap.put(attribute.getName(), this.newDynamicAttributePolicy(true, allowedValuesFromAttribute.toArray(new String[0])));
            }
        }
        this.policyFactory = policyBuilder.allowTextIn("style").toFactory();
    }

    public PolicyFactory getHtmlCleanerPolicyFactory() {
        return this.policyFactory;
    }

    public Map<String, AttributePolicy> getDynamicAttributesPolicyMap() {
        return this.dynamicAttributesPolicyMap;
    }

    public List<String> getOnInvalidRemoveTagList() {
        return this.onInvalidRemoveTagList;
    }

    public CssValidator getCssValidator() {
        return this.cssValidator;
    }

    private static Predicate<String> matchesToPatterns(final List<Pattern> patternList) {
        return new Predicate<String>(){

            @Override
            public boolean apply(String s) {
                for (Pattern pattern : patternList) {
                    if (!pattern.matcher(s).matches()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static Predicate<String> matchesPatternsOrLiterals(final List<Pattern> patternList, final boolean ignoreCase, final List<String> literalList) {
        return new Predicate<String>(){

            @Override
            public boolean apply(String s) {
                for (Pattern pattern : patternList) {
                    if (!pattern.matcher(s).matches()) continue;
                    return true;
                }
                for (String string : literalList) {
                    if (!string.equals(s = ignoreCase ? s.toLowerCase() : s)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public AttributePolicy newDynamicAttributePolicy(final Pattern pattern) {
        return new AttributePolicy(){

            @Override
            @Nullable
            public String apply(String elementName, String attributeName, String value) {
                return pattern.matcher(value).matches() ? value : null;
            }
        };
    }

    public AttributePolicy newDynamicAttributePolicy(final boolean ignoreCase, String ... allowedValues) {
        final List<String> allowed = Arrays.asList(allowedValues);
        return new AttributePolicy(){

            @Override
            @Nullable
            public String apply(String elementName, String attributeName, String uncanonValue) {
                String value = ignoreCase ? uncanonValue.toLowerCase() : uncanonValue;
                return allowed.contains(value) ? value : null;
            }
        };
    }

    private void removeAttributeGuards() {
        try {
            Field guards = HtmlPolicyBuilder.class.getDeclaredField("ATTRIBUTE_GUARDS");
            this.letMeIn(guards);
            guards.set(null, new HashMap());
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    private void letMeIn(Field field) throws ReflectiveOperationException {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        if ((field.getModifiers() & 0x10) != 0) {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
    }
}

