/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.spi.support;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import org.apache.sling.validation.ValidationFailure;
import org.apache.sling.validation.ValidationResult;
import org.apache.sling.validation.spi.ValidatorContext;
import org.apache.sling.validation.spi.support.DefaultValidationFailure;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class DefaultValidationResult
implements ValidationResult,
Serializable {
    private static final long serialVersionUID = -3370520716090956033L;
    private final boolean isValid;
    @Nonnull
    private final List<ValidationFailure> failures;
    @Nonnull
    public static final DefaultValidationResult VALID = new DefaultValidationResult(true);

    private DefaultValidationResult(boolean isValid) {
        this.isValid = isValid;
        this.failures = Collections.emptyList();
    }

    public DefaultValidationResult(@Nonnull ValidatorContext validationContext, @Nonnull String messageKey, Object ... messageArguments) {
        this.isValid = false;
        this.failures = Collections.singletonList(new DefaultValidationFailure(validationContext, messageKey, messageArguments));
    }

    public DefaultValidationResult(@Nonnull String location, int severity, @Nonnull ResourceBundle defaultResourceBundle, @Nonnull String messageKey, Object ... messageArguments) {
        this.isValid = false;
        this.failures = Collections.singletonList(new DefaultValidationFailure(location, severity, defaultResourceBundle, messageKey, messageArguments));
    }

    public DefaultValidationResult(ValidationFailure ... failures) {
        this.isValid = false;
        this.failures = Arrays.asList(failures);
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    @Nonnull
    public List<ValidationFailure> getFailures() {
        return this.failures;
    }
}

