/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.spi.support;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import org.apache.sling.validation.ValidationFailure;
import org.apache.sling.validation.spi.ValidatorContext;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class DefaultValidationFailure
implements ValidationFailure,
Serializable {
    private static final long serialVersionUID = -1748031688917555982L;
    @Nonnull
    private final String location;
    @Nonnull
    private final String messageKey;
    private final Object[] messageArguments;
    @Nonnull
    private final transient ResourceBundle defaultResourceBundle;
    private final int severity;

    public DefaultValidationFailure(@Nonnull ValidatorContext validationContext, @Nonnull String messageKey, Object ... messageArguments) {
        this.location = validationContext.getLocation();
        this.severity = validationContext.getSeverity();
        this.defaultResourceBundle = validationContext.getDefaultResourceBundle();
        this.messageKey = messageKey;
        this.messageArguments = messageArguments;
    }

    public DefaultValidationFailure(@Nonnull String location, int severity, @Nonnull ResourceBundle defaultResourceBundle, @Nonnull String messageKey, Object ... messageArguments) {
        this.location = location;
        this.severity = severity;
        this.messageKey = messageKey;
        this.messageArguments = messageArguments;
        this.defaultResourceBundle = defaultResourceBundle;
    }

    @Override
    @Nonnull
    public String getMessage(ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            resourceBundle = this.defaultResourceBundle;
        }
        if (resourceBundle == null) {
            return "No defaultResourceBundle found to resolve, messageKey = " + this.messageKey + ", messageArguments: " + Arrays.toString(this.messageArguments);
        }
        return MessageFormat.format(resourceBundle.getString(this.messageKey), this.messageArguments);
    }

    @Override
    @Nonnull
    public String getLocation() {
        return this.location;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    public String toString() {
        return "DefaultValidationFailure [location=" + this.location + ", messageKey=" + this.messageKey + ", messageArguments=" + Arrays.toString(this.messageArguments) + ", severity=" + this.severity + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + Arrays.hashCode(this.messageArguments);
        result = 31 * result + (this.messageKey == null ? 0 : this.messageKey.hashCode());
        result = 31 * result + this.severity;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultValidationFailure other = (DefaultValidationFailure)obj;
        if (!this.location.equals(other.location)) {
            return false;
        }
        if (!Arrays.equals(this.messageArguments, other.messageArguments)) {
            return false;
        }
        if (!this.messageKey.equals(other.messageKey)) {
            return false;
        }
        return this.severity == other.severity;
    }
}

