/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.validation;

import java.util.List;

import javax.annotation.Nonnull;

import org.osgi.annotation.versioning.ProviderType;


/**
 * A {@code ValidationResult} contains validation information either from a single {@link org.apache.sling.validation.spi.Validator} or from multiple Validator invocations.
 */
@ProviderType
public interface ValidationResult {

    /**
     * Tells if the validation was successful or not.
     *
     * @return {@code true} for yes, {@code false} otherwise
     */
    boolean isValid();

    /**
     * In case the validation failed (check the {@link ValidationResult#isValid()} method), this method returns the failure's causes.
     *
     * @return the validation's failures (never {@code null})
     */
    @Nonnull List<ValidationFailure> getFailures();
}
