/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tracer.internal;

import ch.qos.logback.classic.Level;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.tracer.internal.CallerFinder;
import org.apache.sling.tracer.internal.Recording;
import org.apache.sling.tracer.internal.TracerConfig;
import org.apache.sling.tracer.internal.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

class JSONRecording
implements Recording,
Comparable<JSONRecording> {
    private static final String[] QUERY_API_PKGS = new String[]{"org.apache.sling.resourceresolver", "org.apache.jackrabbit.oak"};
    private static final Object[] EMPTY = new Object[0];
    private static final Logger log = LoggerFactory.getLogger(JSONRecording.class);
    public static final String OAK_QUERY_PKG = "org.apache.jackrabbit.oak.query";
    private final String method;
    private final String requestId;
    private final String uri;
    private final boolean compress;
    private final List<QueryEntry> queries = new ArrayList<QueryEntry>();
    private final List<LogEntry> logs = new ArrayList<LogEntry>();
    private final Set<String> loggerNames = new HashSet<String>();
    private RequestProgressTracker tracker;
    private byte[] json;
    private final long start = System.currentTimeMillis();
    private long timeTaken;
    private final QueryLogCollector queryCollector = new QueryLogCollector();
    private final CallerFinder queryCallerFinder = new CallerFinder(QUERY_API_PKGS);

    public JSONRecording(String requestId, HttpServletRequest r, boolean compress) {
        this.requestId = requestId;
        this.compress = compress;
        this.method = r.getMethod();
        this.uri = r.getRequestURI();
    }

    public boolean render(Writer w) throws IOException {
        if (this.json != null) {
            InputStreamReader r = new InputStreamReader(this.getInputStream(false), "UTF-8");
            IOUtils.copy((Reader)r, (Writer)w);
            return true;
        }
        return false;
    }

    public boolean render(OutputStream os, boolean compressed) throws IOException {
        if (this.json != null) {
            IOUtils.copyLarge((InputStream)this.getInputStream(compressed), (OutputStream)os);
            return true;
        }
        return false;
    }

    public int size() {
        if (this.json != null) {
            return this.json.length;
        }
        return 0;
    }

    public String getUri() {
        return this.uri;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    public long getStart() {
        return this.start;
    }

    @Override
    public void log(TracerConfig tc, Level level, String logger, FormattingTuple tuple) {
        if (logger.startsWith(OAK_QUERY_PKG)) {
            this.queryCollector.record(level, logger, tuple);
        }
        this.logs.add(new LogEntry(tc, level, logger, tuple));
    }

    @Override
    public void registerTracker(RequestProgressTracker tracker) {
        this.tracker = tracker;
    }

    @Override
    public void recordCategory(String loggerName) {
        this.loggerNames.add(loggerName);
    }

    public void done() {
        try {
            if (this.json == null) {
                this.json = this.toJSON();
                this.tracker = null;
                this.queries.clear();
                this.logs.clear();
            }
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Error occurred while converting the log data for request {} to JSON", (Object)this.requestId, (Object)e);
        }
        catch (IOException e) {
            log.warn("Error occurred while converting the log data for request {} to JSON", (Object)this.requestId, (Object)e);
        }
    }

    private byte[] toJSON() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream os = baos;
        if (this.compress) {
            os = new GZIPOutputStream(os);
        }
        OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
        JSONWriter jw = new JSONWriter(osw);
        jw.object();
        jw.key("method").value(this.method);
        this.timeTaken = System.currentTimeMillis() - this.start;
        jw.key("time").value(this.timeTaken);
        jw.key("timestamp").value(this.start);
        this.addRequestProgressLogs(jw);
        this.queryCollector.done();
        this.addJson(jw, "queries", this.queries);
        this.addJson(jw, "logs", this.logs);
        this.addLoggerNames(jw);
        jw.endObject();
        osw.flush();
        os.close();
        return baos.toByteArray();
    }

    private void addLoggerNames(JSONWriter jw) throws IOException {
        ArrayList<String> sortedNames = new ArrayList<String>(this.loggerNames);
        Collections.sort(sortedNames);
        jw.key("loggerNames");
        jw.array();
        for (String o : sortedNames) {
            jw.value(o);
        }
        jw.endArray();
    }

    private void addRequestProgressLogs(JSONWriter jw) throws IOException {
        if (this.tracker != null) {
            jw.key("requestProgressLogs");
            jw.array();
            Iterator it = this.tracker.getMessages();
            while (it != null && it.hasNext()) {
                String entry = (String)it.next();
                if (entry == null) continue;
                jw.value(entry.trim());
            }
            jw.endArray();
        }
    }

    private void addJson(JSONWriter jw, String name, List<? extends JsonEntry> entries) throws IOException {
        jw.key(name);
        jw.array();
        for (JsonEntry jsonEntry : entries) {
            jw.object();
            jsonEntry.toJson(jw);
            jw.endObject();
        }
        jw.endArray();
    }

    private InputStream getInputStream(boolean compressed) throws IOException {
        InputStream is = new ByteArrayInputStream(this.json);
        if (compressed) {
            Preconditions.checkArgument((boolean)this.compress, (Object)"Cannot provide compressed response with compression disabled");
            return is;
        }
        if (this.compress) {
            is = new GZIPInputStream(is);
        }
        return is;
    }

    @Override
    public int compareTo(@Nonnull JSONRecording o) {
        return Longs.compare((long)this.start, (long)o.start);
    }

    private class QueryLogCollector {
        String query;
        String plan;
        String caller;

        private QueryLogCollector() {
        }

        public void record(Level level, String logger, FormattingTuple tuple) {
            this.attemptQueryEntry();
            String msg = tuple.getMessage();
            if (Level.DEBUG == level && msg != null) {
                Object[] args;
                Object[] objectArray = args = tuple.getArgArray() == null ? EMPTY : tuple.getArgArray();
                if (this.query == null && "org.apache.jackrabbit.oak.query.QueryEngineImpl".equals(logger) && msg.contains("Parsing") && args.length == 2) {
                    this.query = Util.nullSafeString(args[1]);
                    this.caller = this.determineCaller();
                }
                if (this.plan == null) {
                    if ("org.apache.jackrabbit.oak.query.QueryImpl".equals(logger) && msg.startsWith("query plan ")) {
                        this.plan = msg.substring("query plan ".length());
                    } else if ("org.apache.jackrabbit.oak.query.UnionQueryImpl".equals(logger) && msg.contains("query union plan") && args.length > 0) {
                        this.plan = Util.nullSafeString(args[0]);
                    }
                }
            }
        }

        private String determineCaller() {
            StackTraceElement caller = JSONRecording.this.queryCallerFinder.determineCaller(Thread.currentThread().getStackTrace());
            if (caller != null) {
                return caller.toString();
            }
            return null;
        }

        public void attemptQueryEntry() {
            if (this.query != null && this.plan != null) {
                JSONRecording.this.queries.add(new QueryEntry(Util.nullSafeTrim(this.query), Util.nullSafeTrim(this.plan), this.caller));
                this.query = null;
                this.plan = null;
            }
        }

        public void done() {
            this.attemptQueryEntry();
        }
    }

    private static class QueryEntry
    implements JsonEntry {
        final String query;
        final String plan;
        final String caller;

        private QueryEntry(String query, String plan, String caller) {
            this.query = query;
            this.plan = plan;
            this.caller = caller;
        }

        @Override
        public void toJson(JSONWriter jw) throws IOException {
            jw.key("query").value(this.query);
            jw.key("plan").value(this.plan);
            jw.key("caller").value(this.caller);
        }
    }

    private static class LogEntry
    implements JsonEntry {
        final Level level;
        final String logger;
        final FormattingTuple tuple;
        final String[] params;
        final long timestamp = System.currentTimeMillis();
        final List<StackTraceElement> caller;

        private LogEntry(TracerConfig tc, Level level, String logger, FormattingTuple tuple) {
            this.level = level != null ? level : Level.INFO;
            this.logger = logger;
            this.tuple = tuple;
            this.params = LogEntry.getParams(tuple);
            this.caller = LogEntry.getCallerData(tc);
        }

        private static List<StackTraceElement> getCallerData(TracerConfig tc) {
            if (tc.isReportCallerStack()) {
                return tc.getCallerReporter().report();
            }
            return Collections.emptyList();
        }

        private static String[] getParams(FormattingTuple tuple) {
            Object[] params = tuple.getArgArray();
            String[] strParams = null;
            if (params != null) {
                strParams = new String[params.length];
                for (int i = 0; i < params.length; ++i) {
                    strParams[i] = LogEntry.toString(params[i]);
                }
            }
            return strParams;
        }

        private static String toString(Object o) {
            return MessageFormatter.format((String)"{}", (Object)o).getMessage();
        }

        private static String getStackTraceAsString(Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            return stringWriter.toString();
        }

        @Override
        public void toJson(JSONWriter jw) throws IOException {
            Throwable t;
            jw.key("timestamp").value(this.timestamp);
            jw.key("level").value(this.level.levelStr);
            jw.key("logger").value(this.logger);
            jw.key("message").value(this.tuple.getMessage());
            if (this.params != null) {
                jw.key("params");
                jw.array();
                for (String o : this.params) {
                    jw.value(o);
                }
                jw.endArray();
            }
            if ((t = this.tuple.getThrowable()) != null) {
                jw.key("exception").value(LogEntry.getStackTraceAsString(t));
            }
            if (!this.caller.isEmpty()) {
                jw.key("caller");
                jw.array();
                for (StackTraceElement o : this.caller) {
                    jw.value(o.toString());
                }
                jw.endArray();
            }
        }
    }

    private static interface JsonEntry {
        public void toJson(JSONWriter var1) throws IOException;
    }
}

