/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.contentparser.api.ContentHandler;
import org.apache.sling.contentparser.api.ContentParser;
import org.apache.sling.contentparser.api.ParserOptions;
import org.apache.sling.contentparser.json.JSONParserFeature;
import org.apache.sling.contentparser.json.JSONParserOptions;
import org.apache.sling.contentparser.json.internal.JSONContentParser;
import org.apache.sling.contentparser.xml.jcr.internal.JCRXMLContentParser;
import org.apache.sling.fsprovider.internal.FsResourceProvider;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.builder.ImmutableValueMap;
import org.apache.sling.testing.mock.sling.loader.LoaderContentHandler;
import org.apache.sling.testing.resourceresolver.MockResourceResolverFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class ContentLoader {
    private static final String CONTENTTYPE_OCTET_STREAM = "application/octet-stream";
    private static final Set<String> SHARED_IGNORED_NAMES = Stream.of("jcr:baseVersion", "jcr:predecessors", "jcr:successors", "jcr:versionHistory", "jcr:checkedOut", "jcr:isCheckedOut", "rep:policy").collect(Collectors.toSet());
    private static final Set<String> MOCK_IGNORED_NAMES = Stream.concat(SHARED_IGNORED_NAMES.stream(), Stream.of("jcr:mixinTypes")).collect(Collectors.toSet());
    private static final Set<String> OAK_IGNORED_NAMES = Stream.concat(SHARED_IGNORED_NAMES.stream(), Stream.of("jcr:uuid", "jcr:created")).collect(Collectors.toSet());
    private final ResourceResolver resourceResolver;
    private final BundleContext bundleContext;
    private final boolean autoCommit;
    private final Set<String> ignoredNames;
    private final ContentParser jsonParser;
    private final ParserOptions jsonParserOptions;
    private final ContentParser fileVaultXmlParser;
    private final ParserOptions fileVaultXmlParserOptions;

    public ContentLoader(@NotNull ResourceResolver resourceResolver) {
        this(resourceResolver, null);
    }

    public ContentLoader(@NotNull ResourceResolver resourceResolver, @Nullable BundleContext bundleContext) {
        this(resourceResolver, bundleContext, true);
    }

    public ContentLoader(@NotNull ResourceResolver resourceResolver, @Nullable BundleContext bundleContext, boolean autoCommit) {
        this(resourceResolver, bundleContext, autoCommit, null);
    }

    public ContentLoader(@NotNull ResourceResolver resourceResolver, @Nullable BundleContext bundleContext, boolean autoCommit, @Nullable ResourceResolverType resourceResolverType) {
        this.resourceResolver = resourceResolver;
        this.bundleContext = bundleContext;
        this.autoCommit = autoCommit;
        this.ignoredNames = this.getIgnoredNamesForResourceResolverType(resourceResolverType);
        this.jsonParserOptions = new JSONParserOptions().withFeatures(EnumSet.of(JSONParserFeature.COMMENTS, JSONParserFeature.QUOTE_TICK)).detectCalendarValues(true).ignorePropertyNames(this.ignoredNames).ignoreResourceNames(this.ignoredNames);
        this.jsonParser = new JSONContentParser();
        this.fileVaultXmlParserOptions = new ParserOptions().detectCalendarValues(true).ignorePropertyNames(this.ignoredNames).ignoreResourceNames(this.ignoredNames);
        this.fileVaultXmlParser = new JCRXMLContentParser();
    }

    private final Set<String> getIgnoredNamesForResourceResolverType(ResourceResolverType resourceResolverType) {
        if (resourceResolverType == null || resourceResolverType == ResourceResolverType.JCR_OAK) {
            return OAK_IGNORED_NAMES;
        }
        return MOCK_IGNORED_NAMES;
    }

    @NotNull
    public Resource json(@NotNull String classpathResourceOrFile, @NotNull Resource parentResource, @NotNull String childName) {
        return this.json(classpathResourceOrFile, parentResource.getPath() + "/" + childName);
    }

    @NotNull
    public Resource json(@NotNull String classpathResourceOrFile, @NotNull String destPath) {
        return this.processInputStreamFromClasspathOrFilesystem(classpathResourceOrFile, is -> this.json((InputStream)is, destPath));
    }

    @NotNull
    public Resource json(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String childName) {
        return this.json(inputStream, parentResource.getPath() + "/" + childName);
    }

    @NotNull
    public Resource json(@NotNull InputStream inputStream, @NotNull String destPath) {
        return this.mountParsedFile(inputStream, destPath, this.jsonParser, this.jsonParserOptions);
    }

    @NotNull
    public Resource fileVaultXml(@NotNull String classpathResourceOrFile, @NotNull Resource parentResource, @NotNull String childName) {
        return this.fileVaultXml(classpathResourceOrFile, parentResource.getPath() + "/" + childName);
    }

    @NotNull
    public Resource fileVaultXml(@NotNull String classpathResourceOrFile, @NotNull String destPath) {
        return this.processInputStreamFromClasspathOrFilesystem(classpathResourceOrFile, is -> this.fileVaultXml((InputStream)is, destPath));
    }

    @NotNull
    public Resource fileVaultXml(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String childName) {
        return this.fileVaultXml(inputStream, parentResource.getPath() + "/" + childName);
    }

    @NotNull
    public Resource fileVaultXml(@NotNull InputStream inputStream, @NotNull String destPath) {
        return this.mountParsedFile(inputStream, destPath, this.fileVaultXmlParser, this.fileVaultXmlParserOptions);
    }

    @NotNull
    private Resource mountParsedFile(@NotNull InputStream inputStream, @NotNull String destPath, @NotNull ContentParser contentParser, @NotNull ParserOptions parserOptions) {
        try {
            String parentPath = ResourceUtil.getParent((String)destPath);
            String childName = ResourceUtil.getName((String)destPath);
            if (parentPath == null) {
                throw new IllegalArgumentException("Path has no parent: " + destPath);
            }
            Resource parentResource = this.resourceResolver.getResource(parentPath);
            if (parentResource == null) {
                parentResource = this.createResourceHierarchy(parentPath);
            }
            if (parentResource.getChild(childName) != null) {
                throw new IllegalArgumentException("Resource does already exist: " + destPath);
            }
            LoaderContentHandler contentHandler = new LoaderContentHandler(destPath, this.resourceResolver);
            contentParser.parse((ContentHandler)contentHandler, inputStream, parserOptions);
            if (this.autoCommit) {
                this.resourceResolver.commit();
            }
            return this.resourceResolver.getResource(destPath);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    private Resource createResourceHierarchy(@NotNull String path) {
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Path has no parent: " + path);
        }
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("jcr:primaryType", "nt:unstructured");
        try {
            return this.resourceResolver.create(parentResource, ResourceUtil.getName((String)path), props);
        }
        catch (PersistenceException ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    public Resource binaryFile(@NotNull String classpathResourceOrFile, @NotNull String path) {
        return this.binaryFile(classpathResourceOrFile, path, this.detectMimeTypeFromNames(classpathResourceOrFile, path));
    }

    @NotNull
    public Resource binaryFile(@NotNull String classpathResourceOrFile, @NotNull String path, @NotNull String mimeType) {
        return this.processInputStreamFromClasspathOrFilesystem(classpathResourceOrFile, is -> this.binaryFile((InputStream)is, path, mimeType));
    }

    @NotNull
    public Resource binaryFile(@NotNull InputStream inputStream, @NotNull String path) {
        return this.binaryFile(inputStream, path, this.detectMimeTypeFromNames(path));
    }

    @NotNull
    public Resource binaryFile(@NotNull InputStream inputStream, @NotNull String path, @NotNull String mimeType) {
        String parentPath = ResourceUtil.getParent((String)path, (int)1);
        String name = ResourceUtil.getName((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Path has no parent: " + path);
        }
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        return this.binaryFile(inputStream, parentResource, name, mimeType);
    }

    @NotNull
    public Resource binaryFile(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String name) {
        return this.binaryFile(inputStream, parentResource, name, this.detectMimeTypeFromNames(name));
    }

    @NotNull
    public Resource binaryFile(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String name, @NotNull String mimeType) {
        try {
            Resource file = this.resourceResolver.create(parentResource, name, (Map)((Object)ImmutableValueMap.of("jcr:primaryType", "nt:file")));
            this.resourceResolver.create(file, "jcr:content", (Map)((Object)ImmutableValueMap.of("jcr:primaryType", "nt:resource", "jcr:data", inputStream, "jcr:mimeType", mimeType)));
            if (this.autoCommit) {
                this.resourceResolver.commit();
            }
            return file;
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + parentResource.getPath() + "/" + name, ex);
        }
    }

    @NotNull
    public Resource binaryResource(@NotNull String classpathResourceOrFile, @NotNull String path) {
        return this.binaryResource(classpathResourceOrFile, path, this.detectMimeTypeFromNames(classpathResourceOrFile, path));
    }

    @NotNull
    public Resource binaryResource(@NotNull String classpathResourceOrFile, @NotNull String path, @NotNull String mimeType) {
        return this.processInputStreamFromClasspathOrFilesystem(classpathResourceOrFile, is -> this.binaryResource((InputStream)is, path, mimeType));
    }

    @NotNull
    public Resource binaryResource(@NotNull InputStream inputStream, @NotNull String path) {
        return this.binaryResource(inputStream, path, this.detectMimeTypeFromNames(path));
    }

    @NotNull
    public Resource binaryResource(@NotNull InputStream inputStream, @NotNull String path, @NotNull String mimeType) {
        String parentPath = ResourceUtil.getParent((String)path, (int)1);
        String name = ResourceUtil.getName((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Path has no parent: " + path);
        }
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            parentResource = this.createResourceHierarchy(parentPath);
        }
        return this.binaryResource(inputStream, parentResource, name, mimeType);
    }

    @NotNull
    public Resource binaryResource(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String name) {
        return this.binaryResource(inputStream, parentResource, name, this.detectMimeTypeFromNames(name));
    }

    @NotNull
    public Resource binaryResource(@NotNull InputStream inputStream, @NotNull Resource parentResource, @NotNull String name, @NotNull String mimeType) {
        try {
            Resource resource = this.resourceResolver.create(parentResource, name, (Map)((Object)ImmutableValueMap.of("jcr:primaryType", "nt:resource", "jcr:data", inputStream, "jcr:mimeType", mimeType)));
            if (this.autoCommit) {
                this.resourceResolver.commit();
            }
            return resource;
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + parentResource.getPath() + "/" + name, ex);
        }
    }

    @NotNull
    private String detectMimeTypeFromNames(String ... names) {
        String mimeType = null;
        for (String name : names) {
            ServiceReference ref;
            String fileExtension = StringUtils.substringAfterLast((String)name, (String)".");
            if (this.bundleContext == null || !StringUtils.isNotEmpty((CharSequence)fileExtension) || (ref = this.bundleContext.getServiceReference(MimeTypeService.class)) == null) continue;
            MimeTypeService mimeTypeService = (MimeTypeService)this.bundleContext.getService(ref);
            mimeType = mimeTypeService.getMimeType(fileExtension);
            break;
        }
        return Objects.toString(mimeType, CONTENTTYPE_OCTET_STREAM);
    }

    public void folderJson(@NotNull String mountFolderPath, @NotNull Resource parentResource, @NotNull String childName) {
        this.folderJson(new File(mountFolderPath), parentResource, childName);
    }

    public void folderJson(@NotNull String mountFolderPath, @NotNull String destPath) {
        this.folderJson(new File(mountFolderPath), destPath);
    }

    public void folderJson(@NotNull File mountFolder, @NotNull Resource parentResource, @NotNull String childName) {
        this.folderJson(mountFolder, parentResource.getPath() + "/" + childName);
    }

    public void folderJson(@NotNull File mountFolder, @NotNull String destPath) {
        this.registerFileSystemResourceProvider("provider.file", mountFolder.getAbsolutePath(), "provider.root", destPath, "provider.fs.mode", "INITIAL_CONTENT", "provider.initial.content.import.options", "overwrite:=true;ignoreImportProviders:=\"xml\"", "provider.checkinterval", 0);
    }

    public void folderFileVaultXml(@NotNull String mountFolderPath, @NotNull Resource parentResource, @NotNull String childName) {
        this.folderFileVaultXml(new File(mountFolderPath), parentResource, childName);
    }

    public void folderFileVaultXml(@NotNull String mountFolderPath, @NotNull String destPath) {
        this.folderFileVaultXml(new File(mountFolderPath), destPath);
    }

    public void folderFileVaultXml(@NotNull File mountFolder, @NotNull Resource parentResource, @NotNull String childName) {
        this.folderFileVaultXml(mountFolder, parentResource.getPath() + "/" + childName);
    }

    public void folderFileVaultXml(@NotNull File mountFolder, @NotNull String destPath) {
        this.registerFileSystemResourceProvider("provider.file", mountFolder.getAbsolutePath(), "provider.root", destPath, "provider.fs.mode", "FILEVAULT_XML", "provider.checkinterval", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private <T> T processInputStreamFromClasspathOrFilesystem(@NotNull String classpathResourceOrFile, @NotNull Function<InputStream, T> processor) {
        InputStream is = ContentLoader.class.getResourceAsStream(classpathResourceOrFile);
        if (is == null) {
            try {
                is = new FileInputStream(classpathResourceOrFile);
            }
            catch (FileNotFoundException ex) {
                throw new IllegalArgumentException("Classpath resource or file not found: " + classpathResourceOrFile);
            }
        }
        try {
            T t = processor.apply(is);
            return t;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private void registerFileSystemResourceProvider(Object ... serviceProperties) {
        if (this.bundleContext == null) {
            throw new IllegalStateException("No bundle context given for content loader.");
        }
        if (this.isUsingMockResourceResolverFactory()) {
            throw new IllegalStateException("Loading folder content is not supported with RESOURCERESOLVER_MOCK resource resolver type. Use RESOURCEPROVIDER_MOCK or one of the other types.");
        }
        Dictionary props = MapUtil.toDictionary((Object[])serviceProperties);
        FsResourceProvider service = (FsResourceProvider)MockOsgi.activateInjectServices(FsResourceProvider.class, (BundleContext)this.bundleContext, (Object[])new Object[]{props});
        this.bundleContext.registerService(ResourceProvider.class, (Object)service, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUsingMockResourceResolverFactory() {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(ResourceResolverFactory.class);
        if (serviceReference == null) {
            throw new IllegalStateException("No resource resolver factory service present.");
        }
        try {
            ResourceResolverFactory resourceResolverFactory = (ResourceResolverFactory)this.bundleContext.getService(serviceReference);
            boolean bl = resourceResolverFactory instanceof MockResourceResolverFactory;
            return bl;
        }
        finally {
            this.bundleContext.ungetService(serviceReference);
        }
    }
}

