/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.apache.sling.xss.XSSAPI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MockXSSAPIImplTest {
    @Rule
    public SlingContext context = new SlingContext();
    private XSSAPI underTest;

    @Before
    public void setUp() {
        this.underTest = (XSSAPI)this.context.getService(XSSAPI.class);
    }

    @Test
    public void testGetValidInteger() {
        Assert.assertEquals((Object)123, (Object)this.underTest.getValidInteger("123", -1));
        Assert.assertEquals((Object)-123, (Object)this.underTest.getValidInteger("-123", -1));
        Assert.assertEquals((Object)-1, (Object)this.underTest.getValidInteger("invalid", -1));
        Assert.assertEquals((Object)-1, (Object)this.underTest.getValidInteger("", -1));
        Assert.assertEquals((Object)-1, (Object)this.underTest.getValidInteger(null, -1));
    }

    @Test
    public void testGetValidLong() throws Exception {
        Assert.assertEquals((Object)123L, (Object)this.underTest.getValidLong("123", -1L));
        Assert.assertEquals((Object)-123L, (Object)this.underTest.getValidLong("-123", -1L));
        Assert.assertEquals((Object)-1L, (Object)this.underTest.getValidLong("invalid", -1L));
        Assert.assertEquals((Object)-1L, (Object)this.underTest.getValidLong("", -1L));
        Assert.assertEquals((Object)-1L, (Object)this.underTest.getValidLong(null, -1L));
    }

    @Test
    public void testGetValidDouble() throws Exception {
        Assert.assertEquals((Object)1.23, (Object)this.underTest.getValidDouble("1.23", -1.0));
        Assert.assertEquals((Object)-1.23, (Object)this.underTest.getValidDouble("-1.23", -1.0));
        Assert.assertEquals((Object)-1.0, (Object)this.underTest.getValidDouble("invalid", -1.0));
        Assert.assertEquals((Object)-1.5, (Object)this.underTest.getValidDouble("", -1.5));
        Assert.assertEquals((Object)-1.0, (Object)this.underTest.getValidDouble(null, -1.0));
    }

    @Test
    public void testGetValidDimension() throws Exception {
        Assert.assertEquals((Object)"123", (Object)this.underTest.getValidDimension("123", "-1"));
        Assert.assertEquals((Object)"-123", (Object)this.underTest.getValidDimension("-123", "-1"));
        Assert.assertEquals((Object)"-1", (Object)this.underTest.getValidDimension("invalid", "-1"));
        Assert.assertEquals((Object)"-1", (Object)this.underTest.getValidDimension("", "-1"));
        Assert.assertEquals((Object)"-1", (Object)this.underTest.getValidDimension(null, "-1"));
        Assert.assertEquals((Object)"\"auto\"", (Object)this.underTest.getValidDimension("\"auto\"", "-1"));
        Assert.assertEquals((Object)"\"auto\"", (Object)this.underTest.getValidDimension("'auto'", "-1"));
    }

    @Test
    public void testGetValidHref() throws Exception {
        Assert.assertEquals((Object)"val", (Object)this.underTest.getValidHref("val"));
        Assert.assertEquals((Object)"", (Object)this.underTest.getValidHref(null));
    }

    @Test
    public void testGetValidJSToken() throws Exception {
        Assert.assertEquals((Object)"val", (Object)this.underTest.getValidJSToken("val", "def"));
        Assert.assertEquals((Object)"def", (Object)this.underTest.getValidJSToken("", "def"));
        Assert.assertEquals((Object)"def", (Object)this.underTest.getValidJSToken(null, "def"));
    }

    @Test
    public void testGetValidStyleToken() throws Exception {
        Assert.assertEquals((Object)"val", (Object)this.underTest.getValidStyleToken("val", "def"));
        Assert.assertEquals((Object)"def", (Object)this.underTest.getValidStyleToken("", "def"));
        Assert.assertEquals((Object)"def", (Object)this.underTest.getValidStyleToken(null, "def"));
    }

    @Test
    public void testGetValidCSSColor() throws Exception {
        Assert.assertEquals((Object)"val", (Object)this.underTest.getValidCSSColor("val", "def"));
        Assert.assertEquals((Object)"def", (Object)this.underTest.getValidCSSColor("", "def"));
        Assert.assertEquals((Object)"def", (Object)this.underTest.getValidCSSColor(null, "def"));
    }

    @Test
    public void testGetValidMultiLineComment() throws Exception {
        Assert.assertEquals((Object)"val", (Object)this.underTest.getValidMultiLineComment("val", "def"));
        Assert.assertEquals((Object)"def", (Object)this.underTest.getValidMultiLineComment("", "def"));
        Assert.assertEquals((Object)"def", (Object)this.underTest.getValidMultiLineComment(null, "def"));
    }

    @Test
    public void testGetValidJSON() throws Exception {
        Assert.assertEquals((Object)"val", (Object)this.underTest.getValidJSON("val", "def"));
        Assert.assertEquals((Object)"def", (Object)this.underTest.getValidJSON("", "def"));
        Assert.assertEquals((Object)"def", (Object)this.underTest.getValidJSON(null, "def"));
    }

    @Test
    public void testGetValidXML() throws Exception {
        Assert.assertEquals((Object)"val", (Object)this.underTest.getValidXML("val", "def"));
        Assert.assertEquals((Object)"def", (Object)this.underTest.getValidXML("", "def"));
        Assert.assertEquals((Object)"def", (Object)this.underTest.getValidXML(null, "def"));
    }

    @Test
    public void testEncodeForHTML() throws Exception {
        Assert.assertEquals((Object)"val", (Object)this.underTest.encodeForHTML("val"));
        Assert.assertNull((Object)this.underTest.encodeForHTML(null));
    }

    @Test
    public void testEncodeForHTMLAttr() throws Exception {
        Assert.assertEquals((Object)"val", (Object)this.underTest.encodeForHTMLAttr("val"));
        Assert.assertNull((Object)this.underTest.encodeForHTMLAttr(null));
    }

    @Test
    public void testEncodeForXML() throws Exception {
        Assert.assertEquals((Object)"val", (Object)this.underTest.encodeForXML("val"));
        Assert.assertNull((Object)this.underTest.encodeForXML(null));
    }

    @Test
    public void testEncodeForXMLAttr() throws Exception {
        Assert.assertEquals((Object)"val", (Object)this.underTest.encodeForXMLAttr("val"));
        Assert.assertNull((Object)this.underTest.encodeForXMLAttr(null));
    }

    @Test
    public void testEncodeForJSString() throws Exception {
        Assert.assertEquals((Object)"val", (Object)this.underTest.encodeForJSString("val"));
        Assert.assertNull((Object)this.underTest.encodeForJSString(null));
    }

    @Test
    public void testEncodeForCSSString() throws Exception {
        Assert.assertEquals((Object)"val", (Object)this.underTest.encodeForCSSString("val"));
        Assert.assertNull((Object)this.underTest.encodeForCSSString(null));
    }

    @Test
    public void testFilterHTML() throws Exception {
        Assert.assertEquals((Object)"val", (Object)this.underTest.filterHTML("val"));
        Assert.assertEquals((Object)"", (Object)this.underTest.filterHTML(null));
    }
}

