/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.xss.XSSAPI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;

@Component(service={XSSAPI.class})
public final class MockXSSAPIImpl
implements XSSAPI {
    private static final Pattern PATTERN_AUTO_DIMENSION = Pattern.compile("['\"]?auto['\"]?");

    @Nullable
    public Integer getValidInteger(@Nullable String integer, int defaultValue) {
        if (StringUtils.isNotBlank((CharSequence)integer)) {
            try {
                return Integer.parseInt(integer);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Nullable
    public Long getValidLong(@Nullable String source, long defaultValue) {
        if (StringUtils.isNotBlank((CharSequence)source)) {
            try {
                return Long.parseLong(source);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Nullable
    public Double getValidDouble(@Nullable String source, double defaultValue) {
        if (StringUtils.isNotBlank((CharSequence)source)) {
            try {
                return Double.parseDouble(source);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Nullable
    public String getValidDimension(@Nullable String dimension, @Nullable String defaultValue) {
        if (StringUtils.isNotBlank((CharSequence)dimension)) {
            if (PATTERN_AUTO_DIMENSION.matcher(dimension).matches()) {
                return "\"auto\"";
            }
            try {
                return Integer.toString(Integer.parseInt(dimension));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @NotNull
    public String getValidHref(@Nullable String url) {
        return StringUtils.defaultString((String)url);
    }

    @Nullable
    public String getValidJSToken(@Nullable String token, @Nullable String defaultValue) {
        return (String)StringUtils.defaultIfBlank((CharSequence)token, (CharSequence)defaultValue);
    }

    @Nullable
    public String getValidStyleToken(@Nullable String token, @Nullable String defaultValue) {
        return (String)StringUtils.defaultIfBlank((CharSequence)token, (CharSequence)defaultValue);
    }

    @Nullable
    public String getValidCSSColor(@Nullable String color, @Nullable String defaultColor) {
        return (String)StringUtils.defaultIfBlank((CharSequence)color, (CharSequence)defaultColor);
    }

    public String getValidMultiLineComment(@Nullable String comment, @Nullable String defaultComment) {
        return (String)StringUtils.defaultIfBlank((CharSequence)comment, (CharSequence)defaultComment);
    }

    public String getValidJSON(@Nullable String json, @Nullable String defaultJson) {
        return (String)StringUtils.defaultIfBlank((CharSequence)json, (CharSequence)defaultJson);
    }

    public String getValidXML(@Nullable String xml, @Nullable String defaultXml) {
        return (String)StringUtils.defaultIfBlank((CharSequence)xml, (CharSequence)defaultXml);
    }

    @Nullable
    public String encodeForHTML(@Nullable String source) {
        return source;
    }

    @Nullable
    public String encodeForHTMLAttr(@Nullable String source) {
        return source;
    }

    @Nullable
    public String encodeForXML(@Nullable String source) {
        return source;
    }

    @Nullable
    public String encodeForXMLAttr(@Nullable String source) {
        return source;
    }

    @Nullable
    public String encodeForJSString(@Nullable String source) {
        return source;
    }

    @Nullable
    public String encodeForCSSString(@Nullable String source) {
        return source;
    }

    @NotNull
    public String filterHTML(@Nullable String source) {
        return StringUtils.defaultString((String)source);
    }
}

