/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.wrappers.ResourceResolverWrapper;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RRMockResourceResolverWrapper
extends ResourceResolverWrapper
implements ResolveContext {
    private final ConcurrentMap<String, ResourceProvider> resourceProviders;

    RRMockResourceResolverWrapper(ResourceResolver delegate, ConcurrentMap<String, ResourceProvider> resourceProviders) {
        super(delegate);
        this.resourceProviders = resourceProviders;
    }

    public Resource getResource(@NotNull String path) {
        if (this.resourceProviders.isEmpty()) {
            return super.getResource(path);
        }
        List<String> normalizedPaths = this.getNormalizedPaths(path);
        Iterator<String> iterator = normalizedPaths.iterator();
        if (iterator.hasNext()) {
            String normalizedPath = iterator.next();
            ResourceProvider resourceProvider = this.getMatchingResourceProvider(normalizedPath);
            if (resourceProvider != null) {
                return resourceProvider.getResource((ResolveContext)this, normalizedPath, ResourceContext.EMPTY_CONTEXT, null);
            }
            return super.getResource(path);
        }
        return null;
    }

    public Resource getResource(Resource base, @NotNull String path) {
        if (this.resourceProviders.isEmpty()) {
            return super.getResource(base, path);
        }
        String normalizedPath = ResourceUtil.normalize((String)(base.getPath() + "/" + path));
        if (normalizedPath != null) {
            ResourceProvider resourceProvider = this.getMatchingResourceProvider(normalizedPath);
            if (resourceProvider != null) {
                return resourceProvider.getResource((ResolveContext)this, normalizedPath, ResourceContext.EMPTY_CONTEXT, null);
            }
            return super.getResource(path);
        }
        return null;
    }

    public Resource getParent(@NotNull Resource child) {
        String parentPath = ResourceUtil.getParent((String)child.getPath());
        if (parentPath == null) {
            return null;
        }
        return this.getResource(parentPath);
    }

    @NotNull
    public Iterator<Resource> listChildren(@NotNull Resource parent) {
        if (this.resourceProviders.isEmpty()) {
            return super.listChildren(parent);
        }
        ResourceProvider resourceProvider = this.getMatchingResourceProvider(parent.getPath());
        if (resourceProvider != null) {
            Iterator result = resourceProvider.listChildren((ResolveContext)this, parent);
            if (result == null) {
                return Collections.emptyIterator();
            }
            return result;
        }
        return super.listChildren(parent);
    }

    @NotNull
    public Iterable<Resource> getChildren(@NotNull Resource parent) {
        return () -> this.listChildren(parent);
    }

    public boolean hasChildren(@NotNull Resource resource) {
        return this.listChildren(resource).hasNext();
    }

    private ResourceProvider getMatchingResourceProvider(String path) {
        ResourceProvider provider = (ResourceProvider)this.resourceProviders.get(path);
        if (provider != null) {
            return provider;
        }
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath != null) {
            return this.getMatchingResourceProvider(parentPath);
        }
        return null;
    }

    @NotNull
    public ResourceResolver getResourceResolver() {
        return this;
    }

    @Nullable
    public Object getProviderState() {
        return null;
    }

    @Nullable
    public ResolveContext getParentResolveContext() {
        return null;
    }

    @Nullable
    public ResourceProvider getParentResourceProvider() {
        return null;
    }

    private List<String> getNormalizedPaths(String path) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)"/")) {
            result.add(ResourceUtil.normalize((String)path));
        } else {
            for (String searchPath : this.getSearchPath()) {
                String combinedPath = StringUtils.removeEnd((String)searchPath, (String)"/") + "/" + path;
                result.add(ResourceUtil.normalize((String)combinedPath));
            }
        }
        return result;
    }

    public boolean isResourceType(Resource resource, String resourceType) {
        if (this.resourceProviders.isEmpty()) {
            return super.isResourceType(resource, resourceType);
        }
        boolean result = false;
        if (resource != null && resourceType != null) {
            if (ResourceTypeUtil.areResourceTypesEqual(resourceType, resource.getResourceType(), this.getSearchPath())) {
                result = true;
            } else {
                HashSet<String> superTypesChecked = new HashSet<String>();
                String superType = this.getParentResourceType(resource);
                while (!result && superType != null) {
                    if (ResourceTypeUtil.areResourceTypesEqual(resourceType, superType, this.getSearchPath())) {
                        result = true;
                        continue;
                    }
                    superTypesChecked.add(superType);
                    if ((superType = this.getParentResourceType(superType)) == null || !superTypesChecked.contains(superType)) continue;
                    throw new SlingException("Cyclic dependency for resourceSuperType hierarchy detected on resource " + resource.getPath()){
                        private static final long serialVersionUID = 1L;
                    };
                }
            }
        }
        return result;
    }

    public String getParentResourceType(Resource resource) {
        if (this.resourceProviders.isEmpty()) {
            return super.getParentResourceType(resource);
        }
        String resourceSuperType = null;
        if (resource != null && (resourceSuperType = resource.getResourceSuperType()) == null) {
            resourceSuperType = this.getParentResourceType(resource.getResourceType());
        }
        return resourceSuperType;
    }

    public String getParentResourceType(String resourceType) {
        Resource rtResource;
        if (this.resourceProviders.isEmpty()) {
            return super.getParentResourceType(resourceType);
        }
        String rtPath = resourceType == null ? null : ResourceUtil.resourceTypeToPath((String)resourceType);
        String resourceSuperType = null;
        if (rtPath != null && (rtResource = this.getResource(rtPath)) != null) {
            resourceSuperType = rtResource.getResourceSuperType();
        }
        return resourceSuperType;
    }

    static class ResourceTypeUtil {
        ResourceTypeUtil() {
        }

        public static boolean areResourceTypesEqual(@NotNull String resourceType, @NotNull String anotherResourceType, String @NotNull [] searchPath) {
            return ResourceTypeUtil.relativizeResourceType(resourceType, searchPath).equals(ResourceTypeUtil.relativizeResourceType(anotherResourceType, searchPath));
        }

        public static String relativizeResourceType(@NotNull String resourceType, String @NotNull [] searchPath) {
            if (resourceType.startsWith("/")) {
                for (String prefix : searchPath) {
                    if (!resourceType.startsWith(prefix)) continue;
                    return resourceType.substring(prefix.length());
                }
            }
            return resourceType;
        }
    }
}

