/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.apache.sling.testing.mock.sling.context.SlingContextImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

class MockSlingBindings
extends SlingBindings
implements EventHandler {
    private static final long serialVersionUID = 1L;
    private static final String PROP_CURRENT_NODE = "currentNode";
    private static final String PROP_CURRENT_SESSION = "currentSession";
    static final String SERVICE_PROPERTY_MOCK_SLING_BINDINGS_IGNORE = "MockSlingBindings-ignore";
    private volatile SlingContextImpl context;

    public MockSlingBindings(SlingContextImpl context) {
        this.context = context;
        this.populateFromBindingsValuesProvider();
    }

    public Object get(Object key) {
        Object result;
        if (this.context == null) {
            return null;
        }
        if (key instanceof String && (result = this.context.resolveSlingBindingProperty((String)key, (SlingHttpServletRequest)this.context.request())) != null) {
            return result;
        }
        return super.get(key);
    }

    private void populateFromBindingsValuesProvider() {
        SimpleBindings bindings = new SimpleBindings();
        for (BindingsValuesProvider provider : (BindingsValuesProvider[])this.context.getServices(BindingsValuesProvider.class, "(!(MockSlingBindings-ignore=true))")) {
            provider.addBindings((Bindings)bindings);
        }
        this.clear();
        this.putAll(bindings);
    }

    public void handleEvent(Event event) {
        if (this.context == null) {
            return;
        }
        this.populateFromBindingsValuesProvider();
    }

    @Nullable
    static Object resolveSlingBindingProperty(@NotNull SlingContextImpl context, @NotNull String property) {
        Resource resource;
        if (StringUtils.equals((CharSequence)property, (CharSequence)"resolver")) {
            return context.resourceResolver();
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)"resource")) {
            return context.currentResource();
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)"request")) {
            return context.request();
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)"response")) {
            return context.response();
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)"sling")) {
            return context.slingScriptHelper();
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)"reader")) {
            return context.request().getReader();
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)"out")) {
            return context.response().getWriter();
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)PROP_CURRENT_NODE) && (resource = context.currentResource()) != null) {
            return resource.adaptTo(Node.class);
        }
        if (StringUtils.equals((CharSequence)property, (CharSequence)PROP_CURRENT_SESSION)) {
            return context.resourceResolver().adaptTo(Session.class);
        }
        return null;
    }

    public void tearDown() {
        this.context = null;
    }
}

