/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ContextResourceResolverFactory {
    private static final Logger log = LoggerFactory.getLogger(ContextResourceResolverFactory.class);

    private ContextResourceResolverFactory() {
    }

    @NotNull
    public static ResourceResolverFactory get(@Nullable ResourceResolverType resourceResolverType, @NotNull BundleContext bundleContext) {
        ResourceResolverType type = resourceResolverType;
        if (type == null) {
            type = MockSling.DEFAULT_RESOURCERESOLVER_TYPE;
        }
        try {
            log.debug("Start initialize resource resolver factory, bundleContext={}", (Object)bundleContext);
            ResourceResolverFactory factory = MockSling.newResourceResolverFactory(type, bundleContext);
            switch (type) {
                case JCR_MOCK: {
                    ContextResourceResolverFactory.initializeJcrMock(factory);
                    break;
                }
                case JCR_OAK: {
                    ContextResourceResolverFactory.initializeJcrOak(factory);
                    break;
                }
                case RESOURCERESOLVER_MOCK: {
                    ContextResourceResolverFactory.initializeResourceResolverMock(factory);
                    break;
                }
                case NONE: {
                    ContextResourceResolverFactory.initializeResourceResolverNone(factory);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid resource resolver type: " + (Object)((Object)type));
                }
            }
            log.debug("Finished initializing resource resolver factory, bundleContext={}", (Object)bundleContext);
            return factory;
        }
        catch (Throwable ex) {
            log.error("Failed initializing resource resolver factory, bundleContext={}", (Object)bundleContext, (Object)ex);
            throw new RuntimeException("Unable to initialize " + (Object)((Object)type) + " resource resolver factory: " + ex.getMessage(), ex);
        }
    }

    private static void initializeJcrMock(@NotNull ResourceResolverFactory factory) throws RepositoryException, LoginException {
    }

    private static void initializeJcrOak(@NotNull ResourceResolverFactory factory) {
    }

    private static void initializeResourceResolverMock(@NotNull ResourceResolverFactory factory) {
    }

    private static void initializeResourceResolverNone(@NotNull ResourceResolverFactory factory) {
    }
}

