/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.util.Hashtable;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.MockAdapterManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ThreadsafeMockAdapterManagerWrapper
implements AdapterManager {
    private static final Logger log = LoggerFactory.getLogger(ThreadsafeMockAdapterManagerWrapper.class);
    private static final ThreadLocal<AdapterManagerBundleContextFactory> THREAD_LOCAL = new ThreadLocal<AdapterManagerBundleContextFactory>(){

        @Override
        protected AdapterManagerBundleContextFactory initialValue() {
            return new AdapterManagerBundleContextFactory();
        }
    };

    ThreadsafeMockAdapterManagerWrapper() {
    }

    public <AdapterType> AdapterType getAdapter(@NotNull Object adaptable, @NotNull Class<AdapterType> type) {
        AdapterManager adapterManager = THREAD_LOCAL.get().getAdapterManager();
        return (AdapterType)adapterManager.getAdapter(adaptable, type);
    }

    public void setBundleContext(@NotNull BundleContext bundleContext) {
        AdapterManagerBundleContextFactory adapterManager = THREAD_LOCAL.get();
        adapterManager.setBundleContext(bundleContext);
    }

    public void clearBundleContext() {
        AdapterManagerBundleContextFactory adapterManager = THREAD_LOCAL.get();
        adapterManager.clearBundleContext();
    }

    private static class AdapterManagerBundleContextFactory {
        private BundleContext bundleContext;

        private AdapterManagerBundleContextFactory() {
        }

        public void setBundleContext(@NotNull BundleContext bundleContext) {
            log.debug("Set bundle context for AdapterManager, bundleContext={}", (Object)bundleContext);
            this.bundleContext = bundleContext;
            MockAdapterManagerImpl adapterManagerImpl = new MockAdapterManagerImpl();
            Hashtable properties = new Hashtable();
            MockOsgi.injectServices((Object)adapterManagerImpl, (BundleContext)bundleContext);
            MockOsgi.activate((Object)adapterManagerImpl, (BundleContext)bundleContext, properties);
            bundleContext.registerService(AdapterManager.class.getName(), (Object)adapterManagerImpl, properties);
        }

        public void clearBundleContext() {
            this.bundleContext = null;
        }

        public synchronized AdapterManager getAdapterManager() {
            ServiceReference serviceReference;
            if (this.bundleContext == null) {
                BundleContext newBundleContext = MockOsgi.newBundleContext();
                log.warn("Create new bundle context for adapter manager because it was null, bundleContext={}", (Object)this.bundleContext);
                this.setBundleContext(newBundleContext);
            }
            if ((serviceReference = this.bundleContext.getServiceReference(AdapterManager.class)) != null) {
                return (AdapterManager)this.bundleContext.getService(serviceReference);
            }
            throw new RuntimeException("AdapterManager not registered in bundle context.");
        }
    }
}

