/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.core.MutableRoot;
import org.apache.jackrabbit.oak.plugins.tree.impl.AbstractMutableTree;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.base.Preconditions;

final class MutableTree
extends AbstractMutableTree {
    private final MutableRoot root;
    private MutableTree parent;
    private String name;
    private NodeBuilder nodeBuilder;
    private MutableRoot.Move pendingMoves;

    MutableTree(@NotNull MutableRoot root, @NotNull NodeBuilder nodeBuilder, @NotNull MutableRoot.Move pendingMoves) {
        this(root, pendingMoves, null, nodeBuilder, "");
    }

    private MutableTree(@NotNull MutableRoot root, @NotNull MutableRoot.Move pendingMoves, @Nullable MutableTree parent, @NotNull NodeBuilder nodeBuilder, @NotNull String name) {
        this.root = Preconditions.checkNotNull(root);
        this.parent = parent;
        this.name = Preconditions.checkNotNull(name);
        this.nodeBuilder = nodeBuilder;
        this.pendingMoves = Preconditions.checkNotNull(pendingMoves);
    }

    @Override
    @Nullable
    protected AbstractMutableTree getParentOrNull() {
        return this.parent;
    }

    @Override
    @NotNull
    protected NodeBuilder getNodeBuilder() {
        return this.nodeBuilder;
    }

    @Override
    @NotNull
    protected MutableTree createChild(@NotNull String name) throws IllegalArgumentException {
        return new MutableTree(this.root, this.pendingMoves, this, this.nodeBuilder.getChildNode(Preconditions.checkNotNull(name)), name);
    }

    @Override
    @NotNull
    public String getName() {
        this.beforeRead();
        return this.name;
    }

    @Override
    @NotNull
    public String getPath() {
        this.beforeRead();
        return super.getPath();
    }

    @Override
    @NotNull
    public Tree.Status getStatus() {
        this.beforeRead();
        return super.getStatus();
    }

    @Override
    public boolean exists() {
        this.beforeRead();
        return super.exists();
    }

    @Override
    public PropertyState getProperty(@NotNull String name) {
        this.beforeRead();
        return super.getProperty(Preconditions.checkNotNull(name));
    }

    @Override
    public boolean hasProperty(@NotNull String name) {
        this.beforeRead();
        return super.hasProperty(Preconditions.checkNotNull(name));
    }

    @Override
    public long getPropertyCount() {
        this.beforeRead();
        return super.getPropertyCount();
    }

    @Override
    @Nullable
    public Tree.Status getPropertyStatus(@NotNull String name) {
        this.beforeRead();
        return super.getPropertyStatus(Preconditions.checkNotNull(name));
    }

    @Override
    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        this.beforeRead();
        return super.getProperties();
    }

    @Override
    @NotNull
    public Tree getChild(@NotNull String name) {
        this.beforeRead();
        return super.getChild(Preconditions.checkNotNull(name));
    }

    @Override
    public boolean hasChild(@NotNull String name) {
        this.beforeRead();
        return super.hasChild(Preconditions.checkNotNull(name));
    }

    @Override
    public long getChildrenCount(long max) {
        this.beforeRead();
        return super.getChildrenCount(max);
    }

    @Override
    @NotNull
    public Iterable<Tree> getChildren() {
        this.beforeRead();
        return super.getChildren();
    }

    @Override
    public boolean remove() {
        this.beforeWrite();
        boolean success = super.remove();
        if (success) {
            this.root.updated();
        }
        return success;
    }

    @Override
    @NotNull
    public Tree addChild(@NotNull String name) {
        Tree child;
        this.beforeWrite();
        if (this.hasChild(name)) {
            child = this.createChild(name);
        } else {
            child = super.addChild(name);
            this.root.updated();
        }
        return child;
    }

    @Override
    public void setOrderableChildren(boolean enable) {
        this.beforeWrite();
        super.setOrderableChildren(enable);
    }

    @Override
    public boolean orderBefore(@Nullable String name) {
        this.beforeWrite();
        boolean success = super.orderBefore(name);
        if (success) {
            this.root.updated();
        }
        return success;
    }

    @Override
    public void setProperty(@NotNull PropertyState property) {
        this.beforeWrite();
        super.setProperty(property);
        this.root.updated();
    }

    @Override
    public <T> void setProperty(@NotNull String name, @NotNull T value) {
        this.beforeWrite();
        super.setProperty(name, value);
        this.root.updated();
    }

    @Override
    public <T> void setProperty(@NotNull String name, @NotNull T value, @NotNull Type<T> type) {
        this.beforeWrite();
        super.setProperty(name, value, type);
        this.root.updated();
    }

    @Override
    public void removeProperty(@NotNull String name) {
        this.beforeWrite();
        super.removeProperty(name);
        this.root.updated();
    }

    void setParentAndName(@NotNull MutableTree parent, @NotNull String name) {
        this.name = Preconditions.checkNotNull(name);
        this.parent = Preconditions.checkNotNull(parent);
    }

    boolean moveTo(@NotNull MutableTree newParent, @NotNull String newName) {
        this.name = Preconditions.checkNotNull(newName);
        this.parent = Preconditions.checkNotNull(newParent);
        boolean success = this.nodeBuilder.moveTo(newParent.nodeBuilder, newName);
        if (success) {
            this.parent.updateChildOrder(false);
            newParent.updateChildOrder(false);
        }
        return success;
    }

    @NotNull
    MutableTree getTree(@NotNull String path) {
        Preconditions.checkArgument(PathUtils.isAbsolute(Preconditions.checkNotNull(path)));
        this.beforeRead();
        MutableTree child = this;
        for (String name : PathUtils.elements(path)) {
            child = new MutableTree(this.root, this.pendingMoves, child, child.nodeBuilder.getChildNode(name), name);
        }
        return child;
    }

    @NotNull
    String getPathInternal() {
        if (this.parent == null) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        this.buildPath(sb);
        return sb.toString();
    }

    @Override
    protected void buildPath(@NotNull StringBuilder sb) {
        if (this.parent != null) {
            this.parent.buildPath(Preconditions.checkNotNull(sb));
            sb.append('/').append(this.name);
        }
    }

    private void reconnect() {
        if (this.parent != null) {
            this.parent.reconnect();
            this.nodeBuilder = this.parent.nodeBuilder.getChildNode(this.name);
        }
    }

    private void beforeRead() throws IllegalStateException {
        this.root.checkLive();
        if (this.applyPendingMoves()) {
            this.reconnect();
        }
    }

    private void beforeWrite() throws IllegalStateException {
        this.beforeRead();
        if (!super.exists()) {
            throw new IllegalStateException("The tree for " + super.getPath() + " does not exist");
        }
    }

    private boolean applyPendingMoves() {
        boolean movesApplied = false;
        if (this.parent != null) {
            movesApplied = this.parent.applyPendingMoves();
        }
        MutableRoot.Move old = this.pendingMoves;
        this.pendingMoves = this.pendingMoves.apply(this);
        if (this.pendingMoves != old) {
            movesApplied = true;
        }
        return movesApplied;
    }
}

