/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.internal;

import java.util.Set;
import sling-mock-oak.com.google.common.collect.Sets;

class Preconditions {
    private final Set<String> preconditions = Sets.newHashSet();
    private final Set<String> candidates = Sets.newHashSet();
    private boolean dirty = false;
    private boolean satisfied = true;

    Preconditions() {
    }

    public void addPrecondition(String precondition) {
        if (this.preconditions.add(precondition)) {
            this.dirty = true;
        }
    }

    public void clearPreconditions() {
        this.preconditions.clear();
        this.dirty = false;
        this.satisfied = true;
    }

    public void addCandidate(String candidate) {
        if (this.candidates.add(candidate)) {
            this.dirty = true;
        }
    }

    public void removeCandidate(String candidate) {
        if (this.candidates.remove(candidate)) {
            this.dirty = true;
        }
    }

    public boolean areSatisfied() {
        if (this.dirty) {
            this.satisfied = this.candidates.containsAll(this.preconditions);
            this.dirty = false;
        }
        return this.satisfied;
    }

    public String toString() {
        return String.format("Preconditions(preconditions = %s, candidates = %s)", this.preconditions, this.candidates);
    }
}

