/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.AbstractTypeDefinition;
import sling-mock-oak.com.google.common.base.Preconditions;

class ItemDefinitionImpl
extends AbstractTypeDefinition
implements ItemDefinition {
    private final NodeType type;

    protected ItemDefinitionImpl(Tree definition, NodeType type, NamePathMapper mapper) {
        super(definition, mapper);
        this.type = Preconditions.checkNotNull(type);
    }

    public NodeType getDeclaringNodeType() {
        return this.type;
    }

    public String getName() {
        String oakName = this.getName("jcr:name");
        if (oakName != null) {
            return this.mapper.getJcrName(oakName);
        }
        return "*";
    }

    public boolean isAutoCreated() {
        return this.getBoolean("jcr:autoCreated");
    }

    public boolean isMandatory() {
        return this.getBoolean("jcr:mandatory");
    }

    public int getOnParentVersion() {
        String action = this.getString("jcr:onParentVersion");
        if (action != null) {
            return OnParentVersionAction.valueFromName((String)action);
        }
        return 1;
    }

    public boolean isProtected() {
        return this.getBoolean("jcr:protected");
    }

    public String toString() {
        return this.getName();
    }
}

