/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.importer;

import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfo;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.importer.AsyncIndexerLock;
import org.apache.jackrabbit.oak.plugins.index.importer.SimpleToken;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Preconditions;

public class AbortingIndexerLock
implements AsyncIndexerLock<SimpleToken> {
    public static final int TIMEOUT_SECONDS = 300;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AsyncIndexInfoService infoService;
    private final Clock clock;

    public AbortingIndexerLock(AsyncIndexInfoService infoService) {
        this(infoService, Clock.SIMPLE);
    }

    public AbortingIndexerLock(AsyncIndexInfoService infoService, Clock clock) {
        this.infoService = infoService;
        this.clock = clock;
    }

    @Override
    public SimpleToken lock(String asyncIndexerLane) {
        IndexStatsMBean mbean = this.getIndexStatsMBean(asyncIndexerLane);
        if ("running".equals(mbean.getStatus())) {
            this.log.info("Aborting current indexing run of async indexer for lane [{}]", (Object)asyncIndexerLane);
        }
        mbean.abortAndPause();
        this.retry(mbean, 300, 1000);
        this.log.info("Aborted and paused async indexer for lane [{}]", (Object)asyncIndexerLane);
        return new SimpleToken(asyncIndexerLane);
    }

    @Override
    public void unlock(SimpleToken token) {
        this.getIndexStatsMBean(token.laneName).resume();
        this.log.info("Resumed async indexer for lane [{}]", (Object)token.laneName);
    }

    private IndexStatsMBean getIndexStatsMBean(String asyncIndexerLane) {
        AsyncIndexInfo info = this.infoService.getInfo(asyncIndexerLane);
        Preconditions.checkNotNull(info, "No AsyncIndexInfo found for lane [%s]", asyncIndexerLane);
        IndexStatsMBean mbean = info.getStatsMBean();
        return Preconditions.checkNotNull(mbean, "No IndexStatsMBean associated with [%s]", asyncIndexerLane);
    }

    private void retry(IndexStatsMBean mbean, int timeoutSeconds, int intervalBetweenTriesMsec) {
        long timeout = this.clock.getTime() + (long)timeoutSeconds * 1000L;
        while (this.clock.getTime() < timeout) {
            try {
                if (!"running".equals(mbean.getStatus())) {
                    return;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                int delta = (int)(timeout - this.clock.getTime() / 1000L);
                this.log.info("Async indexer for lane [{}] found to be running. Would wait for {} seconds more for it to stop", (Object)mbean.getName(), (Object)delta);
                Thread.sleep(intervalBetweenTriesMsec);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        throw new IllegalStateException("RetryLoop failed, condition is false after " + timeoutSeconds + " seconds");
    }
}

