/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.query;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Filter {
    public static final Filter EMPTY_FILTER = new Filter(){
        private final QueryLimits EMPTY_LIMITS = new QueryLimits(){

            @Override
            public long getLimitInMemory() {
                return Long.MAX_VALUE;
            }

            @Override
            public long getLimitReads() {
                return Long.MAX_VALUE;
            }

            @Override
            public boolean getFullTextComparisonWithoutIndex() {
                return false;
            }

            @Override
            public boolean getFailTraversal() {
                return false;
            }
        };

        @Override
        public Collection<PropertyRestriction> getPropertyRestrictions() {
            return Collections.emptyList();
        }

        @Override
        public Collection<String> getFulltextConditions() {
            return Collections.emptyList();
        }

        @Override
        public FullTextExpression getFullTextConstraint() {
            return null;
        }

        @Override
        public QueryLimits getQueryLimits() {
            return this.EMPTY_LIMITS;
        }

        @Override
        public boolean isAccessible(String path) {
            return false;
        }

        @Override
        public boolean containsNativeConstraint() {
            return false;
        }

        @Override
        public PropertyRestriction getPropertyRestriction(String propertyName) {
            return null;
        }

        @Override
        public List<PropertyRestriction> getPropertyRestrictions(String propertyName) {
            return Collections.emptyList();
        }

        @Override
        public PathRestriction getPathRestriction() {
            return PathRestriction.NO_RESTRICTION;
        }

        @Override
        public String getPath() {
            return "/";
        }

        @Override
        public String getPathPlan() {
            return PathRestriction.NO_RESTRICTION.toString();
        }

        @Override
        @Nullable
        public String getNodeType() {
            return null;
        }

        @Override
        public boolean matchesAllTypes() {
            return false;
        }

        @Override
        @NotNull
        public Set<String> getSupertypes() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Set<String> getPrimaryTypes() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Set<String> getMixinTypes() {
            return Collections.emptySet();
        }

        @Override
        @Nullable
        public String getQueryStatement() {
            return null;
        }

        @Override
        public boolean isAlwaysFalse() {
            return false;
        }
    };

    public Collection<PropertyRestriction> getPropertyRestrictions();

    @Deprecated
    public Collection<String> getFulltextConditions();

    public FullTextExpression getFullTextConstraint();

    public QueryLimits getQueryLimits();

    public boolean isAccessible(String var1);

    public boolean containsNativeConstraint();

    public PropertyRestriction getPropertyRestriction(String var1);

    public List<PropertyRestriction> getPropertyRestrictions(String var1);

    public PathRestriction getPathRestriction();

    public String getPath();

    public String getPathPlan();

    @Nullable
    public String getNodeType();

    public boolean matchesAllTypes();

    @NotNull
    public Set<String> getSupertypes();

    @NotNull
    public Set<String> getPrimaryTypes();

    @NotNull
    public Set<String> getMixinTypes();

    @Nullable
    public String getQueryStatement();

    public boolean isAlwaysFalse();

    public static enum PathRestriction {
        NO_RESTRICTION("*"),
        PARENT("/.."),
        EXACT(""),
        DIRECT_CHILDREN("/*"),
        ALL_CHILDREN("//*");

        private final String name;

        private PathRestriction(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class PropertyRestriction {
        public String propertyName;
        public PropertyValue first;
        public boolean firstIncluding;
        public PropertyValue last;
        public boolean lastIncluding;
        public boolean isLike;
        public List<PropertyValue> list;
        public int propertyType = 0;

        public boolean isNullRestriction() {
            return this.first == null && this.last == null && this.list == null && this.lastIncluding && this.firstIncluding;
        }

        public boolean isNotNullRestriction() {
            return this.first == null && this.last == null && this.list == null && !this.lastIncluding && !this.firstIncluding;
        }

        public String toString() {
            return (this.toStringFromTo() + " " + this.toStringList()).trim();
        }

        private String toStringList() {
            if (this.list == null) {
                return "";
            }
            StringBuilder buff = new StringBuilder("in(");
            int i = 0;
            for (PropertyValue p : this.list) {
                if (i++ > 0) {
                    buff.append(", ");
                }
                buff.append(p.toString());
            }
            buff.append(')');
            return buff.toString();
        }

        private String toStringFromTo() {
            String fi;
            String l;
            if (this.isNullRestriction()) {
                return "is null";
            }
            if (this.isNotNullRestriction()) {
                return "is not null";
            }
            String f = this.first == null ? "" : this.first.toString();
            String string = l = this.last == null ? "" : this.last.toString();
            if (f.equals(l)) {
                return f;
            }
            String string2 = this.first == null ? "" : (fi = this.firstIncluding ? "[" : "(");
            String li = this.last == null ? "" : (this.lastIncluding ? "]" : ")");
            return fi + f + ".." + l + li;
        }

        public int sortOrder() {
            if (this.first == null && this.last == null) {
                if (this.list == null) {
                    return 0;
                }
                return 5;
            }
            if (this.first == this.last) {
                return 10;
            }
            return 5;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
            result = 31 * result + (this.firstIncluding ? 1231 : 1237);
            result = 31 * result + (this.isLike ? 1231 : 1237);
            result = 31 * result + (this.last == null ? 0 : this.last.hashCode());
            result = 31 * result + (this.lastIncluding ? 1231 : 1237);
            result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
            result = 31 * result + (this.propertyName == null ? 0 : this.propertyName.hashCode());
            result = 31 * result + this.propertyType;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyRestriction other = (PropertyRestriction)obj;
            if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
                return false;
            }
            if (this.firstIncluding != other.firstIncluding) {
                return false;
            }
            if (this.isLike != other.isLike) {
                return false;
            }
            if (this.last == null ? other.last != null : !this.last.equals(other.last)) {
                return false;
            }
            if (this.lastIncluding != other.lastIncluding) {
                return false;
            }
            if (this.list == null ? other.list != null : !this.list.equals(other.list)) {
                return false;
            }
            if (this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName)) {
                return false;
            }
            return this.propertyType == other.propertyType;
        }
    }
}

