/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.namepath.impl.LocalNameMapper;
import org.apache.jackrabbit.oak.namepath.impl.NamePathMapperImpl;
import org.apache.jackrabbit.oak.query.ExecutionContext;
import org.apache.jackrabbit.oak.query.Query;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.SQL2Parser;
import org.apache.jackrabbit.oak.query.ast.NodeTypeInfoProvider;
import org.apache.jackrabbit.oak.query.stats.QueryStatsData;
import org.apache.jackrabbit.oak.query.xpath.XPathToSQL2Converter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.collect.ImmutableSet;

public abstract class QueryEngineImpl
implements QueryEngine {
    private static final AtomicInteger ID_COUNTER = new AtomicInteger();
    private static final String MDC_QUERY_ID = "oak.query.id";
    private static final String OAK_QUERY_ANALYZE = "oak.query.analyze";
    static final String SQL2 = "JCR-SQL2";
    static final String SQL = "sql";
    static final String XPATH = "xpath";
    static final String JQOM = "JCR-JQOM";
    static final String NO_LITERALS = "-noLiterals";
    static final Logger LOG = LoggerFactory.getLogger(QueryEngineImpl.class);
    private static final Set<String> SUPPORTED_LANGUAGES = ImmutableSet.of("JCR-SQL2", "JCR-SQL2-noLiterals", "sql", "sql-noLiterals", "xpath", "xpath-noLiterals", new String[]{"JCR-JQOM"});
    private boolean traversalEnabled = true;
    private QuerySelectionMode querySelectionMode = QuerySelectionMode.CHEAPEST;

    protected abstract ExecutionContext getExecutionContext();

    @Override
    public Set<String> getSupportedQueryLanguages() {
        return SUPPORTED_LANGUAGES;
    }

    @Override
    public List<String> getBindVariableNames(String statement, String language, Map<String, String> mappings) throws ParseException {
        List<Query> qs = QueryEngineImpl.parseQuery(statement, language, this.getExecutionContext(), mappings);
        return qs.iterator().next().getBindVariableNames();
    }

    private static List<Query> parseQuery(String statement, String language, ExecutionContext context, Map<String, String> mappings) throws ParseException {
        Query q;
        boolean isInternal = SQL2Parser.isInternal(statement);
        if (isInternal) {
            LOG.trace("Parsing {} statement: {}", (Object)language, (Object)statement);
        } else {
            LOG.debug("Parsing {} statement: {}", (Object)language, (Object)statement);
        }
        NamePathMapperImpl mapper = new NamePathMapperImpl(new LocalNameMapper(context.getRoot(), mappings));
        NodeTypeInfoProvider nodeTypes = context.getNodeTypeInfoProvider();
        QueryEngineSettings settings = context.getSettings();
        settings.getQueryValidator().checkStatement(statement);
        QueryStatsData.QueryExecutionStats stats = settings.getQueryStatsReporter().getQueryExecution(statement, language);
        SQL2Parser parser = new SQL2Parser(mapper, nodeTypes, settings, stats);
        if (language.endsWith(NO_LITERALS)) {
            language = language.substring(0, language.length() - NO_LITERALS.length());
            parser.setAllowNumberLiterals(false);
            parser.setAllowTextLiterals(false);
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        if (SQL2.equals(language) || JQOM.equals(language)) {
            q = parser.parse(statement, false);
        } else if (SQL.equals(language)) {
            parser.setSupportSQL1(true);
            q = parser.parse(statement, false);
        } else if (XPATH.equals(language)) {
            XPathToSQL2Converter converter = new XPathToSQL2Converter();
            String sql2 = converter.convert(statement);
            LOG.debug("XPath > SQL2: {}", (Object)sql2);
            try {
                parser.setIncludeSelectorNameInWildcardColumns(false);
                q = parser.parse(sql2, false);
            }
            catch (ParseException e) {
                ParseException e2 = new ParseException(statement + " converted to SQL-2 " + e.getMessage(), 0);
                e2.initCause(e);
                throw e2;
            }
        } else {
            throw new ParseException("Unsupported language: " + language, 0);
        }
        if (q.isInternal()) {
            stats.setInternal(true);
        } else {
            stats.setThreadName(Thread.currentThread().getName());
        }
        queries.add(q);
        if (settings.isSql2Optimisation()) {
            if (q.isInternal()) {
                LOG.trace("Skipping optimisation as internal query.");
            } else {
                LOG.trace("Attempting optimisation");
                Query q2 = q.buildAlternativeQuery();
                if (q2 != q) {
                    LOG.debug("Alternative query available: {}", (Object)q2);
                    queries.add(q2);
                }
            }
        }
        for (Query query : queries) {
            try {
                query.init();
            }
            catch (Exception e) {
                ParseException e2 = new ParseException(query.getStatement() + ": " + e.getMessage(), 0);
                e2.initCause(e);
                throw e2;
            }
        }
        return queries;
    }

    @Override
    public Result executeQuery(String statement, String language, Map<String, ? extends PropertyValue> bindings, Map<String, String> mappings) throws ParseException {
        return this.executeQuery(statement, language, Long.MAX_VALUE, 0L, bindings, mappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result executeQuery(String statement, String language, long limit, long offset, Map<String, ? extends PropertyValue> bindings, Map<String, String> mappings) throws ParseException {
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit may not be negative, is: " + limit);
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset may not be negative, is: " + offset);
        }
        if (bindings == null) {
            bindings = NO_BINDINGS;
        }
        if (mappings == null) {
            mappings = NO_MAPPINGS;
        }
        ExecutionContext context = this.getExecutionContext();
        List<Query> queries = QueryEngineImpl.parseQuery(statement, language, context, mappings);
        for (Query q : queries) {
            q.setExecutionContext(context);
            q.setLimit(limit);
            q.setOffset(offset);
            if (bindings != null) {
                for (Map.Entry e : bindings.entrySet()) {
                    q.bindValue((String)e.getKey(), (PropertyValue)e.getValue());
                }
            }
            q.setTraversalEnabled(this.traversalEnabled);
        }
        boolean mdc = false;
        try {
            long start = System.nanoTime();
            Query query = this.prepareAndSelect(queries);
            query.getQueryExecutionStats().execute(System.nanoTime() - start);
            mdc = QueryEngineImpl.setupMDC(query);
            Result result = query.executeQuery();
            return result;
        }
        finally {
            if (mdc) {
                QueryEngineImpl.clearMDC();
            }
        }
    }

    @NotNull
    private Query prepareAndSelect(@NotNull List<Query> queries) {
        Query result = null;
        if (Preconditions.checkNotNull(queries).size() == 1) {
            result = queries.iterator().next();
            result.prepare();
            result.verifyNotPotentiallySlow();
            LOG.trace("No alternatives found. Query: {}", (Object)result);
        } else {
            double bestCost = Double.POSITIVE_INFINITY;
            boolean isPotentiallySlow = true;
            for (Query q : Preconditions.checkNotNull(queries)) {
                q.prepare();
                if (!q.isPotentiallySlow()) {
                    isPotentiallySlow = false;
                }
                double cost = q.getEstimatedCost();
                LOG.debug("cost: {} for query {}", (Object)cost, (Object)q);
                if (q.containsUnfilteredFullTextCondition()) {
                    LOG.debug("contains an unfiltered fulltext condition");
                    cost = Double.POSITIVE_INFINITY;
                }
                if (result != null && !(cost < bestCost)) continue;
                result = q;
                bestCost = cost;
            }
            switch (this.querySelectionMode) {
                case ORIGINAL: {
                    LOG.debug("Forcing the original SQL2 query to be executed by flag");
                    result = queries.get(0);
                    break;
                }
                case ALTERNATIVE: {
                    LOG.debug("Forcing the alternative SQL2 query to be executed by flag");
                    result = queries.get(1);
                    break;
                }
            }
            if (isPotentiallySlow) {
                result.verifyNotPotentiallySlow();
            }
        }
        return result;
    }

    protected void setTraversalEnabled(boolean traversalEnabled) {
        this.traversalEnabled = traversalEnabled;
    }

    private static boolean setupMDC(Query q) {
        boolean mdcEnabled = false;
        if (q.isMeasureOrExplainEnabled()) {
            MDC.put((String)OAK_QUERY_ANALYZE, (String)Boolean.TRUE.toString());
            mdcEnabled = true;
        }
        if (LOG.isDebugEnabled()) {
            MDC.put((String)MDC_QUERY_ID, (String)String.valueOf(ID_COUNTER.incrementAndGet()));
            mdcEnabled = true;
        }
        return mdcEnabled;
    }

    private static void clearMDC() {
        MDC.remove((String)MDC_QUERY_ID);
        MDC.remove((String)OAK_QUERY_ANALYZE);
    }

    protected void setQuerySelectionMode(@NotNull QuerySelectionMode querySelectionMode) {
        this.querySelectionMode = querySelectionMode;
    }

    public static enum QuerySelectionMode {
        CHEAPEST,
        ORIGINAL,
        ALTERNATIVE;

    }
}

