/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.name;

import java.util.Locale;
import java.util.Set;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import sling-mock-oak.com.google.common.collect.ImmutableSet;
import sling-mock-oak.com.google.common.collect.Iterables;

class NamespaceEditor
extends DefaultEditor {
    private static final boolean strictIntegrityCheck = Boolean.getBoolean("oak.strictIntegrityCheck");
    private final NodeBuilder builder;
    private boolean modified = false;
    private final NodeState namespaces;
    private static Set<String> jcrSystemNS = ImmutableSet.of("jcr", "nt", "mix", "sv");

    public NamespaceEditor(NodeState root, NodeBuilder builder) {
        this.namespaces = root.getChildNode("jcr:system").getChildNode("rep:namespaces");
        this.builder = builder;
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        String prefix = after.getName();
        if ("jcr:primaryType".equals(prefix)) {
            return;
        }
        if (this.namespaces.hasProperty(prefix)) {
            throw new CommitFailedException("Namespace", 1, "Namespace mapping already registered: " + prefix);
        }
        if (Namespaces.isValidPrefix(prefix)) {
            if (after.isArray() || !Type.STRING.equals(after.getType())) {
                throw new CommitFailedException("Namespace", 2, "Invalid namespace mapping: " + prefix);
            }
            if (prefix.toLowerCase(Locale.ENGLISH).startsWith("xml") && this.namespaces.hasProperty("xml")) {
                throw new CommitFailedException("Namespace", 3, "XML prefixes are reserved: " + prefix);
            }
            if (NamespaceEditor.containsValue(this.namespaces, after.getValue(Type.STRING))) {
                throw NamespaceEditor.modificationNotAllowed(prefix);
            }
        } else {
            throw new CommitFailedException("Namespace", 4, "Not a valid namespace prefix: " + prefix);
        }
        this.modified = true;
    }

    private static boolean containsValue(NodeState namespaces, String value) {
        return Iterables.contains(namespaces.getChildNode("rep:nsdata").getStrings("rep:uris"), value);
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        throw NamespaceEditor.modificationNotAllowed(after.getName());
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        if (jcrSystemNS.contains(before.getName())) {
            throw NamespaceEditor.modificationNotAllowed(before.getName());
        }
        this.modified = true;
    }

    private static CommitFailedException modificationNotAllowed(String prefix) {
        return new CommitFailedException("Namespace", 5, "Namespace modification not allowed: " + prefix);
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        if (!this.modified) {
            return;
        }
        Namespaces.buildIndexNode(this.builder.getChildNode("jcr:system").child("rep:namespaces"));
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        if ("rep:nsdata".equals(name) && !before.equals(after)) {
            if (strictIntegrityCheck) {
                throw NamespaceEditor.modificationNotAllowed(name);
            }
            this.modified = true;
        }
        return null;
    }
}

