/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration.version;

import java.util.Calendar;

public class VersionCopyConfiguration {
    private boolean removeTargetVersionHistory = false;
    private Calendar copyVersions;
    private Calendar copyOrphanedVersions;

    public VersionCopyConfiguration() {
        Calendar epoch = Calendar.getInstance();
        epoch.setTimeInMillis(0L);
        this.copyVersions = epoch;
        this.copyOrphanedVersions = epoch;
    }

    public void setCopyVersions(Calendar copyVersions) {
        this.copyVersions = copyVersions;
    }

    public void setCopyOrphanedVersions(Calendar copyOrphanedVersions) {
        this.copyOrphanedVersions = copyOrphanedVersions;
    }

    public void setRemoveTargetVersionHistory(boolean removeTargetVersionHistory) {
        this.removeTargetVersionHistory = removeTargetVersionHistory;
    }

    public Calendar getVersionsMinDate() {
        return this.copyVersions;
    }

    public Calendar getOrphanedMinDate() {
        if (this.copyVersions == null) {
            return this.copyVersions;
        }
        if (this.copyOrphanedVersions != null && this.copyVersions.after(this.copyOrphanedVersions)) {
            return this.copyVersions;
        }
        return this.copyOrphanedVersions;
    }

    public boolean removeTargetVersionHistory() {
        return this.removeTargetVersionHistory;
    }

    public boolean isCopyVersions() {
        return this.copyVersions != null;
    }

    public boolean skipOrphanedVersionsCopy() {
        return this.copyVersions == null || this.copyOrphanedVersions == null;
    }

    public boolean isCopyAll() {
        return this.copyVersions != null && this.copyVersions.getTimeInMillis() == 0L && this.copyOrphanedVersions != null && this.copyOrphanedVersions.getTimeInMillis() == 0L;
    }
}

