/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.collect.Iterables;

class SubtreePattern
implements RestrictionPattern {
    private static final String SEGMENT_DELIM = "/";
    private final String oakPath;
    private final int oakPathLength;
    private final String[] targets;
    private final String[] subtrees;

    SubtreePattern(@NotNull String oakPath, @NotNull Iterable<String> subtrees) {
        this.oakPath = oakPath;
        this.oakPathLength = oakPath.length();
        int size = Iterables.size(subtrees);
        ArrayList tl = new ArrayList(size);
        ArrayList sl = new ArrayList(size);
        subtrees.forEach(s -> {
            if (s != null && !s.isEmpty()) {
                if (s.endsWith(SEGMENT_DELIM)) {
                    sl.add(s);
                } else {
                    tl.add(s);
                    sl.add(s + SEGMENT_DELIM);
                }
            }
        });
        this.targets = tl.toArray(new String[0]);
        this.subtrees = sl.toArray(new String[0]);
    }

    @Override
    public boolean matches(@NotNull Tree tree, @Nullable PropertyState property) {
        String path = property == null ? tree.getPath() : PathUtils.concat(tree.getPath(), property.getName());
        return this.matches(path);
    }

    @Override
    public boolean matches(@NotNull String path) {
        if (path.indexOf(this.oakPath) != 0) {
            return false;
        }
        for (String subtree : this.subtrees) {
            if (path.indexOf(subtree, this.oakPathLength) <= -1) continue;
            return true;
        }
        for (String target : this.targets) {
            if (!path.endsWith(target)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches() {
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.oakPath, Arrays.hashCode(this.targets), Arrays.hashCode(this.subtrees));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SubtreePattern) {
            SubtreePattern other = (SubtreePattern)obj;
            return this.oakPath.equals(other.oakPath) && Arrays.equals(this.targets, other.targets) && Arrays.equals(this.subtrees, other.subtrees);
        }
        return false;
    }
}

