/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.JcrPathParser;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounter;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.query.ExecutionContext;
import org.apache.jackrabbit.oak.query.FilterIterators;
import org.apache.jackrabbit.oak.query.Query;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.QueryOptions;
import org.apache.jackrabbit.oak.query.ResultImpl;
import org.apache.jackrabbit.oak.query.ResultRowImpl;
import org.apache.jackrabbit.oak.query.UnionQueryImpl;
import org.apache.jackrabbit.oak.query.ast.AndImpl;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstElementFactory;
import org.apache.jackrabbit.oak.query.ast.AstVisitorBase;
import org.apache.jackrabbit.oak.query.ast.BindVariableValueImpl;
import org.apache.jackrabbit.oak.query.ast.ChildNodeImpl;
import org.apache.jackrabbit.oak.query.ast.ChildNodeJoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.CoalesceImpl;
import org.apache.jackrabbit.oak.query.ast.ColumnImpl;
import org.apache.jackrabbit.oak.query.ast.ComparisonImpl;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.DescendantNodeImpl;
import org.apache.jackrabbit.oak.query.ast.DescendantNodeJoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.EquiJoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.FirstImpl;
import org.apache.jackrabbit.oak.query.ast.FullTextSearchImpl;
import org.apache.jackrabbit.oak.query.ast.FullTextSearchScoreImpl;
import org.apache.jackrabbit.oak.query.ast.InImpl;
import org.apache.jackrabbit.oak.query.ast.JoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.JoinImpl;
import org.apache.jackrabbit.oak.query.ast.JoinType;
import org.apache.jackrabbit.oak.query.ast.LengthImpl;
import org.apache.jackrabbit.oak.query.ast.LiteralImpl;
import org.apache.jackrabbit.oak.query.ast.LowerCaseImpl;
import org.apache.jackrabbit.oak.query.ast.NativeFunctionImpl;
import org.apache.jackrabbit.oak.query.ast.NodeLocalNameImpl;
import org.apache.jackrabbit.oak.query.ast.NodeNameImpl;
import org.apache.jackrabbit.oak.query.ast.NotImpl;
import org.apache.jackrabbit.oak.query.ast.OrImpl;
import org.apache.jackrabbit.oak.query.ast.OrderingImpl;
import org.apache.jackrabbit.oak.query.ast.PathImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyInexistenceImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyValueImpl;
import org.apache.jackrabbit.oak.query.ast.SameNodeImpl;
import org.apache.jackrabbit.oak.query.ast.SameNodeJoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SimilarImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.ast.SpellcheckImpl;
import org.apache.jackrabbit.oak.query.ast.SuggestImpl;
import org.apache.jackrabbit.oak.query.ast.UpperCaseImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.query.index.TraversingIndex;
import org.apache.jackrabbit.oak.query.plan.ExecutionPlan;
import org.apache.jackrabbit.oak.query.plan.SelectorExecutionPlan;
import org.apache.jackrabbit.oak.query.stats.QueryStatsData;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.base.Strings;
import sling-mock-oak.com.google.common.collect.AbstractIterator;
import sling-mock-oak.com.google.common.collect.Lists;
import sling-mock-oak.com.google.common.collect.Maps;
import sling-mock-oak.com.google.common.collect.Ordering;

public class QueryImpl
implements Query {
    public static final UnsupportedOperationException TOO_MANY_UNION = new UnsupportedOperationException("Too many union queries");
    public static final int MAX_UNION = Integer.getInteger("oak.sql2MaxUnion", 1000);
    private static final Logger LOG = LoggerFactory.getLogger(QueryImpl.class);
    private static final String INDEX_UNAVAILABLE = "INDEX-UNAVAILABLE";
    private final QueryStatsData.QueryExecutionStats stats;
    private boolean potentiallySlowTraversalQueryLogged;
    private static final Ordering<QueryIndex> MINIMAL_COST_ORDERING = new Ordering<QueryIndex>(){

        @Override
        public int compare(QueryIndex left, QueryIndex right) {
            return Double.compare(left.getMinimumCost(), right.getMinimumCost());
        }
    };
    SourceImpl source;
    private String statement;
    final HashMap<String, PropertyValue> bindVariableMap = new HashMap();
    final HashMap<String, Integer> selectorIndexes = new HashMap();
    final ArrayList<SelectorImpl> selectors = new ArrayList();
    ConstraintImpl constraint;
    private boolean traversalEnabled = true;
    private QueryOptions queryOptions = new QueryOptions();
    private OrderingImpl[] orderings;
    private ColumnImpl[] columns;
    private boolean[] distinctColumns;
    private boolean explain;
    private boolean measure;
    private boolean distinct;
    private Optional<Long> limit = Optional.empty();
    private Optional<Long> offset = Optional.empty();
    private long size = -1L;
    private boolean prepared;
    private ExecutionContext context;
    private boolean init;
    private boolean isSortedByIndex;
    private final NamePathMapper namePathMapper;
    private double estimatedCost;
    private final QueryEngineSettings settings;
    private boolean warnedHidden;
    private boolean isInternal;
    private boolean potentiallySlowTraversalQuery;

    QueryImpl(String statement, SourceImpl source, ConstraintImpl constraint, ColumnImpl[] columns, NamePathMapper mapper, QueryEngineSettings settings, QueryStatsData.QueryExecutionStats stats) {
        this.statement = statement;
        this.source = source;
        this.constraint = constraint;
        this.columns = columns;
        this.namePathMapper = mapper;
        this.settings = settings;
        this.stats = stats;
    }

    @Override
    public void init() {
        final QueryImpl query = this;
        if (this.constraint != null) {
            this.constraint = this.constraint.simplify();
        }
        new AstVisitorBase(){

            @Override
            public boolean visit(BindVariableValueImpl node) {
                node.setQuery(query);
                QueryImpl.this.bindVariableMap.put(node.getBindVariableName(), null);
                return true;
            }

            @Override
            public boolean visit(ChildNodeImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            @Override
            public boolean visit(ChildNodeJoinConditionImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            @Override
            public boolean visit(CoalesceImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            @Override
            public boolean visit(FirstImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            @Override
            public boolean visit(ColumnImpl node) {
                node.setQuery(query);
                return true;
            }

            @Override
            public boolean visit(DescendantNodeImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            @Override
            public boolean visit(DescendantNodeJoinConditionImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            @Override
            public boolean visit(EquiJoinConditionImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            @Override
            public boolean visit(FullTextSearchImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return super.visit(node);
            }

            @Override
            public boolean visit(NativeFunctionImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return super.visit(node);
            }

            @Override
            public boolean visit(SimilarImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return super.visit(node);
            }

            @Override
            public boolean visit(SpellcheckImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return super.visit(node);
            }

            @Override
            public boolean visit(SuggestImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return super.visit(node);
            }

            @Override
            public boolean visit(FullTextSearchScoreImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            @Override
            public boolean visit(LiteralImpl node) {
                node.setQuery(query);
                return true;
            }

            @Override
            public boolean visit(NodeLocalNameImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            @Override
            public boolean visit(NodeNameImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            @Override
            public boolean visit(PathImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            @Override
            public boolean visit(PropertyExistenceImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            @Override
            public boolean visit(PropertyInexistenceImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            @Override
            public boolean visit(PropertyValueImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            @Override
            public boolean visit(SameNodeImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            @Override
            public boolean visit(SameNodeJoinConditionImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            @Override
            public boolean visit(SelectorImpl node) {
                String name = node.getSelectorName();
                if (QueryImpl.this.selectorIndexes.put(name, QueryImpl.this.selectors.size()) != null) {
                    throw new IllegalArgumentException("Two selectors with the same name: " + name);
                }
                QueryImpl.this.selectors.add(node);
                node.setQuery(query);
                return true;
            }

            @Override
            public boolean visit(LengthImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            @Override
            public boolean visit(UpperCaseImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            @Override
            public boolean visit(LowerCaseImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            @Override
            public boolean visit(ComparisonImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            @Override
            public boolean visit(InImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            @Override
            public boolean visit(AndImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            @Override
            public boolean visit(OrImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            @Override
            public boolean visit(NotImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }
        }.visit(this);
        this.source.setQueryConstraint(this.constraint);
        for (ColumnImpl column : this.columns) {
            column.bindSelector(this.source);
        }
        this.distinctColumns = new boolean[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            ColumnImpl c = this.columns[i];
            boolean distinct = true;
            String propName = c.getPropertyName();
            if ("jcr:score".equals(propName) || propName.startsWith("rep:facet(")) {
                distinct = false;
            }
            this.distinctColumns[i] = distinct;
        }
        this.init = true;
    }

    @Override
    public ColumnImpl[] getColumns() {
        return this.columns;
    }

    public ConstraintImpl getConstraint() {
        return this.constraint;
    }

    @Override
    public Optional<Long> getLimit() {
        return this.limit;
    }

    @Override
    public Optional<Long> getOffset() {
        return this.offset;
    }

    public OrderingImpl[] getOrderings() {
        return this.orderings;
    }

    public SourceImpl getSource() {
        return this.source;
    }

    @Override
    public void bindValue(String varName, PropertyValue value) {
        this.bindVariableMap.put(varName, value);
    }

    @Override
    public void setLimit(long limit) {
        this.limit = Optional.of(limit);
    }

    @Override
    public void setOffset(long offset) {
        this.offset = Optional.of(offset);
    }

    @Override
    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    @Override
    public void setMeasure(boolean measure) {
        this.measure = measure;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public ResultImpl executeQuery() {
        return new ResultImpl(this);
    }

    private String getWarningForPathFilterMismatch() {
        StringBuilder buff = null;
        for (SelectorImpl s : this.selectors) {
            if (s.getExecutionPlan() == null || s.getExecutionPlan().getIndexPlan() == null || !s.getExecutionPlan().getIndexPlan().logWarningForPathFilterMismatch()) continue;
            if (buff == null) {
                buff = new StringBuilder();
            }
            if (buff.length() > 0) {
                buff.append(", ");
            }
            buff.append(s.getExecutionPlan().getIndexPlanName());
        }
        return buff == null ? null : buff.toString();
    }

    private void logAdditionalMessages() {
        for (SelectorImpl s : this.selectors) {
            if (s.getExecutionPlan() == null || s.getExecutionPlan().getIndexPlan() == null) continue;
            s.getExecutionPlan().getIndexPlan().getAdditionalMessages().forEach((level, list) -> {
                switch (level) {
                    case TRACE: {
                        for (String msg : list) {
                            LOG.trace(msg);
                        }
                        break;
                    }
                    case DEBUG: {
                        for (String msg : list) {
                            LOG.debug(msg);
                        }
                        break;
                    }
                    case INFO: {
                        for (String msg : list) {
                            LOG.info(msg);
                        }
                        break;
                    }
                    case WARN: {
                        for (String msg : list) {
                            LOG.warn(msg);
                        }
                        break;
                    }
                    case ERROR: {
                        for (String msg : list) {
                            LOG.error(msg);
                        }
                        break;
                    }
                }
            });
        }
    }

    @Override
    public Iterator<ResultRowImpl> getRows() {
        this.prepare();
        String warn = this.getWarningForPathFilterMismatch();
        if (warn != null) {
            LOG.warn("Index definition of index used have path restrictions and query won't return nodes from those restricted paths; query={}, plan={}", (Object)this.statement, (Object)warn);
        }
        this.logAdditionalMessages();
        if (this.explain) {
            String plan = this.getPlan();
            if (this.measure) {
                plan = plan + " cost: { " + this.getIndexCostInfo() + " }";
            }
            this.columns = new ColumnImpl[]{new ColumnImpl("explain", "plan", "plan"), new ColumnImpl("explain", "statement", "statement")};
            ResultRowImpl r = new ResultRowImpl(this, Tree.EMPTY_ARRAY, new PropertyValue[]{PropertyValues.newString(plan), PropertyValues.newString(this.getStatement().replaceFirst("(?i)\\bexplain\\s+", ""))}, null, null);
            return Arrays.asList(r).iterator();
        }
        if (LOG.isDebugEnabled()) {
            this.logDebug("query execute " + this.statement);
            this.logDebug("query plan " + this.getPlan());
        }
        final RowIterator rowIt = new RowIterator(this.context.getBaseState());
        Comparator<ResultRowImpl> orderBy = this.isSortedByIndex ? null : ResultRowImpl.getComparator(this.orderings);
        long localLimit = this.limit.orElse(Long.MAX_VALUE);
        long localOffset = this.offset.orElse(0L);
        MeasuringIterator it = FilterIterators.newCombinedFilter(rowIt, this.distinct, localLimit, localOffset, orderBy, this.settings);
        if (orderBy != null) {
            it.hasNext();
            long read = rowIt.getReadCount();
            read = Math.min(QueryImpl.saturatedAdd(localLimit, localOffset), read);
            this.size = read = Math.max(0L, read - localOffset);
        }
        if (this.measure) {
            it = new MeasuringIterator(this, it){

                @Override
                protected void setColumns(ColumnImpl[] col) {
                    QueryImpl.access$002(QueryImpl.this, col);
                }

                @Override
                protected long getReadCount() {
                    return rowIt.getReadCount();
                }

                @Override
                protected Map<String, Long> getSelectorScanCount() {
                    HashMap<String, Long> selectorReadCounts = Maps.newHashMap();
                    for (SelectorImpl selector : QueryImpl.this.selectors) {
                        selectorReadCounts.put(selector.getSelectorName(), selector.getScanCount());
                    }
                    return selectorReadCounts;
                }
            };
        }
        return it;
    }

    @Override
    public boolean isSortedByIndex() {
        return this.isSortedByIndex;
    }

    private boolean canSortByIndex() {
        List<QueryIndex.OrderEntry> list;
        QueryIndex.IndexPlan plan;
        boolean canSortByIndex = false;
        if (this.orderings != null && this.selectors.size() == 1 && (plan = this.selectors.get(0).getExecutionPlan().getIndexPlan()) != null && (list = plan.getSortOrder()) != null && list.size() == this.orderings.length) {
            canSortByIndex = true;
            for (int i = 0; i < list.size(); ++i) {
                QueryIndex.OrderEntry e = list.get(i);
                OrderingImpl o = this.orderings[i];
                DynamicOperandImpl op = o.getOperand();
                String pn = op.getOrderEntryPropertyName(this.selectors.get(0));
                if (pn == null || !pn.equals(e.getPropertyName())) {
                    canSortByIndex = false;
                    break;
                }
                if (o.isDescending() == (e.getOrder() == QueryIndex.OrderEntry.Order.DESCENDING)) continue;
                canSortByIndex = false;
                break;
            }
        }
        return canSortByIndex;
    }

    @Override
    public String getPlan() {
        return this.source.getPlan(this.context.getBaseState());
    }

    @Override
    public String getIndexCostInfo() {
        return this.source.getIndexCostInfo(this.context.getBaseState());
    }

    @Override
    public double getEstimatedCost() {
        return this.estimatedCost;
    }

    @Override
    public void prepare() {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        List<SourceImpl> sources = this.source.getInnerJoinSelectors();
        List<JoinConditionImpl> conditions = this.source.getInnerJoinConditions();
        if (sources.size() <= 1) {
            this.estimatedCost = this.source.prepare().getEstimatedCost();
            this.isSortedByIndex = this.canSortByIndex();
            return;
        }
        SourceImpl result = null;
        HashSet<SourceImpl> available = new HashSet<SourceImpl>();
        boolean isPotentiallySlowJoin = true;
        while (sources.size() > 0) {
            int bestIndex = 0;
            double bestCost = Double.POSITIVE_INFINITY;
            ExecutionPlan bestPlan = null;
            SourceImpl best = null;
            for (int i = 0; i < sources.size(); ++i) {
                SourceImpl test = QueryImpl.buildJoin(result, sources.get(i), conditions);
                if (test == null) continue;
                ExecutionPlan testPlan = test.prepare();
                double cost = testPlan.getEstimatedCost();
                if (best == null || cost < bestCost) {
                    bestPlan = testPlan;
                    bestCost = cost;
                    bestIndex = i;
                    best = test;
                }
                if (!this.potentiallySlowTraversalQuery) {
                    isPotentiallySlowJoin = false;
                }
                test.unprepare();
            }
            available.add(sources.remove(bestIndex));
            result = best;
            best.prepare(bestPlan);
        }
        this.potentiallySlowTraversalQuery = isPotentiallySlowJoin;
        this.estimatedCost = result.prepare().getEstimatedCost();
        this.source = result;
        this.isSortedByIndex = this.canSortByIndex();
    }

    private static SourceImpl buildJoin(SourceImpl result, SourceImpl last, List<JoinConditionImpl> conditions) {
        if (result == null) {
            return last;
        }
        List<SourceImpl> selectors = result.getInnerJoinSelectors();
        HashSet<SourceImpl> oldSelectors = new HashSet<SourceImpl>();
        oldSelectors.addAll(selectors);
        HashSet<SourceImpl> newSelectors = new HashSet<SourceImpl>();
        newSelectors.addAll(selectors);
        newSelectors.add(last);
        for (JoinConditionImpl j : conditions) {
            if (j.canEvaluate(oldSelectors) || !j.canEvaluate(newSelectors)) continue;
            JoinImpl join = new JoinImpl(result, last, JoinType.INNER, j);
            return join;
        }
        return null;
    }

    Filter createFilter(boolean preparing) {
        return this.source.createFilter(preparing);
    }

    ResultRowImpl currentRow() {
        PropertyValue[] orderValues;
        int selectorCount = this.selectors.size();
        Tree[] trees = new Tree[selectorCount];
        for (int i = 0; i < selectorCount; ++i) {
            SelectorImpl s = this.selectors.get(i);
            trees[i] = s.currentTree();
        }
        int columnCount = this.columns.length;
        PropertyValue[] values = new PropertyValue[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            ColumnImpl c = this.columns[i];
            values[i] = c.currentProperty();
        }
        if (this.orderings == null) {
            orderValues = null;
        } else {
            int size = this.orderings.length;
            orderValues = new PropertyValue[size];
            for (int i = 0; i < size; ++i) {
                orderValues[i] = this.orderings[i].getOperand().currentProperty();
            }
        }
        return new ResultRowImpl(this, trees, values, this.distinctColumns, orderValues);
    }

    @Override
    public int getSelectorIndex(String selectorName) {
        Integer index = this.selectorIndexes.get(selectorName);
        if (index == null) {
            throw new IllegalArgumentException("Unknown selector: " + selectorName);
        }
        return index;
    }

    @Override
    public int getColumnIndex(String columnName) {
        return QueryImpl.getColumnIndex(this.columns, columnName);
    }

    static int getColumnIndex(ColumnImpl[] columns, String columnName) {
        int size = columns.length;
        for (int i = 0; i < size; ++i) {
            ColumnImpl c = columns[i];
            String cn = c.getColumnName();
            if (cn == null || !cn.equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    public PropertyValue getBindVariableValue(String bindVariableName) {
        PropertyValue v = this.bindVariableMap.get(bindVariableName);
        if (v == null) {
            throw new IllegalArgumentException("Bind variable value not set: " + bindVariableName);
        }
        return v;
    }

    @Override
    public String[] getSelectorNames() {
        String[] list = new String[this.selectors.size()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = this.selectors.get(i).getSelectorName();
        }
        Collections.reverse(Arrays.asList(list));
        return list;
    }

    @Override
    public List<String> getBindVariableNames() {
        return new ArrayList<String>(this.bindVariableMap.keySet());
    }

    @Override
    public void setTraversalEnabled(boolean traversalEnabled) {
        this.traversalEnabled = traversalEnabled;
    }

    @Override
    public void setQueryOptions(QueryOptions options) {
        this.queryOptions = options;
    }

    public SelectorExecutionPlan getBestSelectorExecutionPlan(FilterImpl filter) {
        return this.getBestSelectorExecutionPlan(this.context.getBaseState(), filter, this.context.getIndexProvider(), this.traversalEnabled);
    }

    private SelectorExecutionPlan getBestSelectorExecutionPlan(NodeState rootState, FilterImpl filter, QueryIndexProvider indexProvider, boolean traversalEnabled) {
        QueryIndex bestIndex = null;
        if (LOG.isDebugEnabled()) {
            this.logDebug("cost using filter " + filter);
        }
        double bestCost = Double.POSITIVE_INFINITY;
        QueryIndex.IndexPlan bestPlan = null;
        QueryIndex almostBestIndex = null;
        double almostBestCost = Double.POSITIVE_INFINITY;
        QueryIndex.IndexPlan almostBestPlan = null;
        long maxEntryCount = QueryImpl.saturatedAdd(this.offset.orElse(0L), this.limit.orElse(Long.MAX_VALUE));
        List<? extends QueryIndex> queryIndexes = MINIMAL_COST_ORDERING.sortedCopy(indexProvider.getQueryIndexes(rootState));
        List<QueryIndex.OrderEntry> sortOrder = this.getSortOrder(filter);
        for (int i = 0; i < queryIndexes.size(); ++i) {
            double cost;
            QueryIndex index = queryIndexes.get(i);
            double minCost = index.getMinimumCost();
            if (minCost > bestCost) {
                if (Math.abs(minCost - bestIndex.getMinimumCost()) < 1.0E-5) {
                    LOG.debug("minCost: {} of index :{} > best Cost: {} from index: {}, but both indexes have same minimum cost - cost evaluation will continue", new Object[]{minCost, index.getIndexName(), bestCost, bestIndex.getIndexName()});
                } else {
                    LOG.debug("minCost: {} of index :{} < best Cost: {} from index: {}. Further index evaluation will be skipped", new Object[]{minCost, index.getIndexName(), bestCost, bestIndex.getIndexName()});
                    break;
                }
            }
            String indexName = index.getIndexName();
            QueryIndex.IndexPlan indexPlan = null;
            if (index instanceof QueryIndex.AdvancedQueryIndex) {
                QueryIndex.AdvancedQueryIndex advIndex = (QueryIndex.AdvancedQueryIndex)((Object)index);
                List<QueryIndex.IndexPlan> ipList = advIndex.getPlans(filter, sortOrder, rootState);
                cost = Double.POSITIVE_INFINITY;
                for (QueryIndex.IndexPlan p : ipList) {
                    long entryCount = p.getEstimatedEntryCount();
                    if (p.getSupportsPathRestriction()) {
                        entryCount = this.scaleEntryCount(rootState, filter, entryCount);
                    }
                    if (sortOrder == null || p.getSortOrder() != null) {
                        entryCount = Math.min(maxEntryCount, entryCount);
                    }
                    double c = p.getCostPerExecution() + (double)entryCount * p.getCostPerEntry();
                    if (LOG.isDebugEnabled()) {
                        String plan = advIndex.getPlanDescription(p, rootState);
                        String msg = String.format("cost for [%s] of type (%s) with plan [%s] is %1.2f", p.getPlanName(), indexName, plan, c);
                        this.logDebug(msg);
                    }
                    if (c < bestCost) {
                        almostBestCost = bestCost;
                        almostBestIndex = bestIndex;
                        almostBestPlan = bestPlan;
                        bestCost = c;
                        bestIndex = index;
                        bestPlan = p;
                        continue;
                    }
                    if (!(c - bestCost <= 0.1)) continue;
                    almostBestCost = c;
                    almostBestIndex = index;
                    almostBestPlan = p;
                }
                if (indexPlan != null && indexPlan.getPlanName() != null) {
                    indexName = indexName + "[" + indexPlan.getPlanName() + "]";
                }
            } else {
                cost = index.getCost(filter, rootState);
            }
            if (LOG.isDebugEnabled()) {
                this.logDebug("cost for " + indexName + " is " + cost);
            }
            if (cost < 0.0) {
                LOG.error("cost below 0 for " + indexName + " is " + cost);
            }
            if (cost < bestCost) {
                almostBestCost = bestCost;
                almostBestIndex = bestIndex;
                bestCost = cost;
                bestIndex = index;
                bestPlan = indexPlan;
                continue;
            }
            if (!(cost - bestCost <= 0.1)) continue;
            almostBestCost = cost;
            almostBestIndex = index;
        }
        if (LOG.isDebugEnabled() && Math.abs(bestCost - almostBestCost) <= 0.1) {
            String msg = bestPlan != null && almostBestPlan != null ? String.format("selected index %s with plan %s and %s with plan %s have similar costs %s and %s for query %s - check query explanation / index definitions", bestIndex, bestPlan.getPlanName(), almostBestIndex, almostBestPlan.getPlanName(), bestCost, almostBestCost, filter.toString()) : String.format("selected index %s and %s have similar costs %s and %s for query %s - check query explanation / index definitions", bestIndex, almostBestIndex, bestCost, almostBestCost, filter.toString());
            LOG.debug(msg);
        }
        boolean bl = this.potentiallySlowTraversalQuery = bestIndex == null;
        if (traversalEnabled) {
            TraversingIndex traversal = new TraversingIndex();
            double cost = traversal.getCost(filter, rootState);
            if (LOG.isDebugEnabled()) {
                this.logDebug("cost for " + traversal.getIndexName() + " is " + cost);
            }
            if (cost < bestCost || bestCost == Double.POSITIVE_INFINITY) {
                bestCost = cost;
                bestPlan = null;
                bestIndex = traversal;
                if (this.potentiallySlowTraversalQuery) {
                    this.potentiallySlowTraversalQuery = traversal.isPotentiallySlow(filter, rootState);
                }
            }
        }
        if (this.potentiallySlowTraversalQuery || bestIndex == null) {
            HistogramStats histogram;
            if (!filter.getFulltextConditions().isEmpty()) {
                LOG.warn("Fulltext query without index for filter {}; no results will be returned", (Object)filter);
            } else {
                LOG.debug("no proper index was found for filter {}", (Object)filter);
            }
            StatisticsProvider statisticsProvider = this.getSettings().getStatisticsProvider();
            if (statisticsProvider != null && (histogram = statisticsProvider.getHistogram(INDEX_UNAVAILABLE, StatsOptions.METRICS_ONLY)) != null) {
                histogram.update(1L);
            }
        }
        return new SelectorExecutionPlan(filter.getSelector(), bestIndex, bestPlan, bestCost);
    }

    private long scaleEntryCount(NodeState rootState, FilterImpl filter, long count) {
        Filter.PathRestriction r = filter.getPathRestriction();
        if (r != Filter.PathRestriction.ALL_CHILDREN) {
            return count;
        }
        String path = filter.getPath();
        if (path.startsWith("//")) {
            return count;
        }
        long filterPathCount = NodeCounter.getEstimatedNodeCount(rootState, path, true);
        if (filterPathCount < 0L) {
            return count;
        }
        long totalNodesCount = NodeCounter.getEstimatedNodeCount(rootState, "/", true);
        if (totalNodesCount <= 0L) {
            totalNodesCount = 1L;
        }
        long countScaledDown = (long)((double)count / (double)totalNodesCount * (double)filterPathCount);
        long mostNodesFromThisSubtree = (long)((double)filterPathCount * 0.8);
        count = Math.min(count, mostNodesFromThisSubtree);
        count = Math.max(count, countScaledDown);
        return count;
    }

    @Override
    public boolean isPotentiallySlow() {
        return this.potentiallySlowTraversalQuery;
    }

    @Override
    public void verifyNotPotentiallySlow() {
        if (this.potentiallySlowTraversalQuery) {
            QueryOptions.Traversal traversal = this.queryOptions.traversal;
            traversal = traversal == QueryOptions.Traversal.DEFAULT ? (this.settings.getFailTraversal() ? QueryOptions.Traversal.FAIL : QueryOptions.Traversal.WARN) : this.queryOptions.traversal;
            String message = "Traversal query (query without index): " + this.statement + "; consider creating an index";
            switch (traversal) {
                case DEFAULT: {
                    throw new AssertionError();
                }
                case OK: {
                    break;
                }
                case WARN: {
                    if (this.potentiallySlowTraversalQueryLogged) break;
                    LOG.warn(message);
                    this.potentiallySlowTraversalQueryLogged = true;
                    break;
                }
                case FAIL: {
                    LOG.debug(message);
                    throw new IllegalArgumentException(message);
                }
            }
        }
    }

    private List<QueryIndex.OrderEntry> getSortOrder(FilterImpl filter) {
        if (this.orderings == null) {
            return null;
        }
        ArrayList<QueryIndex.OrderEntry> sortOrder = new ArrayList<QueryIndex.OrderEntry>();
        for (OrderingImpl o : this.orderings) {
            DynamicOperandImpl op = o.getOperand();
            QueryIndex.OrderEntry e = op.getOrderEntry(filter.getSelector(), o);
            if (e == null) continue;
            sortOrder.add(e);
        }
        if (sortOrder.size() == 0) {
            return null;
        }
        return sortOrder;
    }

    private void logDebug(String msg) {
        if (this.isInternal) {
            LOG.trace(msg);
        } else {
            LOG.debug(msg);
        }
    }

    @Override
    public void setExecutionContext(ExecutionContext context) {
        this.context = context;
    }

    @Override
    public void setOrderings(OrderingImpl[] orderings) {
        this.orderings = orderings;
    }

    public NamePathMapper getNamePathMapper() {
        return this.namePathMapper;
    }

    @Override
    public Tree getTree(String path) {
        if (NodeStateUtils.isHiddenPath(path)) {
            if (!this.warnedHidden) {
                this.warnedHidden = true;
                LOG.warn("Hidden tree traversed: {}", (Object)path);
            }
            return null;
        }
        return this.context.getRoot().getTree(path);
    }

    @Override
    public boolean isMeasureOrExplainEnabled() {
        return this.explain || this.measure;
    }

    public String getOakPath(String path) {
        if (path == null) {
            return null;
        }
        if (!JcrPathParser.validate(path)) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        String p = this.namePathMapper.getOakPath(path);
        if (p == null) {
            throw new IllegalArgumentException("Invalid path or namespace prefix: " + path);
        }
        return p;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("select ");
        int i = 0;
        for (ColumnImpl columnImpl : this.columns) {
            if (i++ > 0) {
                buff.append(", ");
            }
            buff.append(columnImpl);
        }
        buff.append(" from ").append(this.source);
        if (this.constraint != null) {
            buff.append(" where ").append(this.constraint);
        }
        if (this.orderings != null) {
            buff.append(" order by ");
            i = 0;
            for (AstElement astElement : this.orderings) {
                if (i++ > 0) {
                    buff.append(", ");
                }
                buff.append(astElement);
            }
        }
        return buff.toString();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getSize(Result.SizePrecision precision, long max) {
        if (this.size != -1L) {
            return this.size;
        }
        return Math.min(this.limit.orElse(Long.MAX_VALUE), this.source.getSize(this.context.getBaseState(), precision, max));
    }

    @Override
    public String getStatement() {
        return Strings.isNullOrEmpty(this.statement) ? this.toString() : this.statement;
    }

    public QueryEngineSettings getSettings() {
        return this.settings;
    }

    @Override
    public void setInternal(boolean isInternal) {
        this.isInternal = isInternal;
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    public static long saturatedAdd(long x, long y) {
        BigInteger min = BigInteger.valueOf(Long.MIN_VALUE);
        BigInteger max = BigInteger.valueOf(Long.MAX_VALUE);
        BigInteger sum = BigInteger.valueOf(x).add(BigInteger.valueOf(y));
        return sum.min(max).max(min).longValue();
    }

    @Override
    public Query buildAlternativeQuery() {
        Query result = this;
        if (this.constraint != null) {
            Set<ConstraintImpl> unionList;
            try {
                unionList = this.constraint.convertToUnion();
            }
            catch (UnsupportedOperationException e) {
                return this;
            }
            if (unionList.size() > 1) {
                Query left = null;
                UnionQueryImpl right = null;
                for (ConstraintImpl c : unionList) {
                    if (right != null) {
                        right = this.newAlternativeUnionQuery(left, right);
                    } else if (left != null) {
                        right = left;
                    }
                    left = (QueryImpl)this.copyOf();
                    ((QueryImpl)left).constraint = (ConstraintImpl)AstElementFactory.copyElementAndCheckReference(c);
                    ((QueryImpl)left).statement = QueryImpl.recomposeStatement((QueryImpl)left);
                }
                result = this.newAlternativeUnionQuery(left, right);
            }
        }
        return result;
    }

    private static String recomposeStatement(@NotNull QueryImpl query) {
        Preconditions.checkNotNull(query);
        String original = query.getStatement();
        String origUpper = original.toUpperCase(Locale.ENGLISH);
        StringBuilder recomputed = new StringBuilder();
        String where = " WHERE ";
        String orderBy = " ORDER BY ";
        int whereOffset = " WHERE ".length();
        if (query.getConstraint() == null) {
            recomputed.append(original);
        } else {
            recomputed.append(original.substring(0, origUpper.indexOf(" WHERE ") + whereOffset));
            recomputed.append(query.getConstraint());
            if (origUpper.indexOf(" ORDER BY ") > -1) {
                recomputed.append(original.substring(origUpper.indexOf(" ORDER BY ")));
            }
        }
        return recomputed.toString();
    }

    private UnionQueryImpl newAlternativeUnionQuery(@NotNull Query left, @NotNull Query right) {
        UnionQueryImpl u = new UnionQueryImpl(false, Preconditions.checkNotNull(left, "`left` cannot be null"), Preconditions.checkNotNull(right, "`right` cannot be null"), this.settings);
        u.setExplain(this.explain);
        u.setMeasure(this.measure);
        u.setInternal(this.isInternal);
        u.setQueryOptions(this.queryOptions);
        u.setOrderings(this.orderings);
        return u;
    }

    @Override
    public Query copyOf() {
        if (this.isInit()) {
            throw new IllegalStateException("QueryImpl cannot be cloned once initialised.");
        }
        ArrayList<ColumnImpl> cols = Lists.newArrayList();
        for (ColumnImpl c : this.columns) {
            cols.add((ColumnImpl)AstElementFactory.copyElementAndCheckReference(c));
        }
        QueryImpl copy = new QueryImpl(this.statement, (SourceImpl)AstElementFactory.copyElementAndCheckReference(this.source), this.constraint, cols.toArray(new ColumnImpl[0]), this.namePathMapper, this.settings, this.stats);
        copy.explain = this.explain;
        copy.measure = this.measure;
        copy.isInternal = this.isInternal;
        copy.distinct = this.distinct;
        copy.queryOptions = this.queryOptions;
        return copy;
    }

    @Override
    public boolean isInit() {
        return this.init;
    }

    @Override
    public boolean isInternal() {
        return this.isInternal;
    }

    @Override
    public boolean containsUnfilteredFullTextCondition() {
        return this.constraint.containsUnfilteredFullTextCondition();
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public QueryStatsData.QueryExecutionStats getQueryExecutionStats() {
        return this.stats;
    }

    static /* synthetic */ ColumnImpl[] access$002(QueryImpl x0, ColumnImpl[] x1) {
        x0.columns = x1;
        return x1;
    }

    class RowIterator
    implements Iterator<ResultRowImpl> {
        private final NodeState rootState;
        private ResultRowImpl current;
        private boolean started;
        private boolean end;
        private long rowIndex;

        RowIterator(NodeState rootState) {
            this.rootState = rootState;
        }

        public long getReadCount() {
            return this.rowIndex;
        }

        private void fetchNext() {
            long oldIndex;
            long nanos;
            block5: {
                if (this.end) {
                    return;
                }
                nanos = System.nanoTime();
                oldIndex = this.rowIndex;
                if (!this.started) {
                    QueryImpl.this.source.execute(this.rootState);
                    this.started = true;
                }
                while (QueryImpl.this.source.next()) {
                    if (QueryImpl.this.constraint == null || QueryImpl.this.constraint.evaluate()) {
                        this.current = QueryImpl.this.currentRow();
                        ++this.rowIndex;
                    } else {
                        if (QueryImpl.this.constraint == null || !QueryImpl.this.constraint.evaluateStop()) continue;
                        this.current = null;
                        this.end = true;
                    }
                    break block5;
                }
                this.current = null;
                this.end = true;
            }
            nanos = System.nanoTime() - nanos;
            QueryImpl.this.stats.read(this.rowIndex - oldIndex, this.rowIndex, nanos);
        }

        @Override
        public boolean hasNext() {
            if (this.end) {
                return false;
            }
            if (this.current == null) {
                this.fetchNext();
            }
            return !this.end;
        }

        @Override
        public ResultRowImpl next() {
            if (this.end) {
                return null;
            }
            if (this.current == null) {
                this.fetchNext();
            }
            ResultRowImpl r = this.current;
            this.current = null;
            return r;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static abstract class MeasuringIterator
    extends AbstractIterator<ResultRowImpl> {
        private Iterator<ResultRowImpl> delegate;
        private Query query;
        private List<ResultRowImpl> results;
        private boolean init;

        MeasuringIterator(Query query, Iterator<ResultRowImpl> delegate) {
            this.query = query;
            this.delegate = delegate;
            this.results = Lists.newArrayList();
        }

        @Override
        protected ResultRowImpl computeNext() {
            if (!this.init) {
                this.getRows();
            }
            if (!this.results.isEmpty()) {
                return this.results.remove(0);
            }
            return (ResultRowImpl)this.endOfData();
        }

        void getRows() {
            while (this.delegate.hasNext()) {
                this.delegate.next();
            }
            ColumnImpl[] columns = new ColumnImpl[]{new ColumnImpl("measure", "selector", "selector"), new ColumnImpl("measure", "scanCount", "scanCount")};
            this.setColumns(columns);
            ResultRowImpl r = new ResultRowImpl(this.query, Tree.EMPTY_ARRAY, new PropertyValue[]{PropertyValues.newString("query"), PropertyValues.newLong(this.getReadCount())}, null, null);
            this.results.add(r);
            Map<String, Long> selectorScanCount = this.getSelectorScanCount();
            for (String selector : selectorScanCount.keySet()) {
                r = new ResultRowImpl(this.query, Tree.EMPTY_ARRAY, new PropertyValue[]{PropertyValues.newString(selector), PropertyValues.newLong(selectorScanCount.get(selector))}, null, null);
                this.results.add(r);
            }
            this.init = true;
        }

        protected abstract void setColumns(ColumnImpl[] var1);

        protected abstract Map<String, Long> getSelectorScanCount();

        protected abstract long getReadCount();

        protected Iterator<ResultRowImpl> getDelegate() {
            return this.delegate;
        }
    }
}

