/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.oak;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.testing.mock.sling.oak.ExtraSlingContent;
import org.apache.sling.testing.mock.sling.oak.impl.ComparableVersion;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingRepository.class})
public final class OakMockSlingRepository
implements SlingRepository {
    private static final String ADMIN_NAME = "admin";
    private static final String ADMIN_PASSWORD = "admin";
    private Repository repository;
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private static final Logger log = LoggerFactory.getLogger(OakMockSlingRepository.class);

    @Activate
    protected void activate(BundleContext bundleContext) throws IOException {
        String actualVersion;
        this.executor = Executors.newSingleThreadExecutor();
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        if (bundleContext.getServiceReference(Executor.class) == null) {
            bundleContext.registerService(Executor.class, (Object)this.executor, null);
        }
        Oak oak = new Oak().with(this.executor).with(this.scheduledExecutor);
        Jcr jcr = new Jcr(oak).with(new ExtraSlingContent()).with(this.executor).with(this.scheduledExecutor);
        this.repository = jcr.createRepository();
        String expectedVersion = OakMockSlingRepository.getExpectedVersion();
        if (new ComparableVersion(expectedVersion).compareTo(new ComparableVersion(actualVersion = this.repository.getDescriptor("jcr.repository.version"))) > 0) {
            throw new IllegalStateException("Unexpected (too old) Oak version " + actualVersion + ", expected " + expectedVersion + ". Make sure to load the `org.apache.sling.testing.sling-mock-oak` dependency before any other dependency which may transitively depend on Apache Jackrabbit Oak as well!");
        }
    }

    private static String getExpectedVersion() throws IOException {
        try (InputStream inputStream = OakMockSlingRepository.class.getResourceAsStream("oak.version");){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                string = reader.readLine();
            }
            return string;
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
        this.shutdownExecutorService(this.repository, "scheduledExecutor");
        ((JackrabbitRepository)this.repository).shutdown();
    }

    private void shutdownExecutorService(Object instance, String fieldName) {
        try {
            Field executorField = instance.getClass().getDeclaredField(fieldName);
            executorField.setAccessible(true);
            ExecutorService executor = (ExecutorService)executorField.get(instance);
            executor.shutdownNow();
        }
        catch (Throwable ex) {
            log.error("Potential Memory leak: Unable to shutdown executor service from field '" + fieldName + "' in " + instance, ex);
        }
    }

    public String getDescriptor(String key) {
        return this.repository.getDescriptor(key);
    }

    public String[] getDescriptorKeys() {
        return this.repository.getDescriptorKeys();
    }

    public String getDefaultWorkspace() {
        return "default";
    }

    public Session login() throws LoginException, RepositoryException {
        return this.repository.login();
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.repository.login(credentials, workspaceName == null ? this.getDefaultWorkspace() : workspaceName);
    }

    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return this.repository.login(credentials);
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.repository.login(workspaceName == null ? this.getDefaultWorkspace() : workspaceName);
    }

    public Session loginAdministrative(String workspaceName) throws RepositoryException {
        SimpleCredentials credentials = new SimpleCredentials("admin", "admin".toCharArray());
        return this.login((Credentials)credentials, workspaceName == null ? this.getDefaultWorkspace() : workspaceName);
    }

    public Session loginService(String subServiceName, String workspaceName) throws LoginException, RepositoryException {
        return this.loginAdministrative(workspaceName);
    }

    public Value getDescriptorValue(String key) {
        return this.repository.getDescriptorValue(key);
    }

    public Value[] getDescriptorValues(String key) {
        return this.repository.getDescriptorValues(key);
    }

    public boolean isSingleValueDescriptor(String key) {
        return this.repository.isSingleValueDescriptor(key);
    }

    public boolean isStandardDescriptor(String key) {
        return this.repository.isStandardDescriptor(key);
    }

    public Session impersonateFromService(String subServiceName, Credentials credentials, String workspaceName) throws LoginException, RepositoryException {
        return this.repository.login(credentials, workspaceName == null ? this.getDefaultWorkspace() : workspaceName);
    }
}

