/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.autosave;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.oak.security.user.autosave.AutoSaveEnabledManager;

final class AuthorizableWrapper<T extends Authorizable>
implements Function<T, T> {
    private final AutoSaveEnabledManager mgr;

    private AuthorizableWrapper(AutoSaveEnabledManager mgr) {
        this.mgr = mgr;
    }

    public T apply(T authorizable) {
        if (authorizable == null) {
            return null;
        }
        return (T)this.mgr.wrap((Authorizable)authorizable);
    }

    static Iterator<Authorizable> createIterator(Iterator<Authorizable> dlgs, AutoSaveEnabledManager mgr) {
        return Iterators.transform(dlgs, new AuthorizableWrapper(mgr));
    }

    static Iterator<Group> createGroupIterator(Iterator<Group> dlgs, AutoSaveEnabledManager mgr) {
        return Iterators.transform(dlgs, new AuthorizableWrapper(mgr));
    }
}

