/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

class RepMembersConflictHandler
implements ThreeWayConflictHandler {
    RepMembersConflictHandler() {
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution addExistingProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs) {
        if (RepMembersConflictHandler.isRepMembersProperty(theirs)) {
            RepMembersConflictHandler.mergeChange(parent, ours, theirs, (Set<String>)ImmutableSet.of());
            return ThreeWayConflictHandler.Resolution.MERGED;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution changeDeletedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState base) {
        if (RepMembersConflictHandler.isRepMembersProperty(ours)) {
            return ThreeWayConflictHandler.Resolution.THEIRS;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution changeChangedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs, @NotNull PropertyState base) {
        if (RepMembersConflictHandler.isRepMembersProperty(theirs)) {
            ImmutableSet baseMembers = ImmutableSet.copyOf(base.getValue(Type.STRINGS));
            RepMembersConflictHandler.mergeChange(parent, ours, theirs, (Set<String>)baseMembers);
            return ThreeWayConflictHandler.Resolution.MERGED;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution deleteDeletedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState base) {
        if (RepMembersConflictHandler.isRepMembersProperty(base)) {
            return ThreeWayConflictHandler.Resolution.MERGED;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution deleteChangedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState theirs, @NotNull PropertyState base) {
        if (RepMembersConflictHandler.isRepMembersProperty(theirs)) {
            return ThreeWayConflictHandler.Resolution.OURS;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution addExistingNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState ours, @NotNull NodeState theirs) {
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution changeDeletedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState ours, @NotNull NodeState base) {
        if (RepMembersConflictHandler.isMemberRefType(base)) {
            return ThreeWayConflictHandler.Resolution.THEIRS;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution deleteChangedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState theirs, @NotNull NodeState base) {
        if (RepMembersConflictHandler.isMemberRefType(base)) {
            return ThreeWayConflictHandler.Resolution.OURS;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution deleteDeletedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState base) {
        if (RepMembersConflictHandler.isMemberRefType(base)) {
            return ThreeWayConflictHandler.Resolution.MERGED;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    private static void mergeChange(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs, @NotNull Set<String> base) {
        PropertyBuilder<String> merged = PropertyBuilder.array(Type.WEAKREFERENCE);
        merged.setName("rep:members");
        ImmutableSet theirMembers = ImmutableSet.copyOf(theirs.getValue(Type.STRINGS));
        ImmutableSet ourMembers = ImmutableSet.copyOf(ours.getValue(Type.STRINGS));
        LinkedHashSet<String> combined = new LinkedHashSet<String>((Collection<String>)Sets.intersection((Set)ourMembers, (Set)theirMembers));
        for (String m : Sets.difference((Set)ourMembers, (Set)theirMembers)) {
            if (base.contains(m)) continue;
            combined.add(m);
        }
        for (String m : Sets.difference((Set)theirMembers, (Set)ourMembers)) {
            if (base.contains(m)) continue;
            combined.add(m);
        }
        merged.addValues(combined);
        parent.setProperty(merged.getPropertyState());
    }

    private static boolean isRepMembersProperty(PropertyState p) {
        return "rep:members".equals(p.getName());
    }

    private static boolean isMemberRefType(NodeState base) {
        String type = base.getName("jcr:primaryType");
        return "rep:MemberReferences".equals(type);
    }
}

