/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import com.google.common.collect.Lists;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.LongUtils;
import org.apache.jackrabbit.oak.security.authorization.ProviderCtx;
import org.apache.jackrabbit.oak.security.authorization.permission.NumEntries;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionProviderImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStore;
import org.apache.jackrabbit.oak.security.authorization.permission.PrincipalPermissionEntries;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MountPermissionProvider
extends PermissionProviderImpl {
    private final MountInfoProvider mountInfoProvider;

    @NotNull
    public static String getPermissionRootName(@NotNull Mount mount, @NotNull String workspace) {
        if (mount.isDefault()) {
            return workspace;
        }
        return mount.getPathFragmentName() + "-" + workspace;
    }

    public MountPermissionProvider(@NotNull Root root, @NotNull String workspaceName, @NotNull Set<Principal> principals, @NotNull RestrictionProvider restrictionProvider, @NotNull ConfigurationParameters options, @NotNull Context ctx, @NotNull ProviderCtx providerCtx) {
        super(root, workspaceName, principals, restrictionProvider, options, ctx, providerCtx);
        this.mountInfoProvider = providerCtx.getMountInfoProvider();
    }

    @Override
    @NotNull
    protected PermissionStore getPermissionStore(@NotNull Root root, @NotNull String workspaceName, @NotNull RestrictionProvider restrictionProvider) {
        ArrayList stores = Lists.newArrayList();
        stores.add(super.getPermissionStore(root, workspaceName, restrictionProvider));
        for (Mount m : this.mountInfoProvider.getNonDefaultMounts()) {
            String psRoot = MountPermissionProvider.getPermissionRootName(m, workspaceName);
            PermissionStore ps = super.getPermissionStore(root, psRoot, restrictionProvider);
            stores.add(ps);
        }
        return new MountPermissionStore(stores);
    }

    private static class MountPermissionStore
    implements PermissionStore {
        private final List<PermissionStore> stores;

        MountPermissionStore(List<PermissionStore> stores) {
            this.stores = stores;
        }

        @Override
        @Nullable
        public Collection<PermissionEntry> load(@NotNull String principalName, @NotNull String path) {
            for (PermissionStore store : this.stores) {
                Collection<PermissionEntry> col = store.load(principalName, path);
                if (col == null) continue;
                return col;
            }
            return null;
        }

        @Override
        @NotNull
        public PrincipalPermissionEntries load(@NotNull String principalName) {
            PrincipalPermissionEntries ppe = new PrincipalPermissionEntries();
            for (PermissionStore store : this.stores) {
                ppe.putAllEntries(store.load(principalName).getEntries());
            }
            ppe.setFullyLoaded(true);
            return ppe;
        }

        @Override
        @NotNull
        public NumEntries getNumEntries(@NotNull String principalName, long max) {
            long num = 0L;
            boolean isExact = true;
            for (PermissionStore store : this.stores) {
                NumEntries ne = store.getNumEntries(principalName, max);
                num = LongUtils.safeAdd(num, ne.size);
                if (!ne.isExact) {
                    isExact = false;
                }
                if (num < max || isExact) continue;
                break;
            }
            return NumEntries.valueOf(num, isExact);
        }

        @Override
        public void flush(@NotNull Root root) {
            for (PermissionStore store : this.stores) {
                store.flush(root);
            }
        }
    }
}

