/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniversalFilter
implements EventFilter {
    private final NodeState beforeState;
    private final NodeState afterState;
    private final Selector selector;
    private final Predicate<NodeState> predicate;

    public UniversalFilter(@NotNull NodeState before, @NotNull NodeState after, @NotNull Selector selector, @NotNull Predicate<NodeState> predicate) {
        this.beforeState = (NodeState)Preconditions.checkNotNull((Object)before);
        this.afterState = (NodeState)Preconditions.checkNotNull((Object)after);
        this.predicate = (Predicate)Preconditions.checkNotNull(predicate);
        this.selector = (Selector)Preconditions.checkNotNull((Object)selector);
    }

    @NotNull
    public NodeState getBeforeState() {
        return this.beforeState;
    }

    @NotNull
    public NodeState getAfterState() {
        return this.afterState;
    }

    @Override
    public boolean includeAdd(PropertyState after) {
        return this.predicate.test(this.selector.select(this, null, after));
    }

    @Override
    public boolean includeChange(PropertyState before, PropertyState after) {
        return this.predicate.test(this.selector.select(this, before, after));
    }

    @Override
    public boolean includeDelete(PropertyState before) {
        return this.predicate.test(this.selector.select(this, before, null));
    }

    @Override
    public boolean includeAdd(String name, NodeState after) {
        return this.predicate.test(this.selector.select(this, name, EmptyNodeState.MISSING_NODE, after));
    }

    @Override
    public boolean includeDelete(String name, NodeState before) {
        return this.predicate.test(this.selector.select(this, name, before, EmptyNodeState.MISSING_NODE));
    }

    @Override
    public boolean includeMove(String sourcePath, String name, NodeState moved) {
        return this.predicate.test(this.selector.select(this, name, EmptyNodeState.MISSING_NODE, moved));
    }

    @Override
    public boolean includeReorder(String destName, String name, NodeState reordered) {
        return this.predicate.test(this.selector.select(this, name, EmptyNodeState.MISSING_NODE, reordered));
    }

    @Override
    public EventFilter create(String name, NodeState before, NodeState after) {
        return new UniversalFilter(this.beforeState.getChildNode(name), this.afterState.getChildNode(name), this.selector, this.predicate);
    }

    public static interface Selector {
        @NotNull
        public NodeState select(@NotNull UniversalFilter var1, @Nullable PropertyState var2, @Nullable PropertyState var3);

        @NotNull
        public NodeState select(@NotNull UniversalFilter var1, @NotNull String var2, @NotNull NodeState var3, @NotNull NodeState var4);
    }
}

